/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.marker;

import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.ChartUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;

public abstract class Marker
implements XMLable {
    private static final long serialVersionUID = 6913605407851388493L;
    public static final String XML_TAG = "Marker";
    protected double size = 5.0;
    protected Color color;

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(Graphics2D graphics2D, double d, double d2) {
        Paint paint = graphics2D.getPaint();
        if (this.color != null) {
            graphics2D.setPaint(this.color);
        }
        this.paintMarker(graphics2D, d, d2);
        graphics2D.setPaint(paint);
    }

    protected abstract void paintMarker(Graphics2D var1, double var2, double var4);

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Style".equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttr("size");
            if (string != null) {
                this.size = Double.parseDouble(string);
            }
            if ((string = xMLableReader.getAttr("color")) != null) {
                this.color = new Color(Integer.parseInt(string), true);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Style").attr("size", this.size);
        if (this.color != null) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return this.getClass().isInstance(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("size", this.size);
        jSONObject.put("color", ChartUtils.color2JS(this.color));
        return jSONObject;
    }

    public abstract String getMarkerType();
}

