/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.math;

import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public final class Projection
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Projection";
    private byte mode = (byte)2;
    public static final byte ORTHO = 0;
    public static final byte PERSPECTIVE = 1;
    public static final byte RIGHT_ANGLE = 2;
    private int elevation = 15;
    private int rotation = 20;
    private int focus = 800;
    private boolean need_cal = true;
    private double sin_theta_alpha;
    private double cos_theta_alpha;
    private double sin_theta_beta;
    private double cos_theta_beta;

    public int getFocus() {
        return this.focus;
    }

    public void setFocus(int n) {
        this.focus = n;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        this.rotation = n;
        if (!this.need_cal) {
            this.need_cal = true;
        }
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int n) {
        this.elevation = n;
        if (!this.need_cal) {
            this.need_cal = true;
        }
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public Point2D projectee(double d, double d2, double d3) {
        this.calculateSINCOS();
        if (this.mode == 0) {
            return this.ortho_projectee(d, d2, d3);
        }
        if (this.mode == 1) {
            return this.perspective_projectee(d, d2, d3);
        }
        if (this.mode == 2) {
            return this.right_angle_projectee(d, d2, d3);
        }
        return new Point2D.Double(d, d2);
    }

    public Arc2D projecteeArc(double d, double d2, double d3, double d4) {
        this.calculateSINCOS();
        double d5 = (double)this.focus / (this.sin_theta_alpha * d + (double)this.focus);
        Arc2D.Double double_ = new Arc2D.Double(-d2 * d5, -d2 * d5 * this.sin_theta_alpha + d * this.cos_theta_alpha * d5, 2.0 * d2 * d5, 2.0 * d2 * d5 * this.sin_theta_alpha, d3 + (double)this.rotation, d4, 2);
        return double_;
    }

    private void calculateSINCOS() {
        if (!this.need_cal) {
            return;
        }
        this.sin_theta_alpha = Math.sin(Math.toRadians(this.elevation));
        this.cos_theta_alpha = Math.cos(Math.toRadians(this.elevation));
        this.sin_theta_beta = Math.sin(Math.toRadians(-this.rotation));
        this.cos_theta_beta = Math.cos(Math.toRadians(-this.rotation));
        this.need_cal = false;
    }

    private Point2D perspective_projectee(double d, double d2, double d3) {
        double d4 = d * this.cos_theta_beta + d3 * this.sin_theta_beta;
        double d5 = -d * this.sin_theta_alpha * this.sin_theta_beta + d2 * this.cos_theta_alpha + d3 * this.sin_theta_alpha * this.cos_theta_beta;
        double d6 = (double)this.focus / (this.cos_theta_alpha * this.sin_theta_beta * d + this.sin_theta_alpha * d2 - this.cos_theta_alpha * this.cos_theta_beta * d3 + (double)this.focus);
        return new Point2D.Float((float)(d4 * d6), (float)(d5 * d6));
    }

    private Point2D ortho_projectee(double d, double d2, double d3) {
        double d4 = d * this.cos_theta_beta + d3 * this.sin_theta_beta;
        double d5 = -d * this.sin_theta_alpha * this.sin_theta_beta + d2 * this.cos_theta_alpha + d3 * this.sin_theta_alpha * this.cos_theta_beta;
        return new Point2D.Float((float)d4, (float)d5);
    }

    private Point2D right_angle_projectee(double d, double d2, double d3) {
        double d4 = d + d3 * this.sin_theta_beta * 0.5;
        double d5 = d2 + d3 * this.sin_theta_alpha * 0.5;
        return new Point2D.Float((float)d4, (float)d5);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("mode");
            if (string != null) {
                this.setMode(Byte.parseByte(string));
            }
            if ((string = xMLableReader.getAttr("elevation")) != null) {
                this.setElevation(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("rotation")) != null) {
                this.setRotation(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("focus")) != null) {
                this.setFocus(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("mode", this.mode).attr("elevation", this.elevation).attr("rotation", this.rotation).attr("focus", this.focus).end();
    }

    public Object clone() throws CloneNotSupportedException {
        Projection projection = (Projection)super.clone();
        return projection;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Projection)) {
            return false;
        }
        Projection projection = (Projection)object;
        if (projection.getElevation() != this.getElevation()) {
            return false;
        }
        if (projection.getRotation() != this.getRotation()) {
            return false;
        }
        if (projection.getFocus() != this.getFocus()) {
            return false;
        }
        return projection.getMode() == this.getMode();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("mode", this.mode);
        jSONObject.put("elevation", this.elevation);
        jSONObject.put("focus", this.focus);
        jSONObject.put("rotation", this.rotation);
        jSONObject.put("need_cal", this.need_cal);
        jSONObject.put("sin_theta_alpha", this.sin_theta_alpha);
        jSONObject.put("sin_theta_beta", this.sin_theta_beta);
        jSONObject.put("cos_theta_alpha", this.cos_theta_alpha);
        jSONObject.put("cos_theta_beta", this.cos_theta_beta);
        return jSONObject;
    }
}

