/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.Area3DPlotGlyph;
import com.fr.chart.core.glyph.AreaCategory3DAxisGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxis3DGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxis3DGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.CategoryPlot;
import com.fr.data.ChartData;

public class Area3DPlot
extends CategoryPlot
implements Plot3D {
    private static final long serialVersionUID = -2168856417697999430L;
    private Projection projection = new Projection();
    private double seriesIntervalPercent = 1.0;
    private int deep = -1;

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Area3DPlotGlyph area3DPlotGlyph = new Area3DPlotGlyph();
        this.install4PlotGlyph(area3DPlotGlyph, chartData);
        this.installAxisGlyph(area3DPlotGlyph, chartData);
        return area3DPlotGlyph;
    }

    public void install4PlotGlyph(Area3DPlotGlyph area3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(area3DPlotGlyph, chartData);
        area3DPlotGlyph.setProjection(this.projection);
        area3DPlotGlyph.setDeep(this.deep);
        area3DPlotGlyph.setSeriesIntervalPercent(this.seriesIntervalPercent);
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, int n) {
        this.dealColorCondition(lineMarkerIcon, n);
    }

    public ValueAxisGlyph createValueAxisGlyph() {
        return new ValueAxis3DGlyph(this.valueAxis);
    }

    public CategoryAxisGlyph createCategoryAxisGlyph() {
        return new AreaCategory3DAxisGlyph(this.categoryAxis);
    }

    public CategoryAxisGlyph createDateAxisGlyph() {
        return new DateAxis3DGlyph(this.categoryAxis);
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Projection".equals(string)) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if ("Area3DAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("seriesIntervalPercent");
                if (string2 != null) {
                    this.seriesIntervalPercent = Double.parseDouble(string2);
                }
                if ((string2 = xMLableReader.getAttr("deep")) != null) {
                    this.deep = Integer.parseInt(string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Area3DAttr").attr("seriesIntervalPercent", this.seriesIntervalPercent);
        if (this.deep != -1) {
            xMLPrintWriter.attr("deep", this.deep);
        }
        xMLPrintWriter.end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Area3DPlot area3DPlot = (Area3DPlot)super.clone();
        if (this.projection != null) {
            area3DPlot.projection = (Projection)this.projection.clone();
        }
        return area3DPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Area3DPlot)) {
            return false;
        }
        Area3DPlot area3DPlot = (Area3DPlot)object;
        if (!super.equals(area3DPlot)) {
            return false;
        }
        if (area3DPlot.getDeep() != this.getDeep()) {
            return false;
        }
        if (area3DPlot.getSeriesIntervalPercent() != this.getSeriesIntervalPercent()) {
            return false;
        }
        return Equals.equals(area3DPlot.projection, this.projection);
    }
}

