/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.glyph.Bar2DPlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.plot.BarPlot;
import com.fr.data.ChartData;

public class Bar2DPlot
extends BarPlot {
    private static final long serialVersionUID = 7944953095383884004L;
    private boolean isSimulation3D = true;

    public Bar2DPlot() {
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        bar2DPlotGlyph.setSimulation3D(this.isSimulation3D);
        this.install4PlotGlyph(bar2DPlotGlyph, chartData);
        this.installAxisGlyph(bar2DPlotGlyph, chartData);
        return bar2DPlotGlyph;
    }

    public Bar2DPlot(boolean bl) {
        this.isHorizontal = bl;
    }

    public void setSimulation3D(boolean bl) {
        this.isSimulation3D = bl;
    }

    public boolean isSimulation3D() {
        return this.isSimulation3D;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getAttr("isSimulation3D")) != null) {
            this.setSimulation3D(Boolean.valueOf(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Bar2DAttr").attr("isSimulation3D", this.isSimulation3D).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bar2DPlot)) {
            return false;
        }
        Bar2DPlot bar2DPlot = (Bar2DPlot)object;
        if (!super.equals(bar2DPlot)) {
            return false;
        }
        return bar2DPlot.isSimulation3D == this.isSimulation3D;
    }
}

