/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.Bar3DPlotGlyph;
import com.fr.chart.core.glyph.CategoryAxis3DGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxis3DGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxis3DGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.BarPlot;
import com.fr.data.ChartData;
import java.awt.Insets;

public class Bar3DPlot
extends BarPlot
implements Plot3D {
    private static final long serialVersionUID = 3019714978415207642L;
    private boolean isCubic3D = true;
    private boolean isCascade = true;
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;
    private Projection projection = new Projection();
    private boolean horizontalDrawBar = false;

    public void setIsCascade(boolean bl) {
        this.isCascade = bl;
    }

    public boolean isCascade() {
        return this.isCascade;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public void setIsCubic3D(boolean bl) {
        this.isCubic3D = bl;
    }

    public boolean isCubic3D() {
        return this.isCubic3D;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public Insets createOuterIntsets() {
        return new Insets(10, 10, 20, 0);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Bar3DPlotGlyph bar3DPlotGlyph = new Bar3DPlotGlyph();
        this.install4PlotGlyph(bar3DPlotGlyph, chartData);
        this.installAxisGlyph(bar3DPlotGlyph, chartData);
        return bar3DPlotGlyph;
    }

    public void install4PlotGlyph(Bar3DPlotGlyph bar3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(bar3DPlotGlyph, chartData);
        bar3DPlotGlyph.setDeep(this.deep);
        bar3DPlotGlyph.setCascade(this.isCascade);
        bar3DPlotGlyph.setCubic3D(this.isCubic3D);
        bar3DPlotGlyph.setProjection(this.projection);
        bar3DPlotGlyph.setHorizontalDrawBar(this.horizontalDrawBar);
        bar3DPlotGlyph.setSeriesIntervalPercent(this.seriesIntervalPercent);
    }

    public ValueAxisGlyph createValueAxisGlyph() {
        return new ValueAxis3DGlyph(this.valueAxis);
    }

    public CategoryAxisGlyph createCategoryAxisGlyph() {
        return new CategoryAxis3DGlyph(this.categoryAxis);
    }

    public CategoryAxisGlyph createDateAxisGlyph() {
        return new DateAxis3DGlyph(this.categoryAxis);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr3D".equals(string)) {
                String string2 = xMLableReader.getAttr("horizontalDrawBar");
                if (string2 != null) {
                    this.horizontalDrawBar = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isCubic3D")) != null) {
                    this.setIsCubic3D(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("isCascade")) != null) {
                    this.setIsCascade(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("seriesIntervalPercent")) != null) {
                    this.setSeriesIntervalPercent(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("deep")) != null) {
                    this.setDeep(Integer.parseInt(string2));
                }
            } else if ("Projection".equals(string)) {
                this.setProjection((Projection)xMLableReader.readXMLObject(new Projection()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr3D").attr("horizontalDrawBar", this.horizontalDrawBar).attr("isCubic3D", this.isCubic3D).attr("isCascade", this.isCascade).attr("seriesIntervalPercent", this.seriesIntervalPercent);
        if (this.deep != -1) {
            xMLPrintWriter.attr("deep", this.deep);
        }
        xMLPrintWriter.end();
        if (this.getProjection() != null) {
            this.getProjection().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlot bar3DPlot = (Bar3DPlot)super.clone();
        if (this.projection != null) {
            bar3DPlot.projection = (Projection)this.projection.clone();
        }
        return bar3DPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bar3DPlot)) {
            return false;
        }
        Bar3DPlot bar3DPlot = (Bar3DPlot)object;
        if (!super.equals(bar3DPlot)) {
            return false;
        }
        if (bar3DPlot.horizontalDrawBar != this.horizontalDrawBar) {
            return false;
        }
        if (bar3DPlot.isCascade() != this.isCascade()) {
            return false;
        }
        if (bar3DPlot.isCubic3D() != this.isCubic3D()) {
            return false;
        }
        if (bar3DPlot.getDeep() != this.getDeep()) {
            return false;
        }
        if (bar3DPlot.getSeriesIntervalPercent() != this.getSeriesIntervalPercent()) {
            return false;
        }
        return Equals.equals(bar3DPlot.getProjection(), this.getProjection());
    }
}

