/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.glyph.BarPlotGlyph;
import com.fr.chart.plot.CategoryPlot;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;

public abstract class BarPlot
extends CategoryPlot {
    private static final long serialVersionUID = 6388999613764540798L;
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = -0.15;
    protected double categoryIntervalPercent = 1.0;

    public void install4PlotGlyph(BarPlotGlyph barPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(barPlotGlyph, chartData);
        barPlotGlyph.setIsHorizontal(this.isHorizontal);
        barPlotGlyph.setSeriesOverlapPercent(this.seriesOverlapPercent);
        barPlotGlyph.setCategoryIntervalPercent(this.categoryIntervalPercent);
    }

    public void setIsHorizontal(boolean bl) {
        this.isHorizontal = bl;
        if (bl) {
            this.categoryAxis.setPosition(2);
            this.valueAxis.setPosition(3);
        } else {
            this.categoryAxis.setPosition(3);
            this.valueAxis.setPosition(2);
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && this.isHorizontal == ((BarPlot)plot).isHorizontal;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "BarAttr".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttr("isHorizontal");
            if (string2 != null) {
                this.setIsHorizontal(Boolean.valueOf(string2));
            }
            if ((string2 = xMLableReader.getAttr("overlap")) != null) {
                this.setSeriesOverlapPercent(Double.parseDouble(string2));
            }
            if ((string2 = xMLableReader.getAttr("interval")) != null) {
                this.setCategoryIntervalPercent(Double.parseDouble(string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("BarAttr").attr("isHorizontal", this.isHorizontal).attr("overlap", this.seriesOverlapPercent).attr("interval", this.categoryIntervalPercent).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BarPlot)) {
            return false;
        }
        BarPlot barPlot = (BarPlot)object;
        if (!super.equals(barPlot)) {
            return false;
        }
        if (barPlot.getCategoryIntervalPercent() != this.getCategoryIntervalPercent()) {
            return false;
        }
        if (barPlot.getSeriesOverlapPercent() != this.getSeriesOverlapPercent()) {
            return false;
        }
        return barPlot.isHorizontal() == this.isHorizontal();
    }
}

