/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.background.IntervalColorBackground;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.CategoryPlotGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import java.awt.Color;
import java.awt.Insets;

public abstract class CategoryPlot
extends Plot {
    private static final long serialVersionUID = 6344220409249871761L;
    public static final double GAP_BETWEEN_PLOTS = 1.0;
    protected CategoryAxis categoryAxis;
    protected ValueAxis valueAxis;
    protected boolean isStacked = false;
    protected boolean bgStagger = false;
    protected Color bgColor = Color.white;

    public CategoryPlot() {
        this.categoryAxis = new CategoryAxis();
        this.valueAxis = new ValueAxis();
    }

    public void install4PlotGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(categoryPlotGlyph, chartData);
        categoryPlotGlyph.setStacked(this.isStacked);
    }

    public void installAxisGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        CategoryAxisGlyph categoryAxisGlyph;
        ValueAxisGlyph valueAxisGlyph = this.createValueAxisGlyph();
        if (this.checkDate(chartData) && this.categoryAxis.isDateAxis()) {
            categoryAxisGlyph = this.createDateAxisGlyph();
            double[] dArray = this.getDateRange(chartData);
            ((DateAxisGlyph)categoryAxisGlyph).initMinMaxValue(dArray[0], dArray[1]);
        } else {
            categoryAxisGlyph = this.createCategoryAxisGlyph();
        }
        categoryPlotGlyph.setValueAxisGlyph(valueAxisGlyph);
        categoryPlotGlyph.setCategoryAxisGlyph(categoryAxisGlyph);
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            categoryAxisGlyph.addCategoryLabel(chartData.getCategoryLabel(i) == null ? "" : chartData.getCategoryLabel(i));
        }
        valueAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxValueFromData(chartData));
        if (this.bgStagger) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground();
            intervalColorBackground.setColor(this.getBgColor());
            intervalColorBackground.setPosition(this.valueAxis.getPosition());
            categoryPlotGlyph.getInfo().setBackground(intervalColorBackground);
        }
        categoryPlotGlyph.axisExtends(categoryAxisGlyph);
    }

    public ValueAxisGlyph createValueAxisGlyph() {
        return new ValueAxisGlyph(this.valueAxis);
    }

    public CategoryAxisGlyph createCategoryAxisGlyph() {
        return new CategoryAxisGlyph(this.categoryAxis);
    }

    public CategoryAxisGlyph createDateAxisGlyph() {
        return new DateAxisGlyph(this.categoryAxis);
    }

    public CategoryAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    public void setCategoryAxis(CategoryAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
    }

    public ValueAxis getValueAxis() {
        return this.valueAxis;
    }

    public void setValueAxis(ValueAxis valueAxis) {
        this.valueAxis = valueAxis;
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public void setIsStacked(boolean bl) {
        this.isStacked = bl;
    }

    public void setBgStagger(boolean bl) {
        this.bgStagger = bl;
    }

    public boolean getbgStagger() {
        return this.bgStagger;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Insets createOuterIntsets() {
        return new Insets(10, 20, 20, 20);
    }

    public double getMaxValueFromData(ChartData chartData) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.isStacked) {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                double d3 = 0.0;
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null || !(number.doubleValue() >= 0.0)) continue;
                    d3 += number.doubleValue();
                }
                double d4 = d = d3 > d ? d3 : d;
                if (!this.valueAxis.isPercentage()) continue;
                double d5 = 0.0;
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null) continue;
                    d5 += Math.abs(number.doubleValue());
                }
                d2 = d3 / d5 > d2 ? d3 / d5 : d2;
            }
            if (this.valueAxis.isPercentage()) {
                return d2;
            }
        } else {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null) continue;
                    d = number.doubleValue() > d ? number.doubleValue() : d;
                }
            }
        }
        if (this.getMinValueFromData(chartData) == d) {
            return d + 10.0;
        }
        return d;
    }

    public double getMinValueFromData(ChartData chartData) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.isStacked) {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                double d3 = 0.0;
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null || !(number.doubleValue() <= 0.0)) continue;
                    d3 += number.doubleValue();
                }
                double d4 = d = d3 < d ? d3 : d;
                if (!this.valueAxis.isPercentage()) continue;
                double d5 = 0.0;
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null) continue;
                    d5 += Math.abs(number.doubleValue());
                }
                d2 = d3 / d5 < d2 ? d3 / d5 : d2;
            }
            if (this.valueAxis.isPercentage()) {
                return d2;
            }
        } else {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    Number number = chartData.getValueAt(j, i);
                    if (number == null) continue;
                    d = number.doubleValue() < d ? number.doubleValue() : d;
                }
            }
        }
        return d;
    }

    public boolean match4GUI(Plot plot) {
        if (!(plot instanceof CategoryPlot)) {
            return false;
        }
        boolean bl = ((CategoryPlot)plot).getValueAxis().isPercentage();
        return super.match4GUI(plot) && this.isStacked == ((CategoryPlot)plot).isStacked && this.getValueAxis().isPercentage() == bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("CateAttr".equals(string2)) {
                String string3 = xMLableReader.getAttr("isStacked");
                if (string3 != null) {
                    this.setIsStacked(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("bgStagger")) != null) {
                    this.setBgStagger(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("bgColor")) != null) {
                    this.setBgColor(new Color(Integer.parseInt(string3), true));
                }
                if ((string3 = xMLableReader.getAttr("percentage")) != null) {
                    this.getValueAxis().setPercentage(Boolean.valueOf(string3));
                }
            } else if ((string2.equals("CategoryAxis") || string2.equals("ValueAxis") || string2.equals("Axis") || string2.equals("DateAxis")) && (string = xMLableReader.getAttr("class")) != null) {
                if (string.endsWith(".CategoryAxis")) {
                    this.categoryAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
                }
                if (string.endsWith(".ValueAxis")) {
                    boolean bl = this.valueAxis.isPercentage();
                    this.valueAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
                    if (bl) {
                        this.valueAxis.setPercentage(true);
                    }
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("CateAttr").attr("isStacked", this.isStacked).attr("bgStagger", this.bgStagger);
        if (this.bgColor != null) {
            xMLPrintWriter.attr("bgColor", this.getBgColor().getRGB());
        }
        xMLPrintWriter.end();
        if (this.categoryAxis != null) {
            this.categoryAxis.writeXML(xMLPrintWriter);
        }
        if (this.valueAxis != null) {
            this.valueAxis.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        if (this.categoryAxis != null) {
            categoryPlot.categoryAxis = (CategoryAxis)this.categoryAxis.clone();
        }
        if (this.valueAxis != null) {
            categoryPlot.valueAxis = (ValueAxis)this.valueAxis.clone();
        }
        return categoryPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoryPlot)) {
            return false;
        }
        CategoryPlot categoryPlot = (CategoryPlot)object;
        if (!super.equals(categoryPlot)) {
            return false;
        }
        if (categoryPlot.getbgStagger() != this.getbgStagger()) {
            return false;
        }
        if (categoryPlot.isStacked() != this.isStacked()) {
            return false;
        }
        if (!Equals.equals(categoryPlot.getBgColor(), this.getBgColor())) {
            return false;
        }
        if (!Equals.equals(categoryPlot.getCategoryAxis(), this.getCategoryAxis())) {
            return false;
        }
        return Equals.equals(categoryPlot.valueAxis, this.valueAxis);
    }
}

