/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.plot.AreaPlot;
import com.fr.chart.plot.LinePlot;
import com.fr.chart.plot.Plot;
import com.fr.chart.plot.SeriesAttr;
import com.fr.util.Utils;

public class CustomAttr
extends SeriesAttr {
    private static final long serialVersionUID = 1257022581265772235L;
    public static final String XML_TAG = "CustomAttr";
    private int renderer = 1;
    private String axisPosition = "LEFT";

    public CustomAttr() {
    }

    public CustomAttr(int n) {
        this.setRenderer(n);
    }

    public void setRenderer(int n) {
        this.renderer = n;
    }

    public int getRenderer() {
        return this.renderer;
    }

    public void setAxisPosition(String string) {
        this.axisPosition = string;
    }

    public String getAxisPosition() {
        return this.axisPosition;
    }

    public void setRenderer(Plot plot) {
        if (plot instanceof LinePlot) {
            this.setRenderer(2);
        } else if (plot instanceof AreaPlot) {
            this.setRenderer(4);
        } else {
            this.setRenderer(1);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("customattr").attr("renderer", this.renderer).attr("axisPosition", this.axisPosition).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("customattr")) {
            String string2 = xMLableReader.getAttr("renderer");
            if (string2 != null) {
                this.renderer = Utils.string2Number(string2).intValue();
            }
            if ((string2 = xMLableReader.getAttr("axisPosition")) != null) {
                this.axisPosition = string2;
            }
        }
    }

    public String getSeriesAttrType() {
        return XML_TAG;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("renderer", this.renderer);
        jSONObject.put("axisPosition", this.axisPosition);
        return jSONObject;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomAttr customAttr = (CustomAttr)super.clone();
        return customAttr;
    }
}

