/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.FRContext;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.axis.SeriesAttrMarkerType;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.CustomPlotGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.marker.Marker;
import com.fr.chart.marker.MarkerFactory;
import com.fr.chart.plot.Bar2DPlot;
import com.fr.chart.plot.CategoryPlot;
import com.fr.chart.plot.CustomAttr;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import java.util.logging.Level;

public class CustomPlot
extends CategoryPlot {
    private static final long serialVersionUID = 4202124515267193546L;
    public static final int BAR_RENDERER = 1;
    public static final int LINE_RENDERER = 2;
    public static final int AREA_RENDERER = 4;
    public static final String Axis_LEFT = "LEFT";
    public static final String Axis_RIGHT = "RIGHT";
    private boolean hasSecondValueAxis = false;
    private ValueAxis secondValueAxis = new ValueAxis(4);
    private boolean isSimulation3D = true;
    private double seriesOverlapPercent = -0.15;
    private double categoryIntervalPercent = 1.0;
    private boolean isShowLine = true;
    private boolean isShowMarker = true;
    private boolean isLineNullValueBreak = true;
    private boolean isAreaNullValueBreak = true;

    public CustomPlot() {
        this.getSeriesCollection().setDefaultSeriesAttr(new CustomAttr());
    }

    public void setSecondValueAxis(ValueAxis valueAxis) {
        this.secondValueAxis = valueAxis;
    }

    public ValueAxis getSecondValueAxis() {
        return this.secondValueAxis;
    }

    public void setHasSecondValueAxis(boolean bl) {
        this.hasSecondValueAxis = bl;
    }

    public boolean hasSecondValueAxis() {
        return this.hasSecondValueAxis;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        CustomPlotGlyph customPlotGlyph = new CustomPlotGlyph();
        if (VT4FR.ADVANCED_CHART.support()) {
            this.install4PlotGlyph(customPlotGlyph, chartData);
            this.createAxisGlyph(customPlotGlyph, chartData);
        }
        return customPlotGlyph;
    }

    public void install4PlotGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(customPlotGlyph, chartData);
        customPlotGlyph.setSimulation3D(this.isSimulation3D);
        customPlotGlyph.setCategoryIntervalPercent(this.categoryIntervalPercent);
        customPlotGlyph.setSeriesOverlapPercent(this.seriesOverlapPercent);
        customPlotGlyph.setShowMarker(this.isShowMarker);
        customPlotGlyph.setShowLine(this.isShowLine);
        customPlotGlyph.setLineNullValueBreak(this.isLineNullValueBreak);
        customPlotGlyph.setAreaNullValueBreak(this.isAreaNullValueBreak);
    }

    private void createAxisGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        int n;
        CategoryAxisGlyph categoryAxisGlyph;
        if (this.checkDate(chartData) && this.categoryAxis.isDateAxis()) {
            categoryAxisGlyph = this.createDateAxisGlyph();
            double[] dArray = this.getDateRange(chartData);
            ((DateAxisGlyph)categoryAxisGlyph).initMinMaxValue(dArray[0], dArray[1]);
        } else {
            categoryAxisGlyph = this.createCategoryAxisGlyph();
        }
        customPlotGlyph.setCategoryAxisGlyph(categoryAxisGlyph);
        for (n = 0; n < chartData.getSeriesCount(); ++n) {
            CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getSeriesAttr(n);
            if (Axis_RIGHT.equals(customAttr.getAxisPosition())) {
                this.hasSecondValueAxis = true;
                break;
            }
            this.hasSecondValueAxis = false;
        }
        customPlotGlyph.setHasSecondValueAxis(this.hasSecondValueAxis);
        int n2 = chartData.getCategoryLabelCount();
        for (n = 0; n < n2; ++n) {
            categoryAxisGlyph.addCategoryLabel(chartData.getCategoryLabel(n) == null ? "" : chartData.getCategoryLabel(n));
        }
        ValueAxisGlyph valueAxisGlyph = this.createValueAxisGlyph();
        customPlotGlyph.setValueAxisGlyph(valueAxisGlyph);
        valueAxisGlyph.initMinMaxValue(this.getAxisMinValueFromData(chartData, Axis_LEFT), this.getAxisMaxValueFromData(chartData, Axis_LEFT));
        if (this.hasSecondValueAxis) {
            ValueAxisGlyph valueAxisGlyph2 = new ValueAxisGlyph(this.getSecondValueAxis());
            customPlotGlyph.setSecondValueAxisGlyph(valueAxisGlyph2);
            valueAxisGlyph2.initMinMaxValue(this.getAxisMinValueFromData(chartData, Axis_RIGHT), this.getAxisMaxValueFromData(chartData, Axis_RIGHT));
        }
        if (this.bgStagger) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground();
            intervalColorBackground.setColor(this.getBgColor());
            intervalColorBackground.setPosition(this.valueAxis.getPosition());
            customPlotGlyph.getInfo().setBackground(intervalColorBackground);
        }
        customPlotGlyph.axisExtends(categoryAxisGlyph);
    }

    private double getAxisMinValueFromData(ChartData chartData, String string) {
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                if (chartData.getValueAt(j, i) == null) continue;
                if (string.equals(Axis_LEFT) && !this.isSeriesUseRight(j)) {
                    double d2 = d = chartData.getValueAt(j, i).doubleValue() < d ? chartData.getValueAt(j, i).doubleValue() : d;
                }
                if (!string.equals(Axis_RIGHT) || !this.isSeriesUseRight(j)) continue;
                d = chartData.getValueAt(j, i).doubleValue() < d ? chartData.getValueAt(j, i).doubleValue() : d;
            }
        }
        return d;
    }

    private double getAxisMaxValueFromData(ChartData chartData, String string) {
        double d = 0.0;
        if (this.isStacked) {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                double d2 = 0.0;
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    if (chartData.getValueAt(j, i) == null) continue;
                    if (string.equals(Axis_LEFT) && !this.isSeriesUseRight(j)) {
                        d2 += chartData.getValueAt(j, i).doubleValue();
                    }
                    if (!string.equals(Axis_RIGHT) || !this.isSeriesUseRight(j)) continue;
                    d2 += chartData.getValueAt(j, i).doubleValue();
                }
                d = d2 > d ? d2 : d;
            }
        } else {
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                    if (chartData.getValueAt(j, i) == null) continue;
                    if (string.equals(Axis_LEFT) && !this.isSeriesUseRight(j)) {
                        double d3 = d = chartData.getValueAt(j, i).doubleValue() > d ? chartData.getValueAt(j, i).doubleValue() : d;
                    }
                    if (!string.equals(Axis_RIGHT) || !this.isSeriesUseRight(j)) continue;
                    d = chartData.getValueAt(j, i).doubleValue() > d ? chartData.getValueAt(j, i).doubleValue() : d;
                }
            }
        }
        if (d == this.getAxisMinValueFromData(chartData, string)) {
            return d + 10.0;
        }
        return d;
    }

    private boolean isSeriesUseRight(int n) {
        CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getSeriesAttr(n);
        return Axis_RIGHT.equals(customAttr.getAxisPosition()) && this.hasSecondValueAxis();
    }

    protected LineMarkerIcon getLineMarkerIconByIndex(int n) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getSeriesAttr(n);
        if (customAttr.getRenderer() == 2) {
            lineMarkerIcon.setLineStyle(1);
            SeriesAttrMarkerType seriesAttrMarkerType = (SeriesAttrMarkerType)this.getSeriesCollection().getSeriesCondition(new SeriesAttrMarkerType(), n);
            Marker marker = MarkerFactory.createIndexMarker(seriesAttrMarkerType.getMarkerTypeIndex());
            marker.setSize(marker.getSize() * 0.6);
            SeriesAttrLine seriesAttrLine = (SeriesAttrLine)this.getSeriesCollection().getSeriesCondition(new SeriesAttrLine(), n);
            marker.setColor(seriesAttrLine.getSeriesLineColor());
            lineMarkerIcon.setColor(seriesAttrLine.getSeriesLineColor());
            lineMarkerIcon.setMarker(marker);
        } else {
            this.dealCondition(lineMarkerIcon, n);
        }
        return lineMarkerIcon;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public void setShowLine(boolean bl) {
        this.isShowLine = bl;
    }

    public boolean isShowLine() {
        return this.isShowLine;
    }

    public void setShowMarker(boolean bl) {
        this.isShowMarker = bl;
    }

    public boolean isShowMarker() {
        return this.isShowMarker;
    }

    public void setSimulation3D(boolean bl) {
        this.isSimulation3D = bl;
    }

    public boolean isSimulation3D() {
        return this.isSimulation3D;
    }

    public void setLineNullValueBreak(boolean bl) {
        this.isLineNullValueBreak = bl;
    }

    public boolean isLineNullValueBreak() {
        return this.isLineNullValueBreak;
    }

    public void setAreaNullValueBreak(boolean bl) {
        this.isAreaNullValueBreak = bl;
    }

    public boolean isAreaNullValueBreak() {
        return this.isAreaNullValueBreak;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("SecondValueAxis".equals(string)) {
                String string2 = xMLableReader.getAttr("class");
                if (string2 != null && string2.endsWith(".ValueAxis")) {
                    this.secondValueAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
                }
            } else if ("Attr".equals(string)) {
                String string3 = xMLableReader.getAttr("value");
                if (string3 != null) {
                    this.hasSecondValueAxis = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("isShowLine")) != null) {
                    this.isShowLine = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("isShowMarker")) != null) {
                    this.isShowMarker = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("isAreaNullValueBreak")) != null) {
                    this.isAreaNullValueBreak = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("isLineNullValueBreak")) != null) {
                    this.isLineNullValueBreak = Boolean.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("categoryIntervalPercent")) != null) {
                    this.categoryIntervalPercent = Double.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("seriesOverlapPercent")) != null) {
                    this.seriesOverlapPercent = Double.valueOf(string3);
                }
                if ((string3 = xMLableReader.getAttr("isSimulation3D")) != null) {
                    this.isSimulation3D = Boolean.valueOf(string3);
                }
            } else if ("Plot".equals(string)) {
                String string4 = xMLableReader.getAttr("class");
                if (string4 != null) {
                    Plot plot = new Bar2DPlot();
                    try {
                        plot = (Plot)FRCoreContext.classForName(string4).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CustomAttr customAttr = (CustomAttr)this.getSeriesCollection().getDefaultSeriesAttr();
                    customAttr.setRenderer(plot);
                }
            } else if ("PlotMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            String string;
                            int n = -1;
                            if ("Entry".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("index")) != null) {
                                n = Integer.parseInt(string);
                            }
                            if (n != -1) {
                                xMLableReader.readXMLObject(new XMLObject(this, new Integer(n)){
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void readXML(XMLableReader xMLableReader) {
                                        String string;
                                        if (xMLableReader.isChildNode() && "Plot".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("class")) != null) {
                                            Plot plot;
                                            try {
                                                plot = (Plot)FRCoreContext.classForName(string).newInstance();
                                            }
                                            catch (Exception exception) {
                                                plot = new Bar2DPlot();
                                                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                                            }
                                            int n = Integer.parseInt(this.obj.toString());
                                            CustomAttr customAttr = (CustomAttr)1.access$000(this.this$1).getSeriesCollection().getSeriesAttr(n);
                                            CustomAttr customAttr2 = new CustomAttr();
                                            try {
                                                customAttr2 = (CustomAttr)customAttr.clone();
                                            }
                                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                                cloneNotSupportedException.printStackTrace();
                                            }
                                            customAttr2.setRenderer(plot);
                                            1.access$000(this.this$1).getSeriesCollection().putSeriesAttr(n, customAttr2);
                                        }
                                    }
                                });
                            }
                        }
                    }

                    static /* synthetic */ CustomPlot access$000(1 var0) {
                        return var0.CustomPlot.this;
                    }
                });
            } else if ("SeriesAxisMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName())) {
                            int n = -1;
                            String string = xMLableReader.getAttr("index");
                            if (string != null) {
                                n = Integer.parseInt(string);
                            }
                            if ((string = xMLableReader.getAttr("axisPos")) != null && n != -1) {
                                CustomAttr customAttr = (CustomAttr)CustomPlot.this.getSeriesCollection().getSeriesAttr(n);
                                CustomAttr customAttr2 = new CustomAttr();
                                try {
                                    customAttr2 = (CustomAttr)customAttr.clone();
                                }
                                catch (CloneNotSupportedException cloneNotSupportedException) {
                                    cloneNotSupportedException.printStackTrace();
                                }
                                customAttr2.setAxisPosition(string);
                                CustomPlot.this.getSeriesCollection().putSeriesAttr(n, customAttr2);
                            }
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("value", this.hasSecondValueAxis).attr("isShowLine", this.isShowLine).attr("isShowMarker", this.isShowMarker).attr("isLineNullValueBreak", this.isLineNullValueBreak).attr("isAreaNullValueBreak", this.isAreaNullValueBreak).attr("seriesOverlapPercent", this.seriesOverlapPercent).attr("categoryIntervalPercent", this.categoryIntervalPercent).attr("isSimulation3D", this.isSimulation3D).end();
        if (this.secondValueAxis != null) {
            this.secondValueAxis.writeXML(xMLPrintWriter, "SecondValueAxis");
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomPlot)) {
            return false;
        }
        CustomPlot customPlot = (CustomPlot)object;
        if (!super.equals(customPlot)) {
            return false;
        }
        if (customPlot.hasSecondValueAxis != this.hasSecondValueAxis || customPlot.isAreaNullValueBreak != this.isAreaNullValueBreak || customPlot.isLineNullValueBreak != this.isLineNullValueBreak || customPlot.isShowLine != this.isShowLine || customPlot.isShowMarker != this.isShowMarker || customPlot.seriesOverlapPercent != this.seriesOverlapPercent || customPlot.categoryIntervalPercent != this.categoryIntervalPercent || customPlot.isSimulation3D != this.isSimulation3D) {
            return false;
        }
        return Equals.equals(customPlot.getSecondValueAxis(), this.getSecondValueAxis());
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPlot customPlot = (CustomPlot)super.clone();
        if (this.valueAxis != null) {
            customPlot.valueAxis = (ValueAxis)this.valueAxis.clone();
        }
        return customPlot;
    }
}

