/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.StringUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.glyph.ChartGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.MarkerGlyph;
import com.fr.chart.plot.Meter;
import com.fr.chart.shape3d.Cubic;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class DataPoint
extends SoloGlyph {
    private static final long serialVersionUID = -970056669601457244L;
    public static final String XML_TAG = "DataPoint";
    private int categoryIndex;
    private double value;
    private boolean valueIsNull = false;
    private String categoryName;
    private String seriesName;
    private double percentValue;
    private String seriesLabel = null;
    private Glyph drawImpl;
    private TextGlyph dataLabel;
    private GeneralPath leadLine;

    public DataPoint() {
    }

    public DataPoint(int n, String string, String string2, double d) {
        this.categoryIndex = n;
        this.categoryName = string;
        this.seriesName = string2;
        this.value = d;
    }

    public void setIndex(int n) {
        this.categoryIndex = n;
    }

    public int getIndex() {
        return this.categoryIndex;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setValueIsNull(boolean bl) {
        this.valueIsNull = bl;
    }

    public boolean isValueIsNull() {
        return this.valueIsNull;
    }

    public void setPercentValue(double d) {
        this.percentValue = d;
    }

    public double getPercentValue() {
        return this.percentValue;
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSereisLabel(String string) {
        this.seriesLabel = string;
    }

    public String getSereisLabel() {
        return this.seriesLabel;
    }

    public Calculator getCalculator() {
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(new Parameter[]{new Parameter("CATEGORY", this.getCategoryName()), new Parameter("SERIES", this.getSeriesName()), new Parameter("VALUE", new Double(this.value)), new Parameter("PERCENT", new Double(this.getPercentValue()))}));
        return calculator;
    }

    public void setDrawImpl(Glyph glyph) {
        this.drawImpl = glyph;
    }

    public Glyph getDrawImpl() {
        return this.drawImpl;
    }

    public void setDataLabel(TextGlyph textGlyph) {
        this.dataLabel = textGlyph;
    }

    public TextGlyph getDataLabel() {
        return this.dataLabel;
    }

    public void setLeadLine(GeneralPath generalPath) {
        this.leadLine = generalPath;
    }

    public GeneralPath getLeadLine() {
        return this.leadLine;
    }

    public void setShape(Shape shape) {
        this.drawImpl = new ShapeGlyph(shape);
    }

    public Shape getShape() {
        return this.drawImpl == null ? null : this.drawImpl.getShape();
    }

    public void draw(Graphics graphics) {
        if (this.drawImpl != null) {
            this.drawImpl.draw(graphics);
        }
    }

    public void drawLabel(Graphics graphics) {
        if (this.valueIsNull) {
            return;
        }
        if (this.dataLabel != null) {
            this.dataLabel.draw(graphics);
        }
        if (this.getLeadLine() != null) {
            Color color = graphics.getColor();
            graphics.setColor(Color.gray);
            GraphHelper.draw(graphics, this.getLeadLine(), 1);
            graphics.setColor(color);
        }
    }

    public Tag getImageMapAreaTag(ChartGlyph chartGlyph) {
        if (chartGlyph == null || chartGlyph.getPlotGlyph() == null || chartGlyph.getPlotGlyph().getBounds() == null || this.isValueIsNull()) {
            return new Tag();
        }
        int n = (int)chartGlyph.getPlotGlyph().getBounds().getX();
        int n2 = (int)chartGlyph.getPlotGlyph().getBounds().getY();
        Tag tag = new Tag("area");
        tag.attr("shape", this.getShapeType());
        tag.attr("coords", this.getShapeCoords(n, n2));
        tag.attr("alt", "");
        tag.attr("href", "javascript:void(0)");
        return tag;
    }

    private String getShapeType() {
        if (this.getShape() instanceof Rectangle2D) {
            return "rect";
        }
        return "poly";
    }

    private String getShapeCoords(int n, int n2) {
        if (this.getShape() instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.getShape(), n, n2);
        }
        return this.getPolyCoords(this.getShape(), n, n2);
    }

    private String getRectCoords(Rectangle2D rectangle2D, int n, int n2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'rectangle' argument.");
        }
        int n3 = (int)rectangle2D.getX() + n;
        int n4 = (int)rectangle2D.getY() + n2;
        int n5 = n3 + (int)rectangle2D.getWidth();
        int n6 = n4 + (int)rectangle2D.getHeight();
        if (n5 == n3) {
            ++n5;
        }
        if (n6 == n4) {
            ++n6;
        }
        return n3 + "," + n4 + "," + n5 + "," + n6;
    }

    private String getPolyCoords(Shape shape, int n, int n2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                stringBuffer.append((int)fArray[0] + n);
                stringBuffer.append(",").append((int)fArray[1] + n2);
            } else {
                stringBuffer.append(",");
                stringBuffer.append((int)fArray[0] + n);
                stringBuffer.append(",");
                stringBuffer.append((int)fArray[1] + n2);
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataPoint)) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)object;
        if (!(this.categoryName != null ? this.categoryName.equals(dataPoint.categoryName) : dataPoint.categoryName == null)) {
            return false;
        }
        if (!(this.seriesName != null ? this.seriesName.equals(dataPoint.seriesName) : dataPoint.seriesName == null)) {
            return false;
        }
        return this.value == dataPoint.value;
    }

    public Object clone() throws CloneNotSupportedException {
        DataPoint dataPoint = (DataPoint)super.clone();
        return dataPoint;
    }

    public String toString() {
        return this.categoryName.toString() + " " + this.seriesName.toString() + " " + this.getValue();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Attr")) {
                string = xMLableReader.getAttr("valueIsNull");
                if (string != null) {
                    this.valueIsNull = Boolean.valueOf(string);
                }
                if ((string = xMLableReader.getAttr("index")) != null) {
                    this.setIndex(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("value")) != null) {
                    this.setValue(Double.valueOf(string));
                }
                if ((string = xMLableReader.getAttr("categoryName")) != null) {
                    this.setCategoryName(string);
                }
                if ((string = xMLableReader.getAttr("seriesName")) != null) {
                    this.setSeriesName(string);
                }
                if ((string = xMLableReader.getAttr("percent")) != null) {
                    this.setPercentValue(Double.valueOf(string));
                }
                if ((string = xMLableReader.getAttr("seriesLabel")) != null) {
                    this.setSereisLabel(string);
                }
            }
            if (string2.equals("DrawImpl")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("ShapeGlyph")) {
                            DataPoint.this.drawImpl = (Glyph)xMLableReader.readXMLObject(new ShapeGlyph());
                        } else if (string.equals("Cubic")) {
                            DataPoint.this.drawImpl = (Glyph)xMLableReader.readXMLObject(new Cubic());
                        } else if (string.equals("MarkerGlyph")) {
                            DataPoint.this.drawImpl = (Glyph)xMLableReader.readXMLObject(new MarkerGlyph());
                        } else if (string.equals("Meter")) {
                            DataPoint.this.drawImpl = (Glyph)xMLableReader.readXMLObject(new Meter());
                        }
                    }
                });
            }
            if (string2.equals("DataLabel")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("TextGlyph")) {
                            DataPoint.this.setDataLabel((TextGlyph)xMLableReader.readXMLObject(new TextGlyph()));
                        }
                    }
                });
            }
            if (string2.equals("Line")) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                string = xMLableReader.getAttr("x1");
                if (string != null) {
                    d = Double.valueOf(string);
                }
                if ((string = xMLableReader.getAttr("y1")) != null) {
                    d3 = Double.valueOf(string);
                }
                if ((string = xMLableReader.getAttr("x2")) != null) {
                    d2 = Double.valueOf(string);
                }
                if ((string = xMLableReader.getAttr("y2")) != null) {
                    d4 = Double.valueOf(string);
                }
                d5 = (string = xMLableReader.getAttr("x3")) != null ? Double.valueOf(string) : d2;
                string = xMLableReader.getAttr("y3");
                d6 = string != null ? Double.valueOf(string) : d4;
                this.leadLine = new GeneralPath();
                this.leadLine.moveTo((float)d, (float)d3);
                this.leadLine.lineTo((float)d2, (float)d4);
                this.leadLine.lineTo((float)d5, (float)d6);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("valueIsNull", this.valueIsNull).attr("index", this.getIndex()).attr("value", this.getValue()).attr("categoryName", this.getCategoryName()).attr("seriesName", this.getSeriesName()).attr("percent", this.getPercentValue());
        if (StringUtils.isNotBlank(this.seriesLabel)) {
            xMLPrintWriter.attr("seriesLabel", this.seriesLabel);
        }
        xMLPrintWriter.end();
        if (this.drawImpl != null) {
            xMLPrintWriter.startTAG("DrawImpl");
            this.drawImpl.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.dataLabel != null) {
            xMLPrintWriter.startTAG("DataLabel");
            this.dataLabel.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.leadLine != null) {
            AffineTransform affineTransform = new AffineTransform();
            PathIterator pathIterator = this.leadLine.getPathIterator(affineTransform);
            double[][] dArray = new double[3][2];
            int n = 0;
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(dArray[n]);
                ++n;
                pathIterator.next();
            }
            xMLPrintWriter.startTAG("Line").attr("x1", dArray[0][0]).attr("y1", dArray[0][1]).attr("x2", dArray[1][0]).attr("y2", dArray[1][1]).attr("x3", dArray[2][0]).attr("y3", dArray[2][1]).end();
        }
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("categoryIndex", this.categoryIndex);
        jSONObject.put("categoryName", this.categoryName);
        jSONObject.put("value", this.value);
        jSONObject.put("valueIsNull", this.valueIsNull);
        jSONObject.put("seriesName", this.seriesName);
        jSONObject.put("percentValue", this.percentValue);
        jSONObject.put("seriesLabel", this.seriesLabel);
        if (this.dataLabel != null) {
            jSONObject.put("dataLabel", this.dataLabel.toJSONObject());
        }
        return jSONObject;
    }
}

