/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.TrendLine;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.plot.DataPoint;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class DataSeries
extends SoloGlyph {
    private static final long serialVersionUID = 6421947917220147755L;
    public static final String XML_TAG = "DataSeries";
    private int seriesIndex;
    private String seriesName;
    private List points = new ArrayList();
    private Glyph drawImpl;
    private TrendLine trendLine = null;

    public DataSeries() {
    }

    public DataSeries(int n) {
        this.seriesIndex = n;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int n) {
        this.seriesIndex = n;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setDrawImpl(Glyph glyph) {
        this.drawImpl = glyph;
    }

    public Glyph getDrawImpl() {
        return this.drawImpl;
    }

    public void addDataPoint(DataPoint dataPoint) {
        this.points.add(dataPoint);
    }

    public int getDataPointCount() {
        return this.points.size();
    }

    public DataPoint getDataPoint(int n) {
        return (DataPoint)this.points.get(n);
    }

    public void setTrendLine(TrendLine trendLine) {
        this.trendLine = trendLine;
    }

    public TrendLine getTrendLine() {
        return this.trendLine;
    }

    public void draw(Graphics graphics) {
        if (this.drawImpl != null) {
            this.drawImpl.draw(graphics);
        }
        int n = this.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            this.getDataPoint(i).draw(graphics);
        }
    }

    public void drawLabel(Graphics graphics) {
        int n = this.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            this.getDataPoint(i).drawLabel(graphics);
        }
    }

    public void drawTrendLine(Graphics graphics) {
        if (this.trendLine != null) {
            this.trendLine.draw(graphics);
        }
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        if (this.drawImpl != null) {
            generalPath.append(this.drawImpl.getShape(), false);
        }
        int n = this.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            Shape shape = this.getDataPoint(i).getShape();
            if (shape == null) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("index", this.seriesIndex).attr("name", this.seriesName).end();
        if (this.points != null && this.points.size() > 0) {
            xMLPrintWriter.startTAG("DataPoints");
            for (int i = 0; i < this.points.size(); ++i) {
                ((DataPoint)this.points.get(i)).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.drawImpl != null) {
            xMLPrintWriter.startTAG("Glyph");
            this.drawImpl.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("index");
                if (string2 != null) {
                    this.setSeriesIndex(Integer.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("name")) != null) {
                    this.setSeriesName(string2);
                }
            }
            if (string.equals("DataPoints")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("DataPoint")) {
                            DataSeries.this.points.add(xMLableReader.readXMLObject(new DataPoint()));
                        }
                    }
                });
            }
            if (string.equals("Glyph")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        DataSeries.this.drawImpl = ReportXMLUtils.readGlyph(xMLableReader);
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataSeries)) {
            return false;
        }
        DataSeries dataSeries = (DataSeries)object;
        if (dataSeries.getSeriesIndex() != this.getSeriesIndex()) {
            return false;
        }
        if (!Equals.equals(dataSeries.getSeriesName(), this.getSeriesName())) {
            return false;
        }
        if (dataSeries.getDataPointCount() != this.getDataPointCount()) {
            return false;
        }
        for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
            if (Equals.equals(dataSeries.getDataPoint(i), this.getDataPoint(i))) continue;
            return false;
        }
        return Equals.equals(dataSeries.getDrawImpl(), this.getDrawImpl());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.points != null && this.points.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.points.size(); ++i) {
                arrayList.add(this.getDataPoint(i).toJSONObject());
            }
            jSONObject.put("points", arrayList);
        }
        return jSONObject;
    }
}

