/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.Inter;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.GanttPlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.legend.LegendItem;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.marker.SquareFilledMarker;
import com.fr.chart.marker.TriangleFilledMarker;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import java.awt.Color;
import java.util.Date;

public class GanttPlot
extends Plot {
    private static final long serialVersionUID = 3888739478450011607L;
    public static final String XML_TAG = "GanttPlot";
    private CategoryAxis categoryAxis = new CategoryAxis();
    private CategoryAxis dateAxis = new CategoryAxis();
    private Date currentDay = null;

    public GanttPlot() {
        this.getCategoryAxis().setPosition(2);
        this.getCategoryAxis().setMainGridColor(new Color(237, 237, 237));
        this.getCategoryAxis().setMainGridStyle(1);
        this.getDateAxis().setMainGridColor(new Color(237, 237, 237));
        this.getDateAxis().setMainGridStyle(1);
        this.getDateAxis().setMainType(1);
        this.getDateAxis().setDateAxis(true);
        this.getDateAxis().setPosition(1);
        this.setBorderColor(new Color(237, 237, 237));
        this.setBorderStyle(1);
    }

    public void setDateAxis(CategoryAxis categoryAxis) {
        this.dateAxis = categoryAxis;
    }

    public CategoryAxis getDateAxis() {
        return this.dateAxis;
    }

    public void setCategoryAxis(CategoryAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
    }

    public CategoryAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        GanttPlotGlyph ganttPlotGlyph = new GanttPlotGlyph();
        this.install4PlotGlyph(ganttPlotGlyph, chartData);
        this.installAxisGlyph(ganttPlotGlyph, chartData);
        return ganttPlotGlyph;
    }

    public void installAxisGlyph(GanttPlotGlyph ganttPlotGlyph, ChartData chartData) {
        CategoryAxisGlyph categoryAxisGlyph = new CategoryAxisGlyph(this.getCategoryAxis());
        ganttPlotGlyph.setCategoryAxisGlyph(categoryAxisGlyph);
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            categoryAxisGlyph.addCategoryLabel(chartData.getCategoryLabel(i) == null ? "" : chartData.getCategoryLabel(i));
        }
        categoryAxisGlyph.setGantt(true);
        DateAxisGlyph dateAxisGlyph = new DateAxisGlyph(this.getDateAxis());
        ganttPlotGlyph.setDateAxisGlyph(dateAxisGlyph);
        dateAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxValueFromData(chartData));
    }

    public double getMaxValueFromData(ChartData chartData) {
        double d = 0.0;
        int n = chartData.getSeriesCount();
        if (n == 5) {
            --n;
        }
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < n; ++j) {
                Number number = chartData.getValueAt(j, i);
                if (number == null) continue;
                d = i == 0 && j == 0 ? number.doubleValue() : (number.doubleValue() > d ? number.doubleValue() : d);
            }
        }
        if (d == this.getMinValueFromData(chartData)) {
            return d + 10.0;
        }
        return d;
    }

    public double getMinValueFromData(ChartData chartData) {
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < chartData.getSeriesCount() - 1; ++j) {
                Number number = chartData.getValueAt(j, i);
                if (number == null) continue;
                d = i == 0 && j == 0 ? number.doubleValue() : (number.doubleValue() < d ? number.doubleValue() : d);
            }
        }
        return d;
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph) {
        int n = plotGlyph.getSeriesSize();
        LegendItem[] legendItemArray = new LegendItem[n - 1];
        if (n > 1) {
            legendItemArray[0] = new LegendItem(Inter.getLocText("ChartF-Gantt-PlanTime"));
            legendItemArray[0].setLineMarkerIcon(new LineMarkerIcon(new Color(200, 199, 199), 0, new SquareFilledMarker()));
            if (n > 2) {
                legendItemArray[1] = new LegendItem(Inter.getLocText("ChartF-Gantt-RealStart"));
                legendItemArray[1].setLineMarkerIcon(new LineMarkerIcon(new Color(113, 70, 22), 0, new TriangleFilledMarker()));
                if (n > 3) {
                    legendItemArray[2] = new LegendItem(Inter.getLocText("ChartF-Gantt-RealEndTime"));
                    legendItemArray[2].setLineMarkerIcon(new LineMarkerIcon(new Color(122, 190, 108), 0, new TriangleFilledMarker()));
                    if (n > 4) {
                        legendItemArray[3] = new LegendItem(Inter.getLocText("ChartF-Gantt-Progress"));
                        legendItemArray[3].setLineMarkerIcon(new LineMarkerIcon(new Color(0, 107, 172), 0, new SquareFilledMarker()));
                    }
                }
            }
        }
        return legendItemArray;
    }

    public void setCurrentDay(Date date) {
        this.currentDay = date;
    }

    public Date getCurrentDay() {
        return this.currentDay;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.categoryAxis != null) {
            this.categoryAxis.writeXML(xMLPrintWriter);
        }
        if (this.dateAxis != null) {
            this.dateAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("CategoryAxis")) {
                this.categoryAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
            }
            if (string.equals("DateAxis")) {
                this.dateAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GanttPlot ganttPlot = (GanttPlot)super.clone();
        if (this.getDateAxis() != null) {
            ganttPlot.setDateAxis((CategoryAxis)this.dateAxis.clone());
        }
        if (this.categoryAxis != null) {
            ganttPlot.categoryAxis = (CategoryAxis)this.categoryAxis.clone();
        }
        return ganttPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GanttPlot)) {
            return false;
        }
        GanttPlot ganttPlot = (GanttPlot)object;
        if (!super.equals(ganttPlot)) {
            return false;
        }
        if (!Equals.equals(ganttPlot.getCategoryAxis(), this.getCategoryAxis())) {
            return false;
        }
        if (!Equals.equals(ganttPlot.getDateAxis(), this.getDateAxis())) {
            return false;
        }
        return Equals.equals(ganttPlot.currentDay, this.currentDay);
    }
}

