/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.background.ColorBackground;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryAxis3DGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxis3DGlyph;
import com.fr.chart.core.glyph.Line3DPlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxis3DGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.math.Plot3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.CategoryPlot;
import com.fr.data.ChartData;
import java.awt.Color;
import java.awt.Insets;

public class Line3DPlot
extends CategoryPlot
implements Plot3D {
    private static final long serialVersionUID = -4538377327051227336L;
    private Projection projection = new Projection();
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;

    public Line3DPlot() {
        this.setBackground(ColorBackground.getInstance(new Color(171, 222, 239)));
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Line3DPlotGlyph line3DPlotGlyph = new Line3DPlotGlyph();
        this.install4PlotGlyph(line3DPlotGlyph, chartData);
        this.installAxisGlyph(line3DPlotGlyph, chartData);
        return line3DPlotGlyph;
    }

    public void install4PlotGlyph(Line3DPlotGlyph line3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(line3DPlotGlyph, chartData);
        line3DPlotGlyph.setProjection(this.projection);
        line3DPlotGlyph.setDeep(this.deep);
        line3DPlotGlyph.setSeriesIntervalPercent(this.seriesIntervalPercent);
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, int n) {
        this.dealColorCondition(lineMarkerIcon, n);
    }

    public ValueAxisGlyph createValueAxisGlyph() {
        return new ValueAxis3DGlyph(this.valueAxis);
    }

    public CategoryAxisGlyph createCategoryAxisGlyph() {
        return new CategoryAxis3DGlyph(this.categoryAxis);
    }

    public CategoryAxisGlyph createDateAxisGlyph() {
        return new DateAxis3DGlyph(this.categoryAxis);
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public Insets createOuterIntsets() {
        return new Insets(30, 20, 20, 50);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Projection".equals(string)) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            }
            if ("Line3DAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("seriesIntervalPercent");
                if (string2 != null) {
                    this.seriesIntervalPercent = Double.parseDouble(string2);
                }
                if ((string2 = xMLableReader.getAttr("deep")) != null) {
                    this.setDeep(Integer.parseInt(string2));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Line3DPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Line3DAttr").attr("seriesIntervalPercent", this.seriesIntervalPercent);
        if (this.getDeep() != -1) {
            xMLPrintWriter.attr("deep", this.getDeep());
        }
        xMLPrintWriter.end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Line3DPlot line3DPlot = (Line3DPlot)super.clone();
        if (this.projection != null) {
            line3DPlot.projection = (Projection)this.projection.clone();
        }
        return line3DPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Line3DPlot)) {
            return false;
        }
        Line3DPlot line3DPlot = (Line3DPlot)object;
        if (!super.equals(line3DPlot)) {
            return false;
        }
        if (line3DPlot.getSeriesIntervalPercent() != this.getSeriesIntervalPercent()) {
            return false;
        }
        if (line3DPlot.getDeep() != this.getDeep()) {
            return false;
        }
        return Equals.equals(line3DPlot.getProjection(), this.getProjection());
    }
}

