/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.glyph.LinePlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.plot.CategoryPlot;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;

public class LinePlot
extends CategoryPlot {
    private static final long serialVersionUID = 8277372084403680598L;
    private boolean isShowLine = true;
    private boolean isShowMarker = true;

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        LinePlotGlyph linePlotGlyph = new LinePlotGlyph();
        this.install4PlotGlyph(linePlotGlyph, chartData);
        this.installAxisGlyph(linePlotGlyph, chartData);
        return linePlotGlyph;
    }

    public void install4PlotGlyph(LinePlotGlyph linePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(linePlotGlyph, chartData);
        linePlotGlyph.setShowLine(this.isShowLine);
        linePlotGlyph.setShowMarker(this.isShowMarker);
    }

    public boolean isShowLine() {
        return this.isShowLine;
    }

    public void setIsShowLine(boolean bl) {
        this.isShowLine = bl;
    }

    public boolean isShowMarker() {
        return this.isShowMarker;
    }

    public void setIsShowMarker(boolean bl) {
        this.isShowMarker = bl;
    }

    protected LineMarkerIcon getLineMarkerIconByIndex(int n) {
        return this.getLineMarkerIconByIndex4Line(n);
    }

    protected boolean showLegendLine() {
        return this.isShowLine;
    }

    protected boolean showLegendMarker() {
        return this.isShowMarker;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && this.isShowMarker == ((LinePlot)plot).isShowMarker;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "Show".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttr("showMarker");
            if (string2 != null) {
                this.setIsShowMarker(Boolean.valueOf(string2));
            }
            if ((string2 = xMLableReader.getAttr("showLine")) != null) {
                this.setIsShowLine(Boolean.valueOf(string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Show").attr("showMarker", this.isShowMarker).attr("showLine", this.isShowLine).end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        LinePlot linePlot = (LinePlot)super.clone();
        return linePlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinePlot)) {
            return false;
        }
        LinePlot linePlot = (LinePlot)object;
        if (!super.equals(linePlot)) {
            return false;
        }
        if (linePlot.isShowLine() != this.isShowLine()) {
            return false;
        }
        return linePlot.isShowMarker() == this.isShowMarker();
    }
}

