/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrColor;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.axis.SeriesAttrMarkerType;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.marker.Marker;
import com.fr.chart.marker.MarkerFactory;
import com.fr.chart.plot.SeriesCollection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class MarkerGlyph
extends SoloGlyph {
    private static final long serialVersionUID = 7868484475190979219L;
    public static final String XML_TAG = "MarkerGlyph";
    private Marker marker;
    private Color color;
    private double x;
    private double y;
    private double width;
    private double height;
    private float alpha = 1.0f;

    public MarkerGlyph() {
    }

    public MarkerGlyph(Marker marker, Color color) {
        this.setMarker(marker);
        this.setColor(color);
    }

    public MarkerGlyph(Marker marker, Color color, double d, double d2, double d3, double d4) {
        this.setMarker(marker);
        this.setColor(color);
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMarker() == null) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        if (this.getColor() != null) {
            graphics2D.setPaint(this.getColor());
        }
        this.getMarker().paint(graphics2D, this.x + this.width / 2.0, this.y + this.height / 2.0);
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public Shape getShape() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public void setShape(Rectangle2D rectangle2D) {
        this.x = rectangle2D.getX();
        this.y = rectangle2D.getY();
        this.width = rectangle2D.getWidth();
        this.height = rectangle2D.getHeight();
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void dealCondition(SeriesCollection seriesCollection, int n) {
        SeriesAttrMarkerType seriesAttrMarkerType = (SeriesAttrMarkerType)seriesCollection.getSeriesCondition(new SeriesAttrMarkerType(), n);
        this.setMarker(MarkerFactory.createIndexMarker(seriesAttrMarkerType.getMarkerTypeIndex()));
        SeriesAttrColor seriesAttrColor = (SeriesAttrColor)seriesCollection.getSeriesCondition(new SeriesAttrColor(), n);
        this.setColor(seriesAttrColor.getSeriesColor());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setAlpha(seriesAttrAlpha.getAlpha());
    }

    public void dealCondition4Line(SeriesCollection seriesCollection, int n) {
        SeriesAttrMarkerType seriesAttrMarkerType = (SeriesAttrMarkerType)seriesCollection.getSeriesCondition(new SeriesAttrMarkerType(), n);
        Marker marker = MarkerFactory.createIndexMarker(seriesAttrMarkerType.getMarkerTypeIndex());
        this.setMarker(marker);
        SeriesAttrLine seriesAttrLine = (SeriesAttrLine)seriesCollection.getSeriesCondition(new SeriesAttrLine(), n);
        marker.setColor(seriesAttrLine.getSeriesLineColor());
        this.setColor(seriesAttrLine.getSeriesLineColor());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)seriesCollection.getSeriesCondition(new SeriesAttrAlpha(), n);
        this.setAlpha(seriesAttrAlpha.getAlpha());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("x");
                if (string2 != null) {
                    this.x = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("y")) != null) {
                    this.y = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("width")) != null) {
                    this.width = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("height")) != null) {
                    this.height = Double.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("alpha")) != null) {
                    this.setAlpha(Float.valueOf(string2).floatValue());
                }
                if ((string2 = xMLableReader.getAttr("color")) != null) {
                    this.setColor(new Color(Integer.parseInt(string2), true));
                }
            } else if (string.equals("Marker")) {
                this.setMarker(BaseXMLUtils.readMarker(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("x", this.x).attr("y", this.y).attr("width", this.width).attr("height", this.height).attr("alpha", this.alpha);
        if (this.getColor() != null) {
            xMLPrintWriter.attr("color", this.getColor().getRGB());
        }
        xMLPrintWriter.end();
        if (this.getMarker() != null) {
            BaseXMLUtils.writeMarker(xMLPrintWriter, this.getMarker());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MarkerGlyph)) {
            return false;
        }
        MarkerGlyph markerGlyph = (MarkerGlyph)object;
        if (markerGlyph.getAlpha() != this.getAlpha()) {
            return false;
        }
        if (markerGlyph.x != this.x || markerGlyph.y != this.y || markerGlyph.width != this.width || markerGlyph.height != this.height) {
            return false;
        }
        if (!Equals.equals(markerGlyph.getColor(), this.getColor())) {
            return false;
        }
        return Equals.equals(markerGlyph.getMarker(), this.getMarker());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("alpha", this.alpha);
        jSONObject.put("color", this.color);
        return jSONObject;
    }
}

