/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.core.DoubleDimension2D;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.plot.MeterInterval;
import com.fr.chart.plot.MeterStyle;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.util.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;

public class Meter
extends SoloGlyph {
    private static final long serialVersionUID = 3950923513149375891L;
    public static final String XML_TAG = "Meter";
    private double value;
    private TextGlyph titleGlyph;
    private MeterStyle meterStyle;
    private Rectangle2D bounds;
    private transient Rectangle2D meterArea;
    private transient double meterMiddleX;
    private transient double meterMiddleY;
    private transient double radius;
    private transient Rectangle2D roundBounds;

    public Meter() {
    }

    public Meter(TextGlyph textGlyph, double d, MeterStyle meterStyle) {
        this.setTitle(textGlyph);
        this.setValue(d);
        this.meterStyle = meterStyle;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void draw(Graphics graphics) {
        this.initTransientValue();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fillBackground(graphics2D);
        this.drawTicks(graphics2D);
        int n = this.meterStyle.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            this.drawArcForInterval(graphics2D, this.meterStyle.getInterval(i));
        }
        this.drawValueLabel(graphics2D);
        this.drawArrow(graphics2D);
        if (this.getTitle() != null) {
            this.getTitle().draw(graphics2D);
        }
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    private void initTransientValue() {
        double d = 6.0;
        double d2 = 6.0;
        double d3 = 4.0 + d / 2.0;
        double d4 = 4.0 + d2 / 2.0;
        double d5 = this.bounds.getWidth() - 8.0 - d;
        double d6 = this.bounds.getHeight() - 8.0 - d2 + (this.getMeterStyle().getMeterAngle() <= 180 && !this.getMeterStyle().getDialShape().equals("CIRCLE") ? this.bounds.getHeight() / 1.25 : 0.0);
        double d7 = Math.min(d5, d6) / 2.0;
        d3 = (d3 + d3 + d5) / 2.0 - d7;
        d4 = (d4 + d4 + d6) / 2.0 - d7;
        d5 = 2.0 * d7;
        d6 = 2.0 * d7;
        this.meterArea = new Rectangle2D.Double(d3, d4, d5, d6);
        this.meterMiddleX = this.meterArea.getCenterX();
        this.meterMiddleY = this.meterArea.getCenterY();
        this.radius = this.meterArea.getWidth() / 2.0 + 3.0;
        this.roundBounds = new Rectangle2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    private void fillBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = this.meterStyle.getDialBackgroundColor();
        if (color != null) {
            graphics2D.setPaint(color);
            double d = this.valueToAngle(this.meterStyle.getStartValue());
            double d2 = this.valueToAngle(this.meterStyle.getEndValue()) - d;
            int n = 0;
            if (this.meterStyle.getDialShape().equals("PIE")) {
                n = this.meterStyle.getMeterAngle() > 180 ? 1 : 2;
            } else if (this.meterStyle.getDialShape().equals("CIRCLE")) {
                n = 2;
                d2 = 360.0;
            } else {
                throw new IllegalStateException("DialShape not recognised.");
            }
            Arc2D.Double double_ = new Arc2D.Double(this.roundBounds, d, d2, n);
            graphics2D.fill(double_);
            graphics2D.setPaint(new Color(182, 182, 182));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
            graphics2D.drawArc((int)(this.meterMiddleX - this.radius), (int)(this.meterMiddleY - this.radius), (int)(2.0 * this.radius), (int)(2.0 * this.radius), (int)d, (int)d2);
            graphics2D.setStroke(stroke);
            double d3 = this.radius * 0.6 + 1.0;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(this.meterMiddleX - d3, this.meterMiddleY - d3, 2.0 * d3, 2.0 * d3);
            graphics2D.fill(new Arc2D.Double(double_2, d, d2, n));
        }
        graphics2D.setPaint(paint);
    }

    private void drawArrow(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(this.meterStyle.getNeedleColor());
        double d = this.radius * 0.1 > 8.0 ? 8.0 : this.radius * 0.1;
        graphics2D.fill(new Arc2D.Double(this.meterMiddleX - d, this.meterMiddleY - d, d * 2.0, d * 2.0, 0.0, 360.0, 1));
        if (this.getValue() >= this.meterStyle.getStartValue() && this.getValue() <= this.meterStyle.getEndValue()) {
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
            double d2 = this.meterMiddleX + 0.975 * this.radius * Math.cos(Math.PI * (this.valueToAngle(this.getValue()) / 180.0));
            double d3 = this.meterMiddleY - 0.975 * this.radius * Math.sin(Math.PI * (this.valueToAngle(this.getValue()) / 180.0));
            double d4 = this.meterMiddleX - (d + 5.0) * Math.cos(Math.PI * (this.valueToAngle(this.getValue()) / 180.0));
            double d5 = this.meterMiddleY + (d + 5.0) * Math.sin(Math.PI * (this.valueToAngle(this.getValue()) / 180.0));
            graphics2D.draw(new Line2D.Double(d4, d5, d2, d3));
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    public Shape getShape() {
        return this.getBounds();
    }

    private double valueToAngle(double d) {
        double d2 = this.getMeterStyle().getMeterAngle() / 2 + 90;
        return d2 - (d -= this.getMeterStyle().getStartValue()) / (this.getMeterStyle().getEndValue() - this.getMeterStyle().getStartValue()) * (double)this.getMeterStyle().getMeterAngle();
    }

    private void drawValueLabel(Graphics2D graphics2D) {
        String string = "No value";
        Format format = this.meterStyle.getUnitFormat();
        string = format != null ? format.format(Double.valueOf(Utils.doubleToString(this.getValue()))) + " " + this.meterStyle.getUnits() : this.getValue() + " " + this.meterStyle.getUnits();
        TextAttr textAttr = new TextAttr(this.getFont(new Dimension((int)(this.radius * 0.5), (int)(this.radius * 0.2)), string));
        Dimension2D dimension2D = TextGlyph.calculateTextDimension(string, textAttr);
        double d = this.meterArea.getHeight() / 10.0 > 20.0 ? 20.0 : this.meterArea.getHeight() / 10.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.meterMiddleX - dimension2D.getWidth() / 2.0, this.meterMiddleY + d, dimension2D.getWidth(), dimension2D.getHeight());
        TextGlyph.drawLabel(graphics2D, string, textAttr, double_);
    }

    private void drawArcForInterval(Graphics2D graphics2D, MeterInterval meterInterval) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(meterInterval.getBackgroundColor());
        double d = this.valueToAngle(meterInterval.getBeginValue());
        double d2 = this.valueToAngle(meterInterval.getEndValue());
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        float f = (float)(this.radius * 0.6);
        while ((double)f < this.radius * 0.6 + (double)meterInterval.getOutlineSize()) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.meterMiddleX - (double)f, this.meterMiddleY - (double)f, 2.0f * f, 2.0f * f);
            graphics2D.draw(new Arc2D.Double(double_, d, d2 - d, 0));
            f += 1.0f;
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private void drawTicks(Graphics2D graphics2D) {
        double d = this.meterStyle.getTickSize();
        if (d != 0.0) {
            double d2;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.meterStyle.getTickColor());
            double d3 = this.meterStyle.getStartValue();
            double d4 = this.meterStyle.getEndValue();
            FRFont fRFont = this.getTickLabelFont();
            double d5 = this.radius - 8.0 < 0.95 * this.radius ? this.radius - 8.0 : 0.95 * this.radius;
            BigDecimal bigDecimal = new BigDecimal(Double.toString(d3)).subtract(new BigDecimal(Double.toString(d)));
            for (d2 = d3; d2 <= d4; d2 += d) {
                bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d)));
                this.drawTickLine(graphics2D, d2, d5, this.meterStyle.getTickColor());
                this.drawTickLabel(graphics2D, bigDecimal.doubleValue(), 0.85 * this.radius, fRFont);
            }
            d2 = this.radius - 5.0 < 0.95 * this.radius ? this.radius - 5.0 : 0.95 * this.radius;
            for (double d6 = d3; d6 <= d4; d6 += d / 5.0) {
                if ((d6 - d3) % d == 0.0) continue;
                this.drawTickLine(graphics2D, d6, d2, this.meterStyle.getTickColor());
            }
            graphics2D.setPaint(paint);
        }
    }

    private void drawTickLine(Graphics2D graphics2D, double d, double d2, Color color) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        double d3 = this.valueToAngle(d);
        double d4 = this.meterMiddleX + (this.radius - 1.0) * Math.cos(Math.PI * (d3 / 180.0));
        double d5 = this.meterMiddleY - (this.radius - 1.0) * Math.sin(Math.PI * (d3 / 180.0));
        double d6 = this.meterMiddleX + d2 * Math.cos(Math.PI * (d3 / 180.0));
        double d7 = this.meterMiddleY - d2 * Math.sin(Math.PI * (d3 / 180.0));
        graphics2D.draw(new Line2D.Double(d6, d7, d4, d5));
        graphics2D.setPaint(paint);
    }

    private void drawTickLabel(Graphics2D graphics2D, double d, double d2, FRFont fRFont) {
        Font font = graphics2D.getFont();
        if (this.meterStyle.isTickLabelsVisible()) {
            double d3 = this.valueToAngle(d);
            String string = this.meterStyle.getUnitFormat() != null ? this.meterStyle.getUnitFormat().format(Double.valueOf(Utils.doubleToString(d))).toString() : Utils.doubleToString(d);
            graphics2D.setFont(fRFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = this.getTextBounds(string, graphics2D, fontMetrics);
            double d4 = this.meterMiddleX + d2 * Math.cos(Math.PI * (d3 / 180.0));
            double d5 = this.meterMiddleY - d2 * Math.sin(Math.PI * (d3 / 180.0));
            if (d3 == 90.0 || d3 == 270.0) {
                d4 -= rectangle2D.getWidth() / 2.0;
                d5 += rectangle2D.getHeight() / 4.0;
            } else if (d3 < 90.0 || d3 > 270.0) {
                d4 -= rectangle2D.getWidth() / 2.0;
            } else if (d3 > 90.0 || d3 < 270.0) {
                d5 += rectangle2D.getHeight() / 2.0;
                d4 -= rectangle2D.getWidth() / 2.0;
            }
            graphics2D.drawString(string, (float)d4, (float)d5);
        }
        graphics2D.setFont(font);
    }

    private FRFont getTickLabelFont() {
        double d = this.meterStyle.getTickSize();
        if (this.meterStyle.isTickLabelsVisible() && d != 0.0) {
            FRFont fRFont = null;
            double d2 = this.meterStyle.getStartValue();
            double d3 = this.meterStyle.getEndValue();
            DoubleDimension2D doubleDimension2D = new DoubleDimension2D(this.radius * 0.2, this.radius * 0.2);
            BigDecimal bigDecimal = new BigDecimal(Double.toString(d2)).subtract(new BigDecimal(Double.toString(d)));
            for (double d4 = d2; d4 <= d3; d4 += d) {
                bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d)));
                String string = this.meterStyle.getUnitFormat() != null ? this.meterStyle.getUnitFormat().format(Double.valueOf(Utils.doubleToString(bigDecimal.doubleValue()))).toString() : Utils.doubleToString(bigDecimal.doubleValue());
                FRFont fRFont2 = this.getFont(doubleDimension2D, string);
                if (d4 == d2) {
                    fRFont = fRFont2;
                    continue;
                }
                if (fRFont2.getSize() >= fRFont.getSize()) continue;
                fRFont = fRFont2;
            }
            return fRFont;
        }
        return null;
    }

    private FRFont getFont(Dimension2D dimension2D, String string) {
        FRFont fRFont = FRContext.getDefaultValues().getFRFont();
        fRFont = fRFont.applySize(6);
        Dimension2D dimension2D2 = TextGlyph.calculateTextDimension(string, new TextAttr(fRFont));
        while (dimension2D2.getHeight() < dimension2D.getHeight() && dimension2D2.getWidth() < dimension2D.getWidth()) {
            fRFont = fRFont.applySize(fRFont.getSize() + 1);
            dimension2D2 = TextGlyph.calculateTextDimension(string, new TextAttr(fRFont));
            if (fRFont.getSize() <= 11) continue;
            return fRFont;
        }
        return fRFont;
    }

    private Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = fontMetrics.getFont().getLineMetrics(string, graphics2D.getFontRenderContext());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), lineMetrics.getHeight());
        return rectangle2D;
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setTitle(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public TextGlyph getTitle() {
        return this.titleGlyph;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Value")) {
                String string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    this.setValue(Double.valueOf(string2));
                }
            } else if (string.equals("TextGlyph")) {
                this.titleGlyph = (TextGlyph)xMLableReader.readXMLObject(new TextGlyph());
            } else if (string.equals("MeterStyle")) {
                this.setMeterStyle((MeterStyle)xMLableReader.readXMLObject(new MeterStyle()));
            } else if (string.equals("Bounds")) {
                this.setBounds(ReportXMLUtils.readBounds(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Value").attr("value", this.getValue()).end();
        if (this.getTitle() != null) {
            this.getTitle().writeXML(xMLPrintWriter);
        }
        if (this.meterStyle != null) {
            this.meterStyle.writeXML(xMLPrintWriter);
        }
        if (this.bounds != null) {
            ReportXMLUtils.writeBounds(xMLPrintWriter, this.bounds);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Meter)) {
            return false;
        }
        Meter meter = (Meter)object;
        if (!Equals.equals(meter.getBounds(), this.getBounds())) {
            return false;
        }
        if (meter.getValue() != this.getValue()) {
            return false;
        }
        if (!Equals.equals(meter.getMeterStyle(), this.getMeterStyle())) {
            return false;
        }
        return Equals.equals(meter.getTitle(), this.getTitle());
    }

    public Object clone() throws CloneNotSupportedException {
        Meter meter = (Meter)super.clone();
        if (this.meterStyle != null) {
            meter.setMeterStyle((MeterStyle)this.meterStyle.clone());
        }
        if (this.bounds != null) {
            meter.setBounds((Rectangle2D)this.bounds.clone());
        }
        if (this.titleGlyph != null) {
            meter.setTitle((TextGlyph)this.titleGlyph.clone());
        }
        return meter;
    }
}

