/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import java.awt.Color;
import java.io.Serializable;

public class MeterInterval
implements Serializable,
XMLable {
    public static final String XML_TAG = "MeterInterval";
    private static final long serialVersionUID = 1530982090622488257L;
    private String label;
    private double beginValue;
    private double endValue;
    private Color backgroundColor = Color.BLACK;
    private Color outlineColor = Color.WHITE;
    private float outlineSize = 10.0f;

    public MeterInterval() {
    }

    public MeterInterval(String string, double d, double d2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (d > d2) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        this.label = string;
        this.beginValue = d;
        this.endValue = d2;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string == null ? "" : string;
    }

    public double getBeginValue() {
        return this.beginValue;
    }

    public void setBeginValue(double d) {
        this.beginValue = d;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public void setEndValue(double d) {
        this.endValue = d;
    }

    public void setOutlineSize(float f) {
        this.outlineSize = f;
    }

    public float getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("label", this.getLabel()).attr("beginValue", this.getBeginValue()).attr("endValue", this.getEndValue()).attr("backgroudColor", this.getBackgroundColor().getRGB()).attr("outlineColor", this.getOutlineColor().getRGB()).attr("outlineSize", this.getOutlineSize()).end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (XML_TAG.equals(string)) {
            String string2 = xMLableReader.getAttr("label");
            if (string2 != null) {
                this.setLabel(string2);
            }
            if ((string2 = xMLableReader.getAttr("beginValue")) != null) {
                this.setBeginValue(Double.parseDouble(string2));
            }
            if ((string2 = xMLableReader.getAttr("endValue")) != null) {
                this.setEndValue(Double.parseDouble(string2));
            }
            if ((string2 = xMLableReader.getAttr("backgroudColor")) != null) {
                this.setBackgroundColor(new Color(Integer.parseInt(string2), true));
            }
            if ((string2 = xMLableReader.getAttr("outlineColor")) != null) {
                this.setOutlineColor(new Color(Integer.parseInt(string2), true));
            }
            if ((string2 = xMLableReader.getAttr("outlineSize")) != null) {
                this.setOutlineSize(Float.parseFloat(string2));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MeterInterval)) {
            return false;
        }
        MeterInterval meterInterval = (MeterInterval)object;
        if (!Equals.equals(meterInterval.backgroundColor, this.backgroundColor)) {
            return false;
        }
        if (meterInterval.getBeginValue() != this.getBeginValue()) {
            return false;
        }
        if (meterInterval.getEndValue() != this.getEndValue()) {
            return false;
        }
        if (!Equals.equals(meterInterval.label, this.label)) {
            return false;
        }
        if (!Equals.equals(meterInterval.outlineColor, this.outlineColor)) {
            return false;
        }
        return meterInterval.getOutlineSize() == this.getOutlineSize();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("beginValue", this.beginValue);
        jSONObject.put("endValue", this.endValue);
        if (this.label != null) {
            jSONObject.put("label", this.label);
        }
        jSONObject.put("outlineSize", this.outlineSize);
        jSONObject.put("outlineColor", ChartUtils.color2JS(this.outlineColor));
        jSONObject.put("backgroundColor", ChartUtils.color2JS(this.backgroundColor));
        return jSONObject;
    }
}

