/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.Inter;
import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.plot.MeterInterval;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class MeterStyle
implements XMLable {
    private static final long serialVersionUID = -7636054199242127287L;
    public static final String XML_TAG = "MeterStyle";
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final String CIRCLE = "CIRCLE";
    public static final String PIE = "PIE";
    private String dialShape = "CIRCLE";
    private int meterAngle = 300;
    private double startValue = 0.0;
    private double endValue = 400.0;
    private double tickSize = 50.0;
    private Color tickColor = new Color(47, 46, 46);
    private String units = Inter.getLocText("Unit");
    private Format unitFormat;
    private Color needleColor = new Color(47, 46, 46);
    private Color dialBackgroundColor = new Color(248, 248, 248);
    private boolean tickLabelsVisible = true;
    private TextAttr titleTextAttr = new TextAttr();
    private List intervals;

    public MeterStyle() {
        this.setIntervals(new ArrayList());
        MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field") + 1 + "(" + Inter.getLocText("Default") + ")", this.startValue, 3.0 * this.endValue / 8.0);
        meterInterval.setBackgroundColor(new Color(19, 174, 227));
        this.getIntervals().add(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field") + 2 + "(" + Inter.getLocText("Default") + ")", 3.0 * this.endValue / 8.0, 3.0 * this.endValue / 4.0);
        meterInterval.setBackgroundColor(new Color(251, 224, 78));
        this.getIntervals().add(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field") + 3 + "(" + Inter.getLocText("Default") + ")", 3.0 * this.endValue / 4.0, this.endValue);
        meterInterval.setBackgroundColor(new Color(228, 108, 138));
        this.getIntervals().add(meterInterval);
    }

    public String getDialShape() {
        return this.dialShape;
    }

    public void setDialShape(String string) {
        this.dialShape = string;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        this.meterAngle = n;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double d) {
        this.startValue = d;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public void setEndValue(double d) {
        this.endValue = d;
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(double d) {
        this.tickSize = d;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
    }

    public void setDialBackgroundColor(Color color) {
        this.dialBackgroundColor = color;
    }

    public Color getDialBackgroundColor() {
        return this.dialBackgroundColor;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public void setUnitFormat(Format format) {
        this.unitFormat = format;
    }

    public Format getUnitFormat() {
        return this.unitFormat;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public void setNeedleColor(Color color) {
        this.needleColor = color;
    }

    public void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible = bl;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTitleTextAttr(TextAttr textAttr) {
        this.titleTextAttr = textAttr;
    }

    public TextAttr getTitleTextAttr() {
        return this.titleTextAttr;
    }

    public void addInterval(MeterInterval meterInterval) {
        this.getIntervals().add(meterInterval);
    }

    public int getIntervalCount() {
        return this.getIntervals().size();
    }

    public MeterInterval getInterval(int n) {
        if (n < 0 || n >= this.getIntervalCount()) {
            return null;
        }
        return (MeterInterval)this.getIntervals().get(n);
    }

    public void clearAllInterval() {
        if (this.getIntervals() == null) {
            return;
        }
        this.getIntervals().clear();
    }

    public void setIntervals(List list) {
        this.intervals = list;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("meterAngle", this.getMeterAngle()).attr("startValue", this.getStartValue()).attr("endValue", this.getEndValue()).attr("tickSize", this.getTickSize()).attr("tickColor", this.getTickColor().getRGB()).attr("units", this.getUnits()).attr("needleColor", this.getNeedleColor().getRGB()).attr("dialBackgroundColor", this.getDialBackgroundColor().getRGB()).attr("tickLabelsVisible", this.isTickLabelsVisible()).attr("dialShape", this.dialShape).end();
        if (this.getTitleTextAttr() != null) {
            this.getTitleTextAttr().writeXML(xMLPrintWriter);
        }
        if (this.getUnitFormat() != null) {
            ReportXMLUtils.writeFormat(xMLPrintWriter, this.unitFormat);
        }
        if (this.getIntervals() != null && this.getIntervals().size() > 0) {
            xMLPrintWriter.startTAG("IntervalList");
            int n = this.getIntervals().size();
            for (int i = 0; i < n; ++i) {
                MeterInterval meterInterval = (MeterInterval)this.getIntervals().get(i);
                meterInterval.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                String string2 = xMLableReader.getAttr("meterAngle");
                if (string2 != null) {
                    this.setMeterAngle(Integer.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("startValue")) != null) {
                    this.setStartValue(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("endValue")) != null) {
                    this.setEndValue(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("tickSize")) != null) {
                    this.setTickSize(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("tickColor")) != null) {
                    this.setTickColor(new Color(Integer.parseInt(string2), true));
                }
                if ((string2 = xMLableReader.getAttr("units")) != null) {
                    this.setUnits(string2);
                }
                if ((string2 = xMLableReader.getAttr("needleColor")) != null) {
                    this.setNeedleColor(new Color(Integer.parseInt(string2), true));
                }
                if ((string2 = xMLableReader.getAttr("dialBackgroudColor")) != null || (string2 = xMLableReader.getAttr("dialBackgroundColor")) != null) {
                    this.setDialBackgroundColor(new Color(Integer.parseInt(string2), true));
                }
                if ((string2 = xMLableReader.getAttr("tickLabelsVisible")) != null) {
                    this.setTickLabelsVisible(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("dialShape")) != null) {
                    this.dialShape = string2;
                }
            } else if ("TextAttr".equals(string)) {
                this.titleTextAttr = (TextAttr)xMLableReader.readXMLObject(new TextAttr());
            } else if ("Format".equals(string)) {
                this.unitFormat = ReportXMLUtils.readFormat(xMLableReader);
            } else if ("IntervalList".equals(string)) {
                this.getIntervals().clear();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "MeterInterval".equals(xMLableReader.getTagName())) {
                            MeterStyle.this.getIntervals().add(xMLableReader.readXMLObject(new MeterInterval()));
                        }
                    }
                });
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MeterStyle meterStyle = (MeterStyle)super.clone();
        if (this.titleTextAttr != null) {
            meterStyle.titleTextAttr = (TextAttr)this.titleTextAttr.clone();
        }
        if (this.unitFormat != null) {
            meterStyle.unitFormat = (Format)this.unitFormat.clone();
        }
        if (this.intervals != null) {
            meterStyle.setIntervals(new ArrayList());
            ListIterator listIterator = this.getIntervals().listIterator();
            while (listIterator.hasNext()) {
                meterStyle.getIntervals().add(listIterator.next());
            }
        }
        return meterStyle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MeterStyle)) {
            return false;
        }
        MeterStyle meterStyle = (MeterStyle)object;
        if (!Equals.equals(meterStyle.getDialShape(), this.getDialShape())) {
            return false;
        }
        if (meterStyle.getStartValue() != this.getStartValue()) {
            return false;
        }
        if (meterStyle.getEndValue() != this.getEndValue()) {
            return false;
        }
        if (meterStyle.getMeterAngle() != this.getMeterAngle()) {
            return false;
        }
        if (meterStyle.getTickSize() != this.getTickSize()) {
            return false;
        }
        if (!Equals.equals(meterStyle.getTickColor(), this.getTickColor())) {
            return false;
        }
        if (!Equals.equals(meterStyle.getUnits(), this.getUnits())) {
            return false;
        }
        if (!Equals.equals(meterStyle.getUnitFormat(), this.getUnitFormat())) {
            return false;
        }
        if (!Equals.equals(meterStyle.getNeedleColor(), this.getNeedleColor())) {
            return false;
        }
        if (!Equals.equals(meterStyle.getDialBackgroundColor(), this.getDialBackgroundColor())) {
            return false;
        }
        if (!Equals.equals(meterStyle.getTitleTextAttr(), this.getTitleTextAttr())) {
            return false;
        }
        if (meterStyle.isTickLabelsVisible() != this.isTickLabelsVisible()) {
            return false;
        }
        if (meterStyle.getIntervals() != null) {
            if (meterStyle.getIntervals().size() != this.getIntervals().size()) {
                return false;
            }
            for (int i = 0; i < meterStyle.getIntervals().size(); ++i) {
                if (meterStyle.getInterval(i).equals(this.getInterval(i))) continue;
                return false;
            }
        }
        return true;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("startValue", this.startValue);
        jSONObject.put("endValue", this.endValue);
        jSONObject.put("meterAngle", this.meterAngle);
        jSONObject.put("tickSize", this.tickSize);
        jSONObject.put("dialShape", this.dialShape);
        jSONObject.put("tickLabelsVisible", this.tickLabelsVisible);
        jSONObject.put("units", this.units);
        jSONObject.put("tickColor", ChartUtils.color2JS(this.tickColor));
        jSONObject.put("dialBackgroundColor", ChartUtils.color2JS(this.dialBackgroundColor));
        jSONObject.put("needleColor", ChartUtils.color2JS(this.needleColor));
        if (this.unitFormat != null) {
            jSONObject.put("unitFormat", ChartUtils.format2JS(this.unitFormat));
        }
        jSONObject.put("titleTextAttr", this.titleTextAttr.toJSONObject());
        if (this.intervals != null && this.intervals.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.intervals.size(); ++i) {
                arrayList.add(this.getInterval(i).toJSONObject());
            }
            jSONObject.put("intervals", arrayList.toArray());
        }
        return jSONObject;
    }
}

