/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.Pie3DPlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.math.Object3D;
import com.fr.chart.math.Projection;
import com.fr.chart.plot.PiePlot;
import com.fr.data.ChartData;

public class Pie3DPlot
extends PiePlot
implements Object3D {
    private static final long serialVersionUID = -5601071892216143828L;
    private int depth = 20;
    private Projection projection = new Projection();

    public Pie3DPlot() {
        this.projection.setRotation(0);
        this.projection.setElevation(25);
        this.projection.setFocus(800);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Pie3DPlotGlyph pie3DPlotGlyph = new Pie3DPlotGlyph();
        chartData = this.create65Data4New(chartData);
        this.install4PlotGlyph(pie3DPlotGlyph, chartData);
        return pie3DPlotGlyph;
    }

    public void install4PlotGlyph(Pie3DPlotGlyph pie3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(pie3DPlotGlyph, chartData);
        pie3DPlotGlyph.setDepth(this.depth);
        pie3DPlotGlyph.setProjection(this.projection);
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, int n) {
        this.dealColorCondition(lineMarkerIcon, n);
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Projection".equals(string2)) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if ("Depth".equals(string2) && (string = xMLableReader.getAttr("value")) != null) {
                this.setDepth(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Depth").attr("value", this.getDepth()).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlot pie3DPlot = (Pie3DPlot)super.clone();
        if (this.projection != null) {
            pie3DPlot.projection = (Projection)this.projection.clone();
        }
        return pie3DPlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3DPlot)) {
            return false;
        }
        Pie3DPlot pie3DPlot = (Pie3DPlot)object;
        if (!super.equals(pie3DPlot)) {
            return false;
        }
        if (pie3DPlot.getDepth() != this.getDepth()) {
            return false;
        }
        return Equals.equals(pie3DPlot.projection, this.projection);
    }
}

