/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.core.glyph.PiePlotGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import com.fr.data.impl.ReportChartData;
import java.util.ArrayList;

public class PiePlot
extends Plot {
    private static final long serialVersionUID = -4335570991687277300L;
    protected int startAngle = 100;
    protected int separatePercent = 0;

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        PiePlotGlyph piePlotGlyph = new PiePlotGlyph();
        chartData = this.create65Data4New(chartData);
        this.install4PlotGlyph(piePlotGlyph, chartData);
        return piePlotGlyph;
    }

    protected ChartData create65Data4New(ChartData chartData) {
        int n = chartData.getSeriesCount();
        int n2 = chartData.getCategoryLabelCount();
        if (n == 1) {
            int n3;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = chartData.getCategoryLabel(i);
            }
            Object[] objectArray2 = new Object[n];
            int n4 = n3 = n == 1 ? 0 : 1;
            while (n3 < n) {
                objectArray2[n3] = chartData.getSeriesLabel(n3);
                ++n3;
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            ArrayList<Number> arrayList2 = new ArrayList<Number>();
            for (int i = 0; i < n2; ++i) {
                arrayList2 = new ArrayList();
                arrayList2.add(chartData.getValueAt(0, i));
                arrayList.add(arrayList2.toArray());
            }
            Object[][] objectArray3 = (Object[][])arrayList.toArray((T[])new Object[1][]);
            chartData = new ReportChartData(objectArray2, objectArray, objectArray3);
        }
        return chartData;
    }

    public void install4PlotGlyph(PiePlotGlyph piePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(piePlotGlyph, chartData);
        piePlotGlyph.setSeparatePercent(this.separatePercent);
        piePlotGlyph.setStartAngle(this.startAngle);
    }

    public void setStartAngle(int n) {
        this.startAngle = n;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setSeparatePercent(int n) {
        this.separatePercent = n;
    }

    public int getSeparatePercent() {
        return this.separatePercent;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && ((PiePlot)plot).getSeparatePercent() == this.getSeparatePercent();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PieAttr").attr("startAngle", this.startAngle).attr("separate", this.separatePercent).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "PieAttr".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttr("startAngle");
            if (string2 != null) {
                this.setStartAngle(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("separate")) != null) {
                this.setSeparatePercent(Integer.parseInt(string2));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PiePlot)) {
            return false;
        }
        PiePlot piePlot = (PiePlot)object;
        if (!super.equals(piePlot)) {
            return false;
        }
        if (piePlot.getStartAngle() != this.getStartAngle()) {
            return false;
        }
        return piePlot.getSeparatePercent() == this.getSeparatePercent();
    }
}

