/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartModule;
import com.fr.chart.DataSeriesCondition;
import com.fr.chart.LineStyleInfo;
import com.fr.chart.axis.DataLabelInfo;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.axis.SeriesAttrColor;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.axis.SeriesAttrMarkerType;
import com.fr.chart.axis.SeriesAttrTrendLine;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.ChartXMLCompatibleUtils;
import com.fr.chart.core.glyph.LegendGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.legend.Legend;
import com.fr.chart.legend.LegendItem;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.marker.Marker;
import com.fr.chart.marker.MarkerFactory;
import com.fr.chart.plot.CustomAttr;
import com.fr.chart.plot.CustomPlot;
import com.fr.chart.plot.DataPoint;
import com.fr.chart.plot.DataSeries;
import com.fr.chart.plot.SeriesCollection;
import com.fr.data.ChartData;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.util.Utils;
import java.util.Date;

public abstract class Plot
extends ChartModule {
    private static final long serialVersionUID = 6362269816037714449L;
    public static final String XML_TAG = "Plot";
    private SeriesCollection seriesCollection = new SeriesCollection();
    private NameJavaScriptGroup hotHyperLink;
    private String hotTooltip = null;
    private boolean isNullValueBreak = true;
    protected Legend legend = new Legend();

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setSeriesCollection(SeriesCollection seriesCollection) {
        this.seriesCollection = seriesCollection;
    }

    public SeriesCollection getSeriesCollection() {
        return this.seriesCollection;
    }

    public void setHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup) {
        this.hotHyperLink = nameJavaScriptGroup;
    }

    public NameJavaScriptGroup getHotHyperLink() {
        return this.hotHyperLink;
    }

    public void setHotTooltip(String string) {
        this.hotTooltip = string;
    }

    public String getHotTooltip() {
        return this.hotTooltip;
    }

    public void setNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public abstract PlotGlyph createPlotGlyph(ChartData var1);

    public void install4PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeries2PlotGlyph(plotGlyph, chartData);
        plotGlyph.setInfo(this.getInfo());
        plotGlyph.setSeriesCollection(this.getSeriesCollection());
        plotGlyph.setHotHyperLink(this.hotHyperLink);
        plotGlyph.setHotTooltip(this.hotTooltip);
        plotGlyph.setIsNullValueBreak(this.isNullValueBreak);
    }

    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        LegendGlyph legendGlyph = null;
        if (this.legend != null) {
            legendGlyph = this.legend.createLegendGlyph(this.createLegendItems(plotGlyph));
        }
        return legendGlyph;
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph) {
        int n;
        int n2 = plotGlyph.getSeriesSize();
        for (int i = 0; i < plotGlyph.getSeriesSize(); ++i) {
            SeriesAttrTrendLine seriesAttrTrendLine = (SeriesAttrTrendLine)this.seriesCollection.getSeriesCondition(new SeriesAttrTrendLine(), i);
            if (seriesAttrTrendLine == null || seriesAttrTrendLine.getLine() == null) continue;
            ++n2;
        }
        LegendItem[] legendItemArray = new LegendItem[n2];
        for (n = 0; n < plotGlyph.getSeriesSize(); ++n) {
            legendItemArray[n] = new LegendItem(plotGlyph.getSeries(n).getSeriesName());
            legendItemArray[n].setLineMarkerIcon(this.getLineMarkerIconByIndex(n));
        }
        n2 = plotGlyph.getSeriesSize();
        for (n = 0; n < plotGlyph.getSeriesSize(); ++n) {
            SeriesAttrTrendLine seriesAttrTrendLine = (SeriesAttrTrendLine)this.seriesCollection.getSeriesCondition(new SeriesAttrTrendLine(), n);
            if (seriesAttrTrendLine == null || seriesAttrTrendLine.getLine() == null) continue;
            legendItemArray[n2] = new LegendItem(seriesAttrTrendLine.getName());
            LineStyleInfo lineStyleInfo = seriesAttrTrendLine.getLine().getLineStyleInfo();
            legendItemArray[n2].setLineMarkerIcon(new LineMarkerIcon(lineStyleInfo.getSeriesLineColor(), 1, null));
            ++n2;
        }
        return legendItemArray;
    }

    protected LineMarkerIcon getLineMarkerIconByIndex(int n) {
        DataSeriesCondition dataSeriesCondition;
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        if (this.showLegendLine()) {
            lineMarkerIcon.setLineStyle(1);
            dataSeriesCondition = (SeriesAttrColor)this.getSeriesCollection().getSeriesCondition(new SeriesAttrColor(), n);
            lineMarkerIcon.setColor(((SeriesAttrColor)dataSeriesCondition).getSeriesColor());
        }
        if (this.showLegendMarker()) {
            dataSeriesCondition = (SeriesAttrMarkerType)this.getSeriesCollection().getSeriesCondition(new SeriesAttrMarkerType(), n);
            Marker marker = MarkerFactory.createIndexMarker(((SeriesAttrMarkerType)dataSeriesCondition).getMarkerTypeIndex());
            marker.setSize(marker.getSize() * 0.6);
            lineMarkerIcon.setMarker(marker);
            SeriesAttrColor seriesAttrColor = (SeriesAttrColor)this.getSeriesCollection().getSeriesCondition(new SeriesAttrColor(), n);
            marker.setColor(seriesAttrColor.getSeriesColor());
        }
        this.dealCondition(lineMarkerIcon, n);
        return lineMarkerIcon;
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, int n) {
        SeriesAttrBackground seriesAttrBackground = (SeriesAttrBackground)this.getSeriesCollection().getSeriesCondition(new SeriesAttrBackground(), n);
        lineMarkerIcon.setBackground(seriesAttrBackground.getSeriesBackground());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)this.getSeriesCollection().getSeriesCondition(new SeriesAttrAlpha(), n);
        lineMarkerIcon.setAlpha(seriesAttrAlpha.getAlpha());
    }

    protected void dealColorCondition(LineMarkerIcon lineMarkerIcon, int n) {
        SeriesAttrColor seriesAttrColor = (SeriesAttrColor)this.getSeriesCollection().getSeriesCondition(new SeriesAttrColor(), n);
        lineMarkerIcon.setColor(seriesAttrColor.getSeriesColor());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)this.getSeriesCollection().getSeriesCondition(new SeriesAttrAlpha(), n);
        lineMarkerIcon.setAlpha(seriesAttrAlpha.getAlpha());
    }

    protected LineMarkerIcon getLineMarkerIconByIndex4Line(int n) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        SeriesAttrLine seriesAttrLine = (SeriesAttrLine)this.getSeriesCollection().getSeriesCondition(new SeriesAttrLine(), n);
        if (this.showLegendLine()) {
            lineMarkerIcon.setLineStyle(1);
        }
        if (this.showLegendMarker()) {
            SeriesAttrMarkerType seriesAttrMarkerType = (SeriesAttrMarkerType)this.getSeriesCollection().getSeriesCondition(new SeriesAttrMarkerType(), n);
            Marker marker = MarkerFactory.createIndexMarker(seriesAttrMarkerType.getMarkerTypeIndex());
            marker.setSize(marker.getSize() * 0.6);
            lineMarkerIcon.setMarker(marker);
            marker.setColor(seriesAttrLine.getSeriesLineColor());
        }
        this.dealLineCondition(lineMarkerIcon, n);
        return lineMarkerIcon;
    }

    protected void dealLineCondition(LineMarkerIcon lineMarkerIcon, int n) {
        SeriesAttrLine seriesAttrLine = (SeriesAttrLine)this.getSeriesCollection().getSeriesCondition(new SeriesAttrLine(), n);
        lineMarkerIcon.setColor(seriesAttrLine.getSeriesLineColor());
        SeriesAttrAlpha seriesAttrAlpha = (SeriesAttrAlpha)this.getSeriesCollection().getSeriesCondition(new SeriesAttrAlpha(), n);
        lineMarkerIcon.setAlpha(seriesAttrAlpha.getAlpha());
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeriesByIndex(0, chartData.getSeriesCount(), plotGlyph, chartData);
    }

    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, ChartData chartData) {
        int n3;
        int n4 = n3 = chartData == null ? 0 : chartData.getSeriesCount();
        for (int i = n; i < n2 && i < n3; ++i) {
            DataSeries dataSeries = new DataSeries(i - n);
            dataSeries.setSeriesName(Utils.objectToString(chartData.getSeriesLabel(i)));
            plotGlyph.addSeries(dataSeries);
            for (int j = 0; j < chartData.getCategoryLabelCount(); ++j) {
                DataPoint dataPoint = new DataPoint();
                dataPoint.setIndex(j);
                double d = 0.0;
                if (i < chartData.getSeriesCount() && j < chartData.getCategoryLabelCount()) {
                    Number number = chartData.getValueAt(i, j);
                    if (number != null) {
                        d = number.doubleValue();
                    } else {
                        dataPoint.setValueIsNull(true);
                        d = 0.0;
                    }
                    dataPoint.setValue(d);
                }
                if (j < chartData.getCategoryLabelCount()) {
                    dataPoint.setCategoryName(Utils.objectToString(chartData.getCategoryLabel(j)));
                }
                if (i < chartData.getSeriesCount()) {
                    dataPoint.setSeriesName(Utils.objectToString(chartData.getSeriesLabel(i)));
                }
                dataSeries.addDataPoint(dataPoint);
                dataPoint.setPercentValue(this.getPercent(chartData, j, i - n));
            }
        }
        this.createDataPointLabel(plotGlyph);
    }

    private double getPercent(ChartData chartData, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < chartData.getSeriesCount(); ++i) {
            Number number = chartData.getValueAt(i, n);
            if (number == null) continue;
            d += number.doubleValue();
        }
        Number number = chartData.getValueAt(n2, n);
        if (number != null) {
            d2 = number.doubleValue();
        }
        if (d == 0.0) {
            return 0.0;
        }
        return d2 / d;
    }

    protected void createDataPointLabel(PlotGlyph plotGlyph) {
        int n = plotGlyph.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = plotGlyph.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) continue;
                this.createDataLabel(dataPoint, i);
            }
        }
    }

    protected void createDataLabel(DataPoint dataPoint, int n) {
        DataLabelInfo dataLabelInfo = new DataLabelInfo();
        dataLabelInfo.dealCondition(this.getSeriesCollection(), n);
        TextGlyph textGlyph = new TextGlyph();
        textGlyph.dealCondition(this.getSeriesCollection(), n);
        String string = dataLabelInfo.createLabelText(dataPoint);
        if (string != null && string.length() > 0) {
            textGlyph.setText(dataLabelInfo.createLabelText(dataPoint));
        }
        textGlyph.setTextAttr(dataLabelInfo.getTextAttr());
        dataPoint.setDataLabel(textGlyph);
    }

    protected boolean showLegendLine() {
        return false;
    }

    protected boolean showLegendMarker() {
        return false;
    }

    public double getMaxValueFromData(ChartData chartData) {
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                Number number = chartData.getValueAt(j, i);
                if (number == null || i == 0 && j == 0) continue;
                d = number.doubleValue() > d ? number.doubleValue() : d;
            }
        }
        if (d == this.getMinValueFromData(chartData)) {
            return d + 10.0;
        }
        return d;
    }

    public double getMinValueFromData(ChartData chartData) {
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < chartData.getSeriesCount(); ++j) {
                Number number = chartData.getValueAt(j, i);
                if (number == null || i == 0 && j == 0) continue;
                d = number.doubleValue() < d ? number.doubleValue() : d;
            }
        }
        return d;
    }

    public boolean checkDate(ChartData chartData) {
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            Date date;
            if (chartData.getCategoryLabel(i) == null || (date = DateUtils.object2Date(chartData.getCategoryLabel(i), true)) != null) continue;
            return false;
        }
        return true;
    }

    public double[] getDateRange(ChartData chartData) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            Date date;
            if (chartData.getCategoryLabel(i) == null || (date = DateUtils.object2Date(chartData.getCategoryLabel(i), true)) == null) continue;
            double d3 = ChartUtils.date2Int(date);
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return new double[]{d - 1.0, d2 + 1.0};
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return ComparatorUtils.equals(this.getClass().getName(), plot.getClass().getName());
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("SeriesCollection")) {
                SeriesCollection seriesCollection = new SeriesCollection();
                if (this instanceof CustomPlot) {
                    seriesCollection.setDefaultSeriesAttr(new CustomAttr());
                }
                this.seriesCollection = ChartXMLCompatibleUtils.read65DataSeriesCollection(xMLableReader, seriesCollection);
            } else if ("NewSeriesCollection".equals(string)) {
                this.seriesCollection = (SeriesCollection)xMLableReader.readXMLObject(new SeriesCollection());
            } else if ("Legend".equals(string)) {
                this.legend = (Legend)xMLableReader.readXMLObject(new Legend());
            } else if ("NameJavaScriptGroup".equals(string) || "NameHyperlinks".equals(string) || "HyperlinkMap".equals(string)) {
                this.hotHyperLink = (NameJavaScriptGroup)xMLableReader.readXMLObject(new NameJavaScriptGroup());
            } else if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("hotTooltip");
                if (string2 != null) {
                    this.hotTooltip = string2;
                }
                if ((string2 = xMLableReader.getAttr("isNullValueBreak")) != null) {
                    this.isNullValueBreak = Boolean.valueOf(string2);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("hotTooltip", this.hotTooltip).attr("isNullValueBreak", this.isNullValueBreak).end();
        if (this.seriesCollection != null) {
            this.seriesCollection.writeXML(xMLPrintWriter);
        }
        if (this.legend != null) {
            this.legend.writeXML(xMLPrintWriter);
        }
        if (this.hotHyperLink != null) {
            this.hotHyperLink.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Plot plot = (Plot)super.clone();
        if (this.getSeriesCollection() != null) {
            plot.setSeriesCollection((SeriesCollection)this.getSeriesCollection().clone());
        }
        if (this.legend != null) {
            plot.legend = (Legend)this.legend.clone();
        }
        if (this.hotHyperLink != null) {
            plot.hotHyperLink = (NameJavaScriptGroup)this.hotHyperLink.clone();
        }
        return plot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Plot)) {
            return false;
        }
        Plot plot = (Plot)object;
        if (!super.equals(plot)) {
            return false;
        }
        if (!Equals.equals(plot.seriesCollection, this.seriesCollection)) {
            return false;
        }
        if (!Equals.equals(plot.hotHyperLink, this.hotHyperLink)) {
            return false;
        }
        if (!Equals.equals(this.hotTooltip, plot.hotTooltip)) {
            return false;
        }
        if (!Equals.equals(plot.getLegend(), this.getLegend())) {
            return false;
        }
        return this.isNullValueBreak == plot.isNullValueBreak;
    }
}

