/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.RadarAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.RadarAxisGlyph;
import com.fr.chart.core.glyph.RadarPlotGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;

public class RadarPlot
extends Plot {
    private static final long serialVersionUID = 224372350182474023L;
    private RadarAxis radarAxis = new RadarAxis();
    private boolean isFilled = false;
    private boolean showLine = true;
    private boolean showMarker = true;

    protected LineMarkerIcon getLineMarkerIconByIndex(int n) {
        return this.getLineMarkerIconByIndex4Line(n);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        RadarPlotGlyph radarPlotGlyph = new RadarPlotGlyph();
        this.install4PlotGlyph(radarPlotGlyph, chartData);
        this.createAxisGlyph(radarPlotGlyph, chartData);
        return radarPlotGlyph;
    }

    public void install4PlotGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(radarPlotGlyph, chartData);
        radarPlotGlyph.setFilled(this.isFilled);
        radarPlotGlyph.setShowLine(this.showLine);
        radarPlotGlyph.setShowMarker(this.showMarker);
    }

    private void createAxisGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        RadarPlotGlyph radarPlotGlyph2 = radarPlotGlyph;
        RadarAxisGlyph radarAxisGlyph = new RadarAxisGlyph(this.radarAxis);
        radarAxisGlyph.setCategoryCount(chartData.getCategoryLabelCount());
        radarAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxValueFromData(chartData));
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            radarAxisGlyph.addCategoryLabel(chartData.getCategoryLabel(i) == null ? "" : chartData.getCategoryLabel(i));
        }
        radarPlotGlyph2.setRadarAxisGlyph(radarAxisGlyph);
    }

    protected boolean showLegendLine() {
        return this.showLine;
    }

    protected boolean showLegendMarker() {
        return this.showMarker;
    }

    public RadarAxis getRadarAxis() {
        return this.radarAxis;
    }

    public void setRadarAxis(RadarAxis radarAxis) {
        this.radarAxis = radarAxis;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setIsFilled(boolean bl) {
        this.isFilled = bl;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public boolean isShowMarker() {
        return this.showMarker;
    }

    public void setShowMarker(boolean bl) {
        this.showMarker = bl;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && ((RadarPlot)plot).isFilled == this.isFilled && ((RadarPlot)plot).showLine == this.showLine && ((RadarPlot)plot).showMarker == this.showMarker;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("RadarAttr".equals(string2)) {
                String string3 = xMLableReader.getAttr("showMarker");
                if (string3 != null) {
                    this.setShowMarker(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("showLine")) != null) {
                    this.setShowLine(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("isFilled")) != null) {
                    this.setIsFilled(Boolean.valueOf(string3));
                }
            } else if ("RadarAxis".equals(string2) && (string = xMLableReader.getAttr("class")) != null && string.endsWith(".RadarAxis")) {
                this.radarAxis = (RadarAxis)xMLableReader.readXMLObject(new RadarAxis());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RadarAttr").attr("showMarker", this.showMarker).attr("showLine", this.showLine).attr("isFilled", this.isFilled).end();
        if (this.radarAxis != null) {
            this.radarAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RadarPlot)) {
            return false;
        }
        RadarPlot radarPlot = (RadarPlot)object;
        if (!super.equals(radarPlot)) {
            return false;
        }
        if (radarPlot.isFilled() != this.isFilled()) {
            return false;
        }
        if (radarPlot.isShowLine() != this.isShowLine()) {
            return false;
        }
        if (radarPlot.isShowMarker() != this.isShowMarker()) {
            return false;
        }
        return Equals.equals(radarPlot.radarAxis, this.radarAxis);
    }
}

