/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.LineGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.RangeAxisGlyph;
import com.fr.chart.core.glyph.RangePlotGlyph;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import java.awt.Color;

public class RangePlot
extends Plot {
    private static final long serialVersionUID = -7011404700170399167L;
    private Color middleLine2DColor = Color.black;
    private int middlLineStyle = 1;
    private Color minToAverageColor = new Color(215, 214, 214);
    private Color averageToMaxColor = new Color(240, 239, 239);
    private ValueAxis valueAxis;
    private double seriesWidth = 4.0;

    public RangePlot() {
        this.setValueAxis(new ValueAxis());
        this.getValueAxis().setPosition(3);
        ValueAxis valueAxis = this.getValueAxis();
        valueAxis.setMainGridColor(null);
        valueAxis.setMainGridStyle(0);
        valueAxis.setTickLength(20);
        valueAxis.setSecTickLength(10);
        valueAxis.setTickMarkType(3);
        valueAxis.setSecTickMarkType(3);
        valueAxis.setMainStroke(1.0f);
        valueAxis.setSecStroke(1.0f);
    }

    public void setValueAxis(ValueAxis valueAxis) {
        this.valueAxis = valueAxis;
    }

    public ValueAxis getValueAxis() {
        return this.valueAxis;
    }

    public void setMiddlLineStyle(int n) {
        this.middlLineStyle = n;
    }

    public int getMiddlLineStyle() {
        return this.middlLineStyle;
    }

    public void setSeriesWidth(double d) {
        this.seriesWidth = d;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public void setMiddleLine2DColor(Color color) {
        this.middleLine2DColor = color;
    }

    public Color getMiddleLine2DColor() {
        return this.middleLine2DColor;
    }

    public void setMinToAverageColor(Color color) {
        this.minToAverageColor = color;
    }

    public Color getMinToAverageColor() {
        return this.minToAverageColor;
    }

    public void setAverageToMaxColor(Color color) {
        this.averageToMaxColor = color;
    }

    public Color getAverageToMaxColor() {
        return this.averageToMaxColor;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        RangePlotGlyph rangePlotGlyph = new RangePlotGlyph();
        this.install4PlotGlyph(rangePlotGlyph, chartData);
        this.createAxisGlyph(rangePlotGlyph, chartData);
        this.createDataSeriesGlyph(rangePlotGlyph);
        return rangePlotGlyph;
    }

    public void install4PlotGlyph(RangePlotGlyph rangePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(rangePlotGlyph, chartData);
        rangePlotGlyph.setSeriesWidth(this.seriesWidth);
    }

    public void createAxisGlyph(RangePlotGlyph rangePlotGlyph, ChartData chartData) {
        RangePlotGlyph rangePlotGlyph2 = rangePlotGlyph;
        RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph(this.valueAxis);
        rangePlotGlyph2.setRangeAxisGlyph(rangeAxisGlyph);
        rangeAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxValueFromData(chartData));
        rangeAxisGlyph.setLeftColor(this.minToAverageColor);
        rangeAxisGlyph.setRightColor(this.averageToMaxColor);
    }

    private void createDataSeriesGlyph(RangePlotGlyph rangePlotGlyph) {
        LineGlyph lineGlyph = new LineGlyph();
        lineGlyph.setLineColor(this.middleLine2DColor);
        lineGlyph.setLineStyle(this.middlLineStyle);
        rangePlotGlyph.setMiddleLineGlyph(lineGlyph);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("ValueAxis".equals(string2) && (string = xMLableReader.getAttr("class")) != null && string.endsWith(".ValueAxis")) {
                this.valueAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
            }
            if ("MiddleLine".equals(string2)) {
                string = xMLableReader.getAttr("color");
                if (string != null) {
                    this.setMiddleLine2DColor(new Color(Integer.parseInt(string), true));
                }
                if ((string = xMLableReader.getAttr("style")) != null) {
                    this.setMiddlLineStyle(Integer.valueOf(string));
                }
            }
            if ("MinColor".equals(string2) && (string = xMLableReader.getAttr("color")) != null) {
                this.setMinToAverageColor(new Color(Integer.parseInt(string), true));
            }
            if ("MaxColor".equals(string2) && (string = xMLableReader.getAttr("color")) != null) {
                this.setAverageToMaxColor(new Color(Integer.parseInt(string), true));
            }
            if ("SeriesWidth".equals(string2) && (string = xMLableReader.getAttr("value")) != null) {
                this.setSeriesWidth(Double.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("MiddleLine").attr("color", this.getMiddleLine2DColor().getRGB()).attr("style", this.getMiddlLineStyle()).end();
        xMLPrintWriter.startTAG("MinColor").attr("color", this.getMinToAverageColor().getRGB()).end();
        xMLPrintWriter.startTAG("MaxColor").attr("color", this.getAverageToMaxColor().getRGB()).end();
        xMLPrintWriter.startTAG("SeriesWidth").attr("value", this.getSeriesWidth()).end();
        if (this.valueAxis != null) {
            this.valueAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        RangePlot rangePlot = (RangePlot)super.clone();
        if (this.valueAxis != null) {
            rangePlot.valueAxis = (ValueAxis)this.valueAxis.clone();
        }
        return rangePlot;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangePlot)) {
            return false;
        }
        RangePlot rangePlot = (RangePlot)object;
        if (!super.equals(rangePlot)) {
            return false;
        }
        if (!Equals.equals(rangePlot.getAverageToMaxColor(), this.getAverageToMaxColor())) {
            return false;
        }
        if (!Equals.equals(rangePlot.getMinToAverageColor(), this.getMinToAverageColor())) {
            return false;
        }
        if (!Equals.equals(rangePlot.getMiddleLine2DColor(), this.getMiddleLine2DColor())) {
            return false;
        }
        if (rangePlot.getMiddlLineStyle() != this.getMiddlLineStyle()) {
            return false;
        }
        if (rangePlot.getSeriesWidth() != this.getSeriesWidth()) {
            return false;
        }
        return Equals.equals(rangePlot.getValueAxis(), this.getValueAxis());
    }
}

