/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.XMLable;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.DataSeriesCondition;
import com.fr.chart.axis.SeriesAttrBackground;
import com.fr.chart.axis.SeriesAttrColor;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.axis.SeriesAttrMarkerType;
import com.fr.chart.axis.SeriesAttrTrendLine;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.plot.SeriesAttr;
import com.fr.report.io.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SeriesCollection
implements XMLable {
    private static final long serialVersionUID = 417500173279450632L;
    public static final String XML_TAG = "NewSeriesCollection";
    private Map seriesAttrMap = new HashMap();
    private SeriesAttr defaultSeriesAttr = new SeriesAttr();

    public void setSeriesAttrMap(Map map) {
        this.seriesAttrMap = map;
    }

    public Map getSeriesAttrMap() {
        return this.seriesAttrMap;
    }

    public void putSeriesAttr(int n, SeriesAttr seriesAttr) {
        this.getSeriesAttrMap().put(new Integer(n), seriesAttr);
    }

    public SeriesAttr getSeriesAttr(int n) {
        if (this.getSeriesAttrMap().containsKey(new Integer(n))) {
            return (SeriesAttr)this.getSeriesAttrMap().get(new Integer(n));
        }
        return this.defaultSeriesAttr;
    }

    public SeriesAttr getDefaultSeriesAttr() {
        return this.defaultSeriesAttr;
    }

    public void setDefaultSeriesAttr(SeriesAttr seriesAttr) {
        this.defaultSeriesAttr = seriesAttr;
    }

    public DataSeriesCondition getSeriesCondition(DataSeriesCondition dataSeriesCondition, int n) {
        DataSeriesCondition dataSeriesCondition2 = this.getSeriesAttr(n).isContains(dataSeriesCondition);
        if (dataSeriesCondition2 == null && (dataSeriesCondition2 = this.getDefaultSeriesAttr().isContains(dataSeriesCondition)) == null) {
            if (dataSeriesCondition instanceof SeriesAttrColor) {
                dataSeriesCondition2 = new SeriesAttrColor(ChartCoreConstants.CHART_COLOR_ARRAY[n]);
            } else if (dataSeriesCondition instanceof SeriesAttrBackground) {
                ColorBackground colorBackground = ColorBackground.getInstance(ChartCoreConstants.CHART_COLOR_ARRAY[n]);
                dataSeriesCondition2 = new SeriesAttrBackground(colorBackground);
            } else if (dataSeriesCondition instanceof SeriesAttrLine) {
                dataSeriesCondition2 = new SeriesAttrLine(ChartCoreConstants.CHART_COLOR_ARRAY[n], 1);
            } else if (dataSeriesCondition instanceof SeriesAttrMarkerType) {
                dataSeriesCondition2 = new SeriesAttrMarkerType(n);
            } else if (dataSeriesCondition instanceof SeriesAttrTrendLine) {
                dataSeriesCondition2 = null;
            } else {
                return dataSeriesCondition;
            }
        }
        return dataSeriesCondition2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("SeriesAttr")) {
                this.defaultSeriesAttr = (SeriesAttr)ReportXMLUtils.readXMLable(xMLableReader);
            } else if (string.equals("SeriesAttrMap")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Entry".equals(xMLableReader.getTagName())) {
                            int n = -1;
                            String string = xMLableReader.getAttr("index");
                            if (string != null) {
                                n = Integer.parseInt(string);
                            }
                            if (n != -1) {
                                xMLableReader.readXMLObject(new XMLObject(this, new Integer(n)){
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void readXML(XMLableReader xMLableReader) {
                                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("SeriesAttr")) {
                                            SeriesAttr seriesAttr = (SeriesAttr)ReportXMLUtils.readXMLable(xMLableReader);
                                            SeriesCollection.access$100(1.access$000(this.this$1)).put(this.obj, seriesAttr);
                                        }
                                    }
                                });
                            }
                        }
                    }

                    static /* synthetic */ SeriesCollection access$000(1 var0) {
                        return var0.SeriesCollection.this;
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.defaultSeriesAttr != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.defaultSeriesAttr, "SeriesAttr");
        }
        if (this.seriesAttrMap != null && this.seriesAttrMap.size() > 0) {
            xMLPrintWriter.startTAG("SeriesAttrMap");
            Iterator iterator = this.seriesAttrMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n = (Integer)entry.getKey();
                SeriesAttr seriesAttr = (SeriesAttr)entry.getValue();
                xMLPrintWriter.startTAG("Entry").attr("index", n);
                ReportXMLUtils.writeXMLable(xMLPrintWriter, seriesAttr, "SeriesAttr");
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        SeriesCollection seriesCollection = (SeriesCollection)super.clone();
        if (this.defaultSeriesAttr != null) {
            seriesCollection.defaultSeriesAttr = (SeriesAttr)this.defaultSeriesAttr.clone();
        }
        if (this.getSeriesAttrMap() != null) {
            seriesCollection.setSeriesAttrMap(new HashMap());
            Iterator iterator = this.getSeriesAttrMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                seriesCollection.getSeriesAttrMap().put(entry.getKey(), entry.getValue());
            }
        }
        return seriesCollection;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SeriesCollection)) {
            return false;
        }
        SeriesCollection seriesCollection = (SeriesCollection)object;
        if (!Equals.equals(seriesCollection.defaultSeriesAttr, this.defaultSeriesAttr)) {
            return false;
        }
        if (seriesCollection.seriesAttrMap.size() != this.seriesAttrMap.size()) {
            return false;
        }
        for (int i = 0; i < seriesCollection.seriesAttrMap.size(); ++i) {
            if (Equals.equals(seriesCollection.getSeriesAttr(i), this.getSeriesAttr(i))) continue;
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrMap != null && this.seriesAttrMap.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            Set set = this.seriesAttrMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("key", entry.getKey());
                jSONObject2.put("value", ((SeriesAttr)entry.getValue()).toJSONObject());
                arrayList.add(jSONObject2);
            }
            jSONObject.put("seriesAttrMap", arrayList.toArray());
        }
        if (this.defaultSeriesAttr != null) {
            jSONObject.put("seriesAttrType", this.defaultSeriesAttr.getSeriesAttrType());
            jSONObject.put("defaultSeriesAttr", this.defaultSeriesAttr.toJSONObject());
        }
        return jSONObject;
    }

    static /* synthetic */ Map access$100(SeriesCollection seriesCollection) {
        return seriesCollection.seriesAttrMap;
    }
}

