/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.CategoryAxis;
import com.fr.chart.axis.TextAttr;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.DateAxisGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.StockPlotGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.marker.DowJonesMarker;
import com.fr.chart.marker.Marker;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Color;
import java.awt.Insets;

public class StockPlot
extends Plot {
    private static final long serialVersionUID = 1L;
    public static final int HIGH_LOW_CLOSE = 0;
    public static final int OPEN_HIGH_LOW_CLOSE = 1;
    public static final int VOLUME_HIGH_LOW_CLOSE = 2;
    public static final int VOLUME_OPEN_HIGH_LOW_CLOSE = 3;
    private int subType = 0;
    private CategoryAxis categoryAxis = new CategoryAxis();
    private ValueAxis volumeAxis = new ValueAxis();
    private ValueAxis priceAxis = new ValueAxis();
    private int closeLineStyle = 0;
    private Color closeLineColor = Color.black;
    private Marker closeMarker = new DowJonesMarker();
    private int highLowLineStyle = 1;
    private Color highLowLineColor = Color.gray;
    private int upBarBorderLineStyle = 1;
    private Color upBarBorderLineColor = Color.red;
    private Background upBarBackground = ColorBackground.getInstance(Color.white);
    private int downBarBorderLineStyle = 1;
    private Color downBarBorderLineColor = Color.green;
    private Background downBarBackground = ColorBackground.getInstance(Color.white);
    private boolean bgStagger = false;
    private Color bgColor = Color.white;

    public StockPlot() {
        this.categoryAxis.setPosition(3);
        this.priceAxis.setPosition(2);
        this.volumeAxis.setPosition(4);
    }

    public StockPlot(int n) {
        this.subType = n;
        this.categoryAxis.setPosition(3);
        this.priceAxis.setPosition(2);
        this.volumeAxis.setPosition(4);
    }

    public Insets createOuterIntsets() {
        return new Insets(10, 20, 20, 20);
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && ((StockPlot)plot).getSubType() == this.getSubType();
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int n) {
        this.subType = n;
    }

    public CategoryAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    public void setCategoryAxis(CategoryAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
    }

    public ValueAxis getVolumeAxis() {
        return this.volumeAxis;
    }

    public void setVolumeAxis(ValueAxis valueAxis) {
        this.volumeAxis = valueAxis;
    }

    public ValueAxis getPriceAxis() {
        return this.priceAxis;
    }

    public void setPriceAxis(ValueAxis valueAxis) {
        this.priceAxis = valueAxis;
    }

    public int getHighLowLineStyle() {
        return this.highLowLineStyle;
    }

    public void setHighLowLineStyle(int n) {
        this.highLowLineStyle = n;
    }

    public Color getHighLowLineColor() {
        return this.highLowLineColor;
    }

    public void setHighLowLineColor(Color color) {
        this.highLowLineColor = color;
    }

    public int getCloseLineStyle() {
        return this.closeLineStyle;
    }

    public void setCloseLineStyle(int n) {
        this.closeLineStyle = n;
    }

    public Color getCloseLineColor() {
        return this.closeLineColor;
    }

    public void setCloseLineColor(Color color) {
        this.closeLineColor = color;
    }

    public Marker getCloseMarker() {
        return this.closeMarker;
    }

    public void setCloseMarker(Marker marker) {
        this.closeMarker = marker;
    }

    public int getUpBarBorderLineStyle() {
        return this.upBarBorderLineStyle;
    }

    public void setUpBarBorderLineStyle(int n) {
        this.upBarBorderLineStyle = n;
    }

    public Color getUpBarBorderLineColor() {
        return this.upBarBorderLineColor;
    }

    public void setUpBarBorderLineColor(Color color) {
        this.upBarBorderLineColor = color;
    }

    public Background getUpBarBackground() {
        return this.upBarBackground;
    }

    public void setUpBarBackground(Background background) {
        this.upBarBackground = background;
    }

    public int getDownBarBorderLineStyle() {
        return this.downBarBorderLineStyle;
    }

    public void setDownBarBorderLineStyle(int n) {
        this.downBarBorderLineStyle = n;
    }

    public Color getDownBarBorderLineColor() {
        return this.downBarBorderLineColor;
    }

    public void setDownBarBorderLineColor(Color color) {
        this.downBarBorderLineColor = color;
    }

    public Background getDownBarBackground() {
        return this.downBarBackground;
    }

    public void setDownBarBackground(Background background) {
        this.downBarBackground = background;
    }

    private double getMaxVolumeValue(ChartData chartData) {
        if (this.subType == 2 || this.subType == 3) {
            double d = 0.0;
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                d = chartData.getValueAt(0, i).doubleValue() > d ? chartData.getValueAt(0, i).doubleValue() : d;
            }
            return d;
        }
        return 0.0;
    }

    private double getMaxPriceValue(ChartData chartData) {
        if (this.subType == 2 || this.subType == 3) {
            double d = 0.0;
            for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
                for (int j = 1; j < chartData.getSeriesCount(); ++j) {
                    d = chartData.getValueAt(j, i).doubleValue() > d ? chartData.getValueAt(j, i).doubleValue() : d;
                }
            }
            return d;
        }
        return this.getMaxValueFromData(chartData);
    }

    public void setBgStagger(boolean bl) {
        this.bgStagger = bl;
    }

    public boolean getBgStagger() {
        return this.bgStagger;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        StockPlotGlyph stockPlotGlyph = new StockPlotGlyph();
        this.install4PlotGlyph(stockPlotGlyph, chartData);
        this.createAxisGlyph(stockPlotGlyph, chartData);
        this.createErrTextGlyph(stockPlotGlyph);
        return stockPlotGlyph;
    }

    public void install4PlotGlyph(StockPlotGlyph stockPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(stockPlotGlyph, chartData);
        stockPlotGlyph.setSubType(this.subType);
        stockPlotGlyph.setHighLowLineColor(this.highLowLineColor);
        stockPlotGlyph.setHighLowLineStyle(this.highLowLineStyle);
        stockPlotGlyph.setDownBarBackground(this.downBarBackground);
        stockPlotGlyph.setDownBarBorderLineColor(this.downBarBorderLineColor);
        stockPlotGlyph.setDownBarBorderLineStyle(this.downBarBorderLineStyle);
        stockPlotGlyph.setUpBarBackground(this.upBarBackground);
        stockPlotGlyph.setUpBarBorderLineColor(this.upBarBorderLineColor);
        stockPlotGlyph.setUpBarBorderLineStyle(this.upBarBorderLineStyle);
    }

    private void createAxisGlyph(StockPlotGlyph stockPlotGlyph, ChartData chartData) {
        CategoryAxisGlyph categoryAxisGlyph;
        if (this.checkDate(chartData) && this.categoryAxis.isDateAxis()) {
            categoryAxisGlyph = new DateAxisGlyph(this.categoryAxis);
            double[] dArray = this.getDateRange(chartData);
            ((DateAxisGlyph)categoryAxisGlyph).initMinMaxValue(dArray[0], dArray[1]);
        } else {
            categoryAxisGlyph = new CategoryAxisGlyph(this.categoryAxis);
        }
        stockPlotGlyph.setCategoryAxisGlyph(categoryAxisGlyph);
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            categoryAxisGlyph.addCategoryLabel(chartData.getCategoryLabel(i) == null ? "" : chartData.getCategoryLabel(i));
        }
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph(this.priceAxis);
        valueAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxPriceValue(chartData));
        stockPlotGlyph.setPriceAxisGlyph(valueAxisGlyph);
        if (this.subType == 2 || this.subType == 3) {
            ValueAxisGlyph valueAxisGlyph2 = new ValueAxisGlyph(this.volumeAxis);
            valueAxisGlyph2.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxVolumeValue(chartData));
            stockPlotGlyph.setVolumeAxisGlyph(valueAxisGlyph2);
        }
        if (this.bgStagger) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground();
            intervalColorBackground.setColor(this.bgColor);
            intervalColorBackground.setPosition(this.priceAxis.getPosition());
            stockPlotGlyph.getInfo().setBackground(intervalColorBackground);
        }
        stockPlotGlyph.axisExtends(categoryAxisGlyph);
    }

    private void createErrTextGlyph(StockPlotGlyph stockPlotGlyph) {
        int n = stockPlotGlyph.getSeriesSize();
        if (!(n == 3 && this.getSubType() == 0 || n == 4 && (this.getSubType() == 1 || this.getSubType() == 2) || n == 5 && this.getSubType() == 3)) {
            TextGlyph textGlyph = new TextGlyph(this.getDataErrorText(this.getSubType()), new TextAttr());
            stockPlotGlyph.setErrTextGlyph(textGlyph);
        }
    }

    private String getDataErrorText(int n) {
        StringBuffer stringBuffer = new StringBuffer("Error! To create this stock chart, arrange your chart data in this order: ");
        if (n == 0) {
            stringBuffer.append(" high price, low price, closing price.");
        } else if (n == 1) {
            stringBuffer.append(" opening price,");
        } else if (n == 2) {
            stringBuffer.append(" volume traded,");
        } else if (n == 3) {
            stringBuffer.append(" volume traded, opening price,");
        }
        return stringBuffer.toString();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Type".equals(string)) {
                String string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    this.subType = Integer.parseInt(string2);
                }
            } else if ("CategoryAxis".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("CategoryAxis")) {
                            StockPlot.this.categoryAxis = (CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis());
                        }
                    }
                });
            } else if ("PriceAxis".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("ValueAxis")) {
                            StockPlot.this.priceAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
                        }
                    }
                });
            } else if ("VolumeAxis".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("ValueAxis")) {
                            StockPlot.this.volumeAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
                        }
                    }
                });
            } else if ("Close".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            String string = xMLableReader.getAttr("style");
                            if (string != null) {
                                StockPlot.this.closeLineStyle = Integer.parseInt(string);
                            }
                            if ((string = xMLableReader.getAttr("color")) != null) {
                                StockPlot.this.closeLineColor = new Color(Integer.parseInt(string), true);
                            }
                        } else if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Marker")) {
                            StockPlot.this.closeMarker = (Marker)ReportXMLUtils.readXMLable(xMLableReader);
                        }
                    }
                });
            } else if ("HighLow".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            String string = xMLableReader.getAttr("style");
                            if (string != null) {
                                StockPlot.this.highLowLineStyle = Integer.parseInt(string);
                            }
                            if ((string = xMLableReader.getAttr("color")) != null) {
                                StockPlot.this.highLowLineColor = new Color(Integer.parseInt(string), true);
                            }
                        }
                    }
                });
            } else if ("UpBar".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            String string = xMLableReader.getAttr("style");
                            if (string != null) {
                                StockPlot.this.upBarBorderLineStyle = Integer.parseInt(string);
                            }
                            if ((string = xMLableReader.getAttr("color")) != null) {
                                StockPlot.this.upBarBorderLineColor = new Color(Integer.parseInt(string), true);
                            }
                        } else if (xMLableReader.isChildNode() && "Background".equals(xMLableReader.getTagName())) {
                            StockPlot.this.upBarBackground = BaseXMLUtils.readBackground(xMLableReader);
                        }
                    }
                });
            } else if ("DownBar".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            String string = xMLableReader.getAttr("style");
                            if (string != null) {
                                StockPlot.this.downBarBorderLineStyle = Integer.parseInt(string);
                            }
                            if ((string = xMLableReader.getAttr("color")) != null) {
                                StockPlot.this.downBarBorderLineColor = new Color(Integer.parseInt(string), true);
                            }
                        } else if (xMLableReader.isChildNode() && "Background".equals(xMLableReader.getTagName())) {
                            StockPlot.this.downBarBackground = BaseXMLUtils.readBackground(xMLableReader);
                        }
                    }
                });
            } else if ("BG".equals(string)) {
                String string3 = xMLableReader.getAttr("bgStagger");
                if (string3 != null) {
                    this.setBgStagger(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("color")) != null) {
                    this.setBgColor(new Color(Integer.parseInt(string3), true));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Type").attr("value", this.subType).end();
        if (this.categoryAxis != null) {
            xMLPrintWriter.startTAG("CategoryAxis");
            this.categoryAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.priceAxis != null) {
            xMLPrintWriter.startTAG("PriceAxis");
            this.priceAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.volumeAxis != null) {
            xMLPrintWriter.startTAG("VolumeAxis");
            this.volumeAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("Close").attr("style", this.closeLineStyle).attr("color", this.closeLineColor.getRGB());
        ReportXMLUtils.writeXMLable(xMLPrintWriter, this.closeMarker, "Marker");
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("HighLow").attr("style", this.highLowLineStyle).attr("color", this.highLowLineColor.getRGB()).end();
        xMLPrintWriter.startTAG("UpBar").attr("style", this.upBarBorderLineStyle).attr("color", this.upBarBorderLineColor.getRGB());
        BaseXMLUtils.writeBackground(xMLPrintWriter, this.upBarBackground);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("DownBar").attr("style", this.downBarBorderLineStyle).attr("color", this.downBarBorderLineColor.getRGB());
        BaseXMLUtils.writeBackground(xMLPrintWriter, this.downBarBackground);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("BG").attr("bgStagger", this.bgStagger).attr("color", this.bgColor.getRGB()).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StockPlot)) {
            return false;
        }
        StockPlot stockPlot = (StockPlot)object;
        if (!super.equals(stockPlot)) {
            return false;
        }
        if (stockPlot.getSubType() != this.getSubType()) {
            return false;
        }
        if (!Equals.equals(stockPlot.getCategoryAxis(), this.getCategoryAxis())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getVolumeAxis(), this.getVolumeAxis())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getPriceAxis(), this.getPriceAxis())) {
            return false;
        }
        if (stockPlot.getCloseLineStyle() != this.getCloseLineStyle()) {
            return false;
        }
        if (!Equals.equals(stockPlot.getCloseLineColor(), this.getCloseLineColor())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getCloseMarker(), this.getCloseMarker())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getHighLowLineColor(), this.getHighLowLineColor())) {
            return false;
        }
        if (stockPlot.getHighLowLineStyle() != this.getHighLowLineStyle()) {
            return false;
        }
        if (!Equals.equals(stockPlot.getUpBarBackground(), this.getUpBarBackground())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getUpBarBorderLineColor(), this.getUpBarBorderLineColor())) {
            return false;
        }
        if (stockPlot.getUpBarBorderLineStyle() != this.getUpBarBorderLineStyle()) {
            return false;
        }
        if (stockPlot.getDownBarBorderLineStyle() != this.getDownBarBorderLineStyle()) {
            return false;
        }
        if (!Equals.equals(stockPlot.getDownBarBackground(), this.getDownBarBackground())) {
            return false;
        }
        if (!Equals.equals(stockPlot.getDownBarBorderLineColor(), this.getDownBarBorderLineColor())) {
            return false;
        }
        if (stockPlot.getBgStagger() != this.getBgStagger()) {
            return false;
        }
        return Equals.equals(stockPlot.getBgColor(), this.getBgColor());
    }

    public Object clone() throws CloneNotSupportedException {
        StockPlot stockPlot = (StockPlot)super.clone();
        if (this.categoryAxis != null) {
            stockPlot.categoryAxis = (CategoryAxis)this.categoryAxis.clone();
        }
        if (this.closeMarker != null) {
            stockPlot.closeMarker = (Marker)this.closeMarker.clone();
        }
        if (this.downBarBackground != null) {
            stockPlot.downBarBackground = (Background)this.downBarBackground.clone();
        }
        if (this.priceAxis != null) {
            stockPlot.priceAxis = (ValueAxis)this.priceAxis.clone();
        }
        if (this.upBarBackground != null) {
            stockPlot.upBarBackground = (Background)this.upBarBackground.clone();
        }
        if (this.volumeAxis != null) {
            stockPlot.volumeAxis = (ValueAxis)this.volumeAxis.clone();
        }
        return stockPlot;
    }
}

