/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.plot;

import com.fr.base.background.IntervalColorBackground;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.axis.Axis;
import com.fr.chart.axis.ValueAxis;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.core.glyph.XYScatterPlotGlyph;
import com.fr.chart.legend.LineMarkerIcon;
import com.fr.chart.plot.Plot;
import com.fr.data.ChartData;
import com.fr.data.impl.ReportChartData;
import com.fr.util.Utils;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;

public class XYScatterPlot
extends Plot {
    private static final long serialVersionUID = 5947464168434538499L;
    private ValueAxis xAxis;
    private ValueAxis yAxis;
    private boolean showLine = true;
    private boolean showMarker = true;
    private boolean bgStagger = false;
    private Color bgColor = Color.white;

    public XYScatterPlot() {
        this.xAxis = new ValueAxis();
        this.xAxis.setPosition(3);
        this.yAxis = new ValueAxis();
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        XYScatterPlotGlyph xYScatterPlotGlyph = new XYScatterPlotGlyph();
        chartData = this.create65Data4New(chartData);
        this.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        this.createAxisGlyph(xYScatterPlotGlyph, chartData);
        return xYScatterPlotGlyph;
    }

    public void install4PlotGlyph(XYScatterPlotGlyph xYScatterPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        xYScatterPlotGlyph.setShowLine(this.showLine);
        xYScatterPlotGlyph.setShowMarker(this.showMarker);
    }

    private void createAxisGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        XYScatterPlotGlyph xYScatterPlotGlyph = (XYScatterPlotGlyph)plotGlyph;
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph(this.xAxis);
        xYScatterPlotGlyph.setXAxisGlyph(valueAxisGlyph);
        this.initXAxisGlyph(valueAxisGlyph, chartData);
        xYScatterPlotGlyph.axisExtends(valueAxisGlyph);
        ValueAxisGlyph valueAxisGlyph2 = new ValueAxisGlyph(this.yAxis);
        xYScatterPlotGlyph.setYAxisGlyph(valueAxisGlyph2);
        valueAxisGlyph2.initMinMaxValue(this.getMinValueFromData(chartData), this.getMaxValueFromData(chartData));
        if (this.bgStagger) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground();
            intervalColorBackground.setColor(this.bgColor);
            intervalColorBackground.setPosition(this.yAxis.getPosition());
            xYScatterPlotGlyph.getInfo().setBackground(intervalColorBackground);
        }
    }

    private void initXAxisGlyph(ValueAxisGlyph valueAxisGlyph, ChartData chartData) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            String string = "";
            if (chartData.getCategoryLabel(i) != null) {
                string = chartData.getCategoryLabel(i).toString();
            }
            double d3 = 0.0;
            Number number = Utils.string2Number(string);
            if (number != null) {
                d3 = number.doubleValue();
            }
            if (i == 0) {
                d = d3;
                d2 = d3;
                continue;
            }
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        double d4 = Axis.calculateIncrement(d, d2);
        valueAxisGlyph.initMinMaxValue(d - d4, d2 + d4);
    }

    protected LineMarkerIcon getLineMarkerIconByIndex(int n) {
        return this.getLineMarkerIconByIndex4Line(n);
    }

    protected boolean showLegendLine() {
        return this.showLine;
    }

    protected boolean showLegendMarker() {
        return this.showMarker;
    }

    public void setYAxis(ValueAxis valueAxis) {
        this.yAxis = valueAxis;
    }

    public ValueAxis getYAxis() {
        return this.yAxis;
    }

    public ValueAxis getXAxis() {
        return this.xAxis;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public boolean isShowMarker() {
        return this.showMarker;
    }

    public void setShowMarker(boolean bl) {
        this.showMarker = bl;
    }

    public void setBgStagger(boolean bl) {
        this.bgStagger = bl;
    }

    public boolean getBgStagger() {
        return this.bgStagger;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public ChartData create65Data4New(ChartData chartData) {
        Serializable serializable;
        int n = chartData.getSeriesCount();
        int n2 = chartData.getCategoryLabelCount();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            Object object = chartData.getCategoryLabel(i);
            serializable = Utils.objectToNumber(object, true);
            if (serializable != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n3;
            Object[] objectArray;
            Object[] objectArray2 = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray2[i] = n == 1 ? (Number)new Integer(i + 1) : (Number)chartData.getValueAt(0, i);
            }
            if (n == 1) {
                objectArray = new Object[]{chartData.getSeriesLabel(0)};
            } else {
                objectArray = new Object[n - 1];
                for (int i = 1; i < n; ++i) {
                    objectArray[i - 1] = chartData.getSeriesLabel(i);
                }
            }
            serializable = new ArrayList();
            ArrayList<Number> arrayList = new ArrayList<Number>();
            int n4 = n3 = n == 1 ? 0 : 1;
            while (n3 < n) {
                arrayList = new ArrayList();
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(chartData.getValueAt(n3, i));
                }
                serializable.add(arrayList.toArray());
                ++n3;
            }
            Object[][] objectArray3 = (Object[][])serializable.toArray((T[])new Object[objectArray.length][]);
            chartData = new ReportChartData(objectArray2, objectArray, objectArray3);
        }
        return chartData;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && ((XYScatterPlot)plot).showLine == this.showLine && ((XYScatterPlot)plot).showMarker == this.showMarker;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("XYScatterAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("showLine");
                if (string2 != null) {
                    this.setShowLine(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("showMarker")) != null) {
                    this.setShowMarker(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("bgStagger")) != null) {
                    this.setBgStagger(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("bgColor")) != null) {
                    this.setBgColor(new Color(Integer.parseInt(string2), true));
                }
            } else if ("XAxis".equals(string)) {
                this.xAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
            } else if ("YAxis".equals(string)) {
                this.yAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("XYScatterAttr").attr("showLine", this.showLine).attr("showMarker", this.showMarker).attr("bgStagger", this.bgStagger);
        if (this.bgColor != null) {
            xMLPrintWriter.attr("bgColor", this.bgColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.xAxis != null) {
            xMLPrintWriter.startTAG("XAxis");
            this.xAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.yAxis != null) {
            xMLPrintWriter.startTAG("YAxis");
            this.yAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XYScatterPlot)) {
            return false;
        }
        XYScatterPlot xYScatterPlot = (XYScatterPlot)object;
        if (!super.equals(xYScatterPlot)) {
            return false;
        }
        if (xYScatterPlot.getBgStagger() != this.getBgStagger()) {
            return false;
        }
        if (xYScatterPlot.isShowLine() != this.isShowLine()) {
            return false;
        }
        if (xYScatterPlot.isShowMarker() != this.isShowMarker()) {
            return false;
        }
        if (!Equals.equals(xYScatterPlot.getXAxis(), this.getXAxis())) {
            return false;
        }
        if (!Equals.equals(xYScatterPlot.getYAxis(), this.getYAxis())) {
            return false;
        }
        return Equals.equals(xYScatterPlot.getBgColor(), this.getBgColor());
    }
}

