/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.shape3d.FoldLine3D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Area3D
extends FoldLine3D {
    private static final long serialVersionUID = 4316089814981343932L;
    public static final String XML_TAG = "Area3D";

    public Area3D() {
    }

    public Area3D(float f, float f2) {
        super(f, f2);
    }

    public Area3D(double d, double d2) {
        super(d, d2);
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesColor();
            this.getColorInfo().setSeriesColor(color.brighter());
        }
        this.getColorInfo().paint(graphics, this.getFrontArea());
        if (color != null) {
            this.getColorInfo().setSeriesColor(color);
        }
    }

    private GeneralPath getFrontArea() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getPoint_list().size(); ++i) {
            Point2D point2D = this.getProjection().projectee(((Point2D)this.getPoint_list().get(i)).getX(), ((Point2D)this.getPoint_list().get(i)).getY(), this.getZ());
            if (i == 0) {
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                continue;
            }
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    public Shape getShape() {
        GeneralPath generalPath = this.getFrontArea();
        generalPath.append(super.getShape(), false);
        return generalPath;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Area3D)) {
            return false;
        }
        Area3D area3D = (Area3D)object;
        return super.equals(area3D);
    }

    public JSONObject toJSONOjbect() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        return jSONObject;
    }
}

