/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.GeneralGlyph;
import com.fr.chart.math.Object3D;
import com.fr.chart.math.Projection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;

public class Cubic
extends GeneralGlyph
implements Object3D {
    private static final long serialVersionUID = 7339367968061606971L;
    public static final String XML_TAG = "Cubic";
    public static final byte TOP = 0;
    public static final byte BOTTOM = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public static final byte FRONT = 4;
    public static final byte BACK = 5;
    private float x = 0.0f;
    private float y = 0.0f;
    private float z = 0.0f;
    private float width;
    private float height;
    private float deep = 60.0f;
    private byte[] covers = new byte[]{0, 3, 4};
    private Projection projection = new Projection();
    private Point2D[] points = new Point2D[8];

    public Cubic() {
    }

    public Cubic(double d, double d2, double d3, double d4) {
        this.x = (float)d;
        this.y = (float)d2;
        this.width = (float)d3;
        this.height = (float)d4;
    }

    public Cubic(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f4, f5);
        this.z = f3;
        this.deep = f6;
    }

    public Cubic(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
        this.width = (float)d4;
        this.height = (float)d5;
        this.deep = (float)d6;
    }

    public void setCovers(byte[] byArray) {
        this.covers = byArray;
    }

    public void setCubic(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
        this.width = (float)d4;
        this.height = (float)d5;
        this.deep = (float)d6;
    }

    public double getDeep() {
        return this.deep;
    }

    public void setDeep(double d) {
        this.deep = (float)d;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    protected Background getBrighterBackground() {
        Background background = this.getBackground();
        if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            background = ColorBackground.getInstance(((ColorBackground)background).getColor().brighter());
        }
        return background;
    }

    protected Background getDarkerBackground() {
        Background background = this.getBackground();
        if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            background = ColorBackground.getInstance(((ColorBackground)background).getColor().darker());
        }
        return background;
    }

    public void draw(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        this.init();
        if (this.getBackground() != null) {
            Background background = this.getBrighterBackground();
            Background background2 = this.getDarkerBackground();
            if (this.covers != null) {
                block16: for (int i = 0; i < this.covers.length; ++i) {
                    switch (this.covers[i]) {
                        case 0: {
                            background.paint(graphics2D, this.top());
                            continue block16;
                        }
                        case 1: {
                            background.paint(graphics2D, this.bottom());
                            continue block16;
                        }
                        case 2: {
                            background2.paint(graphics2D, this.left());
                            continue block16;
                        }
                        case 3: {
                            background2.paint(graphics2D, this.right());
                            continue block16;
                        }
                        case 4: {
                            this.getBackground().paint(graphics2D, this.front());
                            continue block16;
                        }
                        case 5: {
                            this.getBackground().paint(graphics2D, this.back());
                            continue block16;
                        }
                    }
                }
            }
        }
        if ((n = this.getBorderStyle()) != 0) {
            graphics2D.setPaint(this.getBorderColor());
            if (this.covers != null) {
                block17: for (int i = 0; i < this.covers.length; ++i) {
                    switch (this.covers[i]) {
                        case 0: {
                            GraphHelper.draw(graphics2D, this.top(), n);
                            continue block17;
                        }
                        case 1: {
                            GraphHelper.draw(graphics2D, this.bottom(), n);
                            continue block17;
                        }
                        case 2: {
                            GraphHelper.draw(graphics2D, this.left(), n);
                            continue block17;
                        }
                        case 3: {
                            GraphHelper.draw(graphics2D, this.right(), n);
                            continue block17;
                        }
                        case 4: {
                            GraphHelper.draw(graphics2D, this.front(), n);
                            continue block17;
                        }
                        case 5: {
                            GraphHelper.draw(graphics2D, this.back(), n);
                            continue block17;
                        }
                    }
                }
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    private void init() {
        this.points[0] = this.projection.projectee(this.x, this.y, this.z);
        this.points[1] = this.projection.projectee(this.x + this.width, this.y, this.z);
        this.points[2] = this.projection.projectee(this.x, this.y + this.height, this.z);
        this.points[3] = this.projection.projectee(this.x + this.width, this.y + this.height, this.z);
        this.points[4] = this.projection.projectee(this.x, this.y, this.z - this.deep);
        this.points[5] = this.projection.projectee(this.x + this.width, this.y, this.z - this.deep);
        this.points[6] = this.projection.projectee(this.x, this.y + this.height, this.z - this.deep);
        this.points[7] = this.projection.projectee(this.x + this.width, this.y + this.height, this.z - this.deep);
    }

    private GeneralPath top() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.lineTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath bottom() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath right() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath left() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.lineTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath front() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath back() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.closePath();
        return generalPath;
    }

    public void drawPoints(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawString("(" + this.x + "," + this.y + "," + 0 + ")", (int)this.points[0].getX(), (int)this.points[0].getY());
        graphics2D.drawString("(" + (this.x + this.width) + "," + this.y + "," + 0 + ")", (int)this.points[1].getX(), (int)this.points[1].getY());
        graphics2D.drawString("(" + this.x + "," + (this.y + this.height) + "," + 0 + ")", (int)this.points[2].getX(), (int)this.points[2].getY());
        graphics2D.drawString("(" + (this.x + this.width) + "," + (this.y + this.height) + "," + 0 + ")", (int)this.points[3].getX(), (int)this.points[3].getY());
        graphics2D.drawString("(" + this.x + "," + this.y + "," + -this.deep + ")", (int)this.points[4].getX(), (int)this.points[4].getY());
        graphics2D.drawString("(" + (this.x + this.width) + "," + this.y + "," + -this.deep + ")", (int)this.points[5].getX(), (int)this.points[5].getY());
        graphics2D.drawString("(" + this.x + "," + (this.y + this.height) + "," + -this.deep + ")", (int)this.points[6].getX(), (int)this.points[6].getY());
        graphics2D.drawString("(" + (this.x + this.width) + "," + (this.y + this.height) + "," + -this.deep + ")", (int)this.points[7].getX(), (int)this.points[7].getY());
        graphics2D.setPaint(paint);
    }

    public Shape getShape() {
        this.init();
        GeneralPath generalPath = new GeneralPath();
        if (this.covers != null) {
            block8: for (int i = 0; i < this.covers.length; ++i) {
                switch (this.covers[i]) {
                    case 0: {
                        generalPath.append(this.top(), false);
                        continue block8;
                    }
                    case 1: {
                        generalPath.append(this.bottom(), false);
                        continue block8;
                    }
                    case 2: {
                        generalPath.append(this.left(), false);
                        continue block8;
                    }
                    case 3: {
                        generalPath.append(this.right(), false);
                        continue block8;
                    }
                    case 4: {
                        generalPath.append(this.front(), false);
                        continue block8;
                    }
                    case 5: {
                        generalPath.append(this.back(), false);
                        continue block8;
                    }
                }
            }
        }
        return generalPath;
    }

    public Shape getOutline4Fill() {
        return this.getShape();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("x");
                if (string2 != null) {
                    this.x = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("y")) != null) {
                    this.y = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("z")) != null) {
                    this.z = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("width")) != null) {
                    this.width = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("height")) != null) {
                    this.height = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("deep")) != null) {
                    this.deep = Float.valueOf(string2).floatValue();
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if (string.equals("Covers")) {
                this.covers = BaseXMLUtils.readByteArray(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("x", this.x).attr("y", this.y).attr("z", this.z).attr("width", this.width).attr("height", this.height).attr("deep", this.deep).end();
        if (this.covers != null && this.covers.length > 0) {
            xMLPrintWriter.startTAG("Covers");
            BaseXMLUtils.writeByteArray(xMLPrintWriter, this.covers);
            xMLPrintWriter.end();
        }
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cubic)) {
            return false;
        }
        Cubic cubic = (Cubic)object;
        if (!super.equals(cubic)) {
            return false;
        }
        if (cubic.getDeep() != this.getDeep()) {
            return false;
        }
        return Equals.equals(cubic.getProjection(), this.getProjection());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("x", this.x);
        jSONObject.put("y", this.y);
        jSONObject.put("z", this.z);
        jSONObject.put("width", this.width);
        jSONObject.put("height", this.height);
        jSONObject.put("deep", this.deep);
        jSONObject.put("points", this.points);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }
}

