/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ColorInfo;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.ChartUtils;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.math.Object3D;
import com.fr.chart.math.Projection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class Cylinder
extends SoloGlyph
implements Object3D {
    private static final long serialVersionUID = 5570356712828640455L;
    public static final String XML_TAG = "Cyliner";
    private double start_y = 0.0;
    private double x;
    private double y;
    private double start = 0.0;
    private double extent = 360.0;
    private double depth = 60.0;
    private float R = 60.0f;
    private Projection projection = new Projection();
    private ColorInfo colorInfo = new ColorInfo();

    public Cylinder() {
    }

    public Cylinder(double d, double d2, double d3) {
        this.setStart_y(d);
        this.setDepth(d2);
        this.setR((float)d3);
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = this.colorInfo.getSeriesColor().darker();
        graphics2D.setColor(color);
        graphics2D.fill(this.bottom());
        for (int i = (int)this.getDepth() - 1; i > 0; --i) {
            color = this.colorPlus(color);
            graphics2D.setColor(color);
            graphics2D.draw(this.getArc2D(i));
        }
        graphics2D.setColor(this.colorInfo.getSeriesColor().brighter());
        graphics2D.fill(this.top());
        graphics2D.setPaint(paint);
    }

    private Color colorPlus(Color color) {
        return new Color(Math.max(color.getRed() + 1, 0), Math.max(color.getGreen() + 1, 0), Math.max(color.getBlue() + 1, 0));
    }

    public Arc2D bottom() {
        return this.getArc2D((int)this.getDepth());
    }

    public Area back() {
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        if (this.isInner()) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(arc2D.getPathIterator(null), true);
            generalPath.lineTo((float)arc2D2.getEndPoint().getX(), (float)arc2D2.getEndPoint().getY());
            arc2D2.setAngleStart(d3);
            arc2D2.setAngleExtent(-d2);
            generalPath.append(arc2D2.getPathIterator(null), true);
            return new Area(generalPath);
        }
        Arc2D arc2D3 = this.projection.projecteeArc(this.getStart_y(), this.getR(), 0.0, 360.0);
        Rectangle rectangle = arc2D3.getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        Point2D.Double double_2 = new Point2D.Double(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
        Point2D.Double double_3 = new Point2D.Double(double_.getMaxX(), ((RectangularShape)double_).getY());
        Arc2D arc2D4 = this.projection.projecteeArc(this.getStart_y() + (double)((int)this.getDepth()), this.getR(), 0.0, 360.0);
        Rectangle rectangle2 = arc2D4.getBounds();
        rectangle2.x = (int)((double)rectangle2.x + this.x);
        rectangle2.y = (int)((double)rectangle2.y + this.y);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(rectangle2.getX(), rectangle2.getY(), rectangle2.getWidth(), rectangle2.getHeight());
        Point2D.Double double_5 = new Point2D.Double(((RectangularShape)double_4).getX(), double_4.getMaxY());
        Point2D.Double double_6 = new Point2D.Double(double_4.getMaxX(), double_4.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((RectangularShape)double_).getX(), (float)double_.getCenterY());
        generalPath.lineTo((float)double_.getMaxX(), (float)double_.getCenterY());
        generalPath.lineTo((float)double_4.getMaxX(), (float)double_4.getCenterY());
        generalPath.lineTo((float)((RectangularShape)double_4).getX(), (float)double_4.getCenterY());
        generalPath.closePath();
        Area area = new Area(double_);
        area.add(new Area(generalPath));
        area.add(new Area(double_4));
        Area area2 = new Area(area);
        area2.subtract(new Area(double_4));
        Area area3 = null;
        double d4 = Math.toDegrees(Math.asin(-this.get_sin_theta()));
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (!(d2 > -(180.0 + 2.0 * d4))) {
                        area3 = area2;
                    }
                } else {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d3, double_2, double_3, double_5, double_6);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -(180.0 - 2.0 * d4)) {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, d, d3, double_2, double_3, double_5, double_6);
                } else {
                    Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d4, d, double_2, double_3, double_5, double_6);
                    Area area5 = Cylinder.getSideArea(arc2D, arc2D2, d3, 180.0 - d4, double_2, double_3, double_5, double_6);
                    area3 = new Area(area4);
                    area3.add(area5);
                }
            } else {
                area3 = Cylinder.getSideArea(arc2D, arc2D2, d, d4, double_2, double_3, double_5, double_6);
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (!(d2 < 180.0 + 2.0 * d4)) {
                        area3 = area2;
                    }
                } else {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, d4, d3, double_2, double_3, double_5, double_6);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0 - 2.0 * d4) {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, d3, d, double_2, double_3, double_5, double_6);
                } else {
                    Area area6 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d, double_2, double_3, double_5, double_6);
                    Area area7 = Cylinder.getSideArea(arc2D, arc2D2, d4, d3, double_2, double_3, double_5, double_6);
                    area3 = new Area(area6);
                    area3.add(area7);
                }
            } else {
                area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0, d, double_2, double_3, double_5, double_6);
            }
        }
        if (area3 == null) {
            area3 = new Area();
        } else {
            area3.intersect(area2);
        }
        return area3;
    }

    public Area front() {
        if (this.isInner()) {
            return new Area();
        }
        Rectangle rectangle = this.projection.projecteeArc(this.getStart_y(), this.getR(), 0.0, 360.0).getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        Point2D.Double double_2 = new Point2D.Double(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
        Point2D.Double double_3 = new Point2D.Double(double_.getMaxX(), ((RectangularShape)double_).getY());
        Rectangle rectangle2 = this.projection.projecteeArc(this.getStart_y() + (double)((int)this.getDepth()), this.getR(), 0.0, 360.0).getBounds();
        rectangle2.x = (int)((double)rectangle2.x + this.x);
        rectangle2.y = (int)((double)rectangle2.y + this.y);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(rectangle2.getX(), rectangle2.getY(), rectangle2.getWidth(), rectangle2.getHeight());
        Point2D.Double double_5 = new Point2D.Double(((RectangularShape)double_4).getX(), double_4.getMaxY());
        Point2D.Double double_6 = new Point2D.Double(double_4.getMaxX(), double_4.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((RectangularShape)double_).getX(), (float)double_.getCenterY());
        generalPath.lineTo((float)double_.getMaxX(), (float)double_.getCenterY());
        generalPath.lineTo((float)double_4.getMaxX(), (float)double_4.getCenterY());
        generalPath.lineTo((float)((RectangularShape)double_4).getX(), (float)double_4.getCenterY());
        generalPath.closePath();
        Area area = new Area(double_);
        area.add(new Area(generalPath));
        area.add(new Area(double_4));
        Area area2 = new Area(area);
        area2.subtract(new Area(double_));
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        Area area3 = null;
        double d4 = Math.toDegrees(Math.asin(-this.get_sin_theta()));
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -(180.0 + 2.0 * d4)) {
                        area3 = Cylinder.getSideArea(arc2D, arc2D2, d3, d, double_2, double_3, double_5, double_6);
                    } else {
                        Area area4 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d, double_2, double_3, double_5, double_6);
                        Area area5 = Cylinder.getSideArea(arc2D, arc2D2, d3, d4, double_2, double_3, double_5, double_6);
                        area3 = new Area(area4);
                        area3.add(area5);
                    }
                } else {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d, double_2, double_3, double_5, double_6);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (!(d2 > -(180.0 - 2.0 * d4))) {
                    area3 = area2;
                }
            } else {
                area3 = Cylinder.getSideArea(arc2D, arc2D2, d3, d4, double_2, double_3, double_5, double_6);
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0 + 2.0 * d4) {
                        area3 = Cylinder.getSideArea(arc2D, arc2D2, d3, d, double_2, double_3, double_5, double_6);
                    } else {
                        Area area6 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d3, double_2, double_3, double_5, double_6);
                        Area area7 = Cylinder.getSideArea(arc2D, arc2D2, d, d4, double_2, double_3, double_5, double_6);
                        area3 = new Area(area6);
                        area3.add(area7);
                    }
                } else {
                    area3 = Cylinder.getSideArea(arc2D, arc2D2, d, d4, double_2, double_3, double_5, double_6);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (!(d2 < 180.0 - 2.0 * d4)) {
                    area3 = area2;
                }
            } else {
                area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d4, d3, double_2, double_3, double_5, double_6);
            }
        }
        if (area3 == null) {
            area3 = new Area();
        } else {
            area3.intersect(area2);
        }
        return area3;
    }

    public Arc2D top() {
        return this.getArc2D(0);
    }

    public GeneralPath getStartSide() {
        Arc2D arc2D = this.top();
        Arc2D arc2D2 = this.bottom();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)arc2D2.getCenterX(), (float)arc2D2.getCenterY());
        generalPath.lineTo((float)arc2D2.getStartPoint().getX(), (float)arc2D2.getStartPoint().getY());
        generalPath.lineTo((float)arc2D.getStartPoint().getX(), (float)arc2D.getStartPoint().getY());
        generalPath.lineTo((float)arc2D.getCenterX(), (float)arc2D.getCenterY());
        generalPath.closePath();
        return generalPath;
    }

    public GeneralPath getEndSide() {
        Arc2D arc2D = this.top();
        Arc2D arc2D2 = this.bottom();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)arc2D2.getCenterX(), (float)arc2D2.getCenterY());
        generalPath.lineTo((float)arc2D2.getEndPoint().getX(), (float)arc2D2.getEndPoint().getY());
        generalPath.lineTo((float)arc2D.getEndPoint().getX(), (float)arc2D.getEndPoint().getY());
        generalPath.lineTo((float)arc2D.getCenterX(), (float)arc2D.getCenterY());
        generalPath.closePath();
        return generalPath;
    }

    private Arc2D getArc2D(int n) {
        Arc2D arc2D = this.projection.projecteeArc(this.getStart_y() + (double)n, this.getR(), this.start, this.extent);
        Rectangle rectangle = arc2D.getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        arc2D.setArc(rectangle, arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        return arc2D;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(this.getArc2D(0), false);
        generalPath.append(this.getArc2D((int)this.getDepth()), false);
        return generalPath;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public void setStart_y(double d) {
        this.start_y = d;
    }

    public double getStart_y() {
        return this.start_y;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public void setStart(double d) {
        this.start = d;
    }

    public double getStart() {
        return this.start;
    }

    public void setExtent(double d) {
        this.extent = d;
    }

    public double getExtent() {
        return this.extent;
    }

    public void setDepth(double d) {
        this.depth = d;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setR(float f) {
        this.R = f;
    }

    public float getR() {
        return this.R;
    }

    public static Point2D getArcPoint(Arc2D arc2D, double d) {
        double d2 = arc2D.getX() + (Math.cos(Math.toRadians(-d)) * 0.5 + 0.5) * arc2D.getWidth();
        double d3 = arc2D.getY() + (Math.sin(Math.toRadians(-d)) * 0.5 + 0.5) * arc2D.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public static Area getSideArea(Arc2D arc2D, Arc2D arc2D2, double d, double d2, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D point2D5 = ChartUtils.intersectsPoint(Cylinder.getArcPoint(arc2D, d), Cylinder.getArcPoint(arc2D2, d), point2D, point2D2);
        Point2D point2D6 = ChartUtils.intersectsPoint(Cylinder.getArcPoint(arc2D, d), Cylinder.getArcPoint(arc2D2, d), point2D3, point2D4);
        Point2D point2D7 = ChartUtils.intersectsPoint(Cylinder.getArcPoint(arc2D, d2), Cylinder.getArcPoint(arc2D2, d2), point2D, point2D2);
        Point2D point2D8 = ChartUtils.intersectsPoint(Cylinder.getArcPoint(arc2D, d2), Cylinder.getArcPoint(arc2D2, d2), point2D3, point2D4);
        if (point2D5 == null || point2D6 == null || point2D7 == null || point2D8 == null) {
            return new Area();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D5.getX(), (float)point2D5.getY());
        generalPath.lineTo((float)point2D6.getX(), (float)point2D6.getY());
        generalPath.lineTo((float)point2D8.getX(), (float)point2D8.getY());
        generalPath.lineTo((float)point2D7.getX(), (float)point2D7.getY());
        generalPath.closePath();
        return new Area(generalPath);
    }

    private boolean isInner() {
        int n = this.projection.getElevation();
        int n2 = this.projection.getFocus();
        double d = (float)n2 / (2.0f * this.getR());
        double d2 = Math.sqrt(1.0 + d * d) - d;
        return Math.cos(Math.toRadians(n)) <= d2;
    }

    private boolean isAngleAtFront(double d) {
        return Math.sin(Math.toRadians(d)) < -this.get_sin_theta();
    }

    private boolean isAngleAtBack(double d) {
        return !this.isAngleAtFront(d);
    }

    private double get_sin_theta() {
        double d = Math.toRadians(this.projection.getElevation());
        int n = this.projection.getFocus();
        return (double)this.getR() * Math.pow(Math.sin(d), 2.0) / (Math.cos(d) * (double)n);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("start_y");
                if (string2 != null) {
                    this.setStart_y(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("x")) != null) {
                    this.setX(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("y")) != null) {
                    this.setY(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("start")) != null) {
                    this.setStart(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("extent")) != null) {
                    this.setExtent(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("depth")) != null) {
                    this.setDepth(Double.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("r")) != null) {
                    this.setR(Float.valueOf(string2).floatValue());
                }
            } else if (string.equals("Projection")) {
                this.setProjection((Projection)xMLableReader.readXMLObject(new Projection()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).startTAG("Attr").attr("start_y", this.getStart_y()).attr("x", this.getX()).attr("y", this.getY()).attr("start", this.getStart()).attr("extent", this.getExtent()).attr("depth", this.getDepth()).attr("r", this.getR()).end();
        if (this.getProjection() != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cylinder)) {
            return false;
        }
        Cylinder cylinder = (Cylinder)object;
        if (cylinder.getStart_y() != this.getStart_y()) {
            return false;
        }
        if (cylinder.getX() != this.getX()) {
            return false;
        }
        if (cylinder.getY() != this.getY()) {
            return false;
        }
        if (cylinder.getStart() != this.getStart()) {
            return false;
        }
        if (cylinder.getExtent() != this.getExtent()) {
            return false;
        }
        if (cylinder.getDepth() != this.getDepth()) {
            return false;
        }
        if (cylinder.getR() != this.getR()) {
            return false;
        }
        return Equals.equals(cylinder.getProjection(), this.getProjection());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("start", this.start);
        jSONObject.put("x", this.x);
        jSONObject.put("start_y", this.start_y);
        jSONObject.put("y", this.y);
        jSONObject.put("depth", this.depth);
        jSONObject.put("extent", this.extent);
        jSONObject.put("R", this.R);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        if (this.colorInfo != null) {
            jSONObject.put("colorInfo", this.colorInfo.toJSONObject());
        }
        return jSONObject;
    }

    public static class CylinderSide
    implements Comparable {
        Cylinder cylinder;
        boolean isStart;

        public CylinderSide(Cylinder cylinder, boolean bl) {
            this.cylinder = cylinder;
            this.isStart = bl;
        }

        public int compareTo(Object object) {
            CylinderSide cylinderSide = (CylinderSide)object;
            double d = this.isStart ? this.cylinder.getStart() : this.cylinder.getStart() + this.cylinder.getExtent();
            double d2 = cylinderSide.isStart ? cylinderSide.cylinder.getStart() : cylinderSide.cylinder.getStart() + cylinderSide.cylinder.getExtent();
            double d3 = Math.abs(d - 90.0) % 360.0;
            double d4 = Math.abs(d2 - 90.0) % 360.0;
            d3 = d3 > 180.0 ? 360.0 - d3 : d3;
            double d5 = d4 = d4 > 180.0 ? 360.0 - d4 : d4;
            if (Math.abs(d3 - d4) < 0.05) {
                if (this.cylinder.getExtent() != 0.0) {
                    d = this.isStart ? this.cylinder.getStart() + this.cylinder.getExtent() / Math.abs(this.cylinder.getExtent()) : this.cylinder.getStart() + this.cylinder.getExtent() - this.cylinder.getExtent() / Math.abs(this.cylinder.getExtent());
                }
                if (cylinderSide.cylinder.getExtent() != 0.0) {
                    d2 = cylinderSide.isStart ? cylinderSide.cylinder.getStart() + cylinderSide.cylinder.getExtent() / Math.abs(cylinderSide.cylinder.getExtent()) : cylinderSide.cylinder.getStart() + cylinderSide.cylinder.getExtent() - cylinderSide.cylinder.getExtent() / Math.abs(cylinderSide.cylinder.getExtent());
                }
                d3 = Math.abs(d - 90.0) % 360.0;
                d4 = Math.abs(d2 - 90.0) % 360.0;
                d3 = d3 > 180.0 ? 360.0 - d3 : d3;
                double d6 = d4 = d4 > 180.0 ? 360.0 - d4 : d4;
            }
            if (d3 < d4) {
                return -1;
            }
            if (d3 > d4) {
                return 1;
            }
            return 0;
        }
    }
}

