/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.chart.shape3d.Cylinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CylinderDemo
extends JFrame {
    private static final long serialVersionUID = -6582385979641442957L;
    CylinderComponent comp;
    JSpinner rotation_spinner;
    JSpinner elevation_spinner;
    JSpinner focus_spinner;

    public static void main(String[] stringArray) {
        new CylinderDemo();
    }

    public CylinderDemo() {
        this.init();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setTitle("Cylinder Demo");
        this.setVisible(true);
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.comp = new CylinderComponent(new Cylinder(0.0, 200.0, 40.0));
        jPanel.add((Component)this.comp, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.rotation_spinner = new JSpinner();
        this.rotation_spinner.setValue(new Integer(this.comp.getCylinder().getProjection().getRotation()));
        this.elevation_spinner = new JSpinner();
        this.elevation_spinner.setValue(new Integer(this.comp.getCylinder().getProjection().getElevation()));
        this.focus_spinner = new JSpinner();
        this.focus_spinner.setValue(new Integer(this.comp.getCylinder().getProjection().getFocus()));
        jPanel2.setLayout(new GridLayout(3, 2));
        jPanel2.add(new JLabel("\u6c34\u5e73\u8f6c\u89d2:"));
        jPanel2.add(this.rotation_spinner);
        jPanel2.add(new JLabel("\u4e0a\u4e0b\u4ef0\u89d2:"));
        jPanel2.add(this.elevation_spinner);
        jPanel2.add(new JLabel("\u900f\u89c6\u7cfb\u6570:"));
        jPanel2.add(this.focus_spinner);
        this.rotation_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)((Number)CylinderDemo.this.rotation_spinner.getValue()).doubleValue();
                CylinderDemo.this.comp.setRotaion(n);
            }
        });
        this.elevation_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)((Number)CylinderDemo.this.elevation_spinner.getValue()).doubleValue();
                CylinderDemo.this.comp.setElevation(n);
            }
        });
        this.focus_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)((Number)CylinderDemo.this.focus_spinner.getValue()).doubleValue();
                CylinderDemo.this.comp.setFocus(n);
            }
        });
    }

    private class CylinderComponent
    extends JComponent {
        Cylinder cylinder = null;
        int x = 0;

        public CylinderComponent(Cylinder cylinder) {
            this.cylinder = cylinder;
            this.cylinder.getProjection().setMode((byte)1);
        }

        public void paintComponent(Graphics graphics) {
            graphics.translate(300, 100);
            this.cylinder.draw(graphics);
        }

        public void play() {
            int n = 0;
            block2: while (true) {
                n += 10;
                int n2 = 0;
                while (true) {
                    if (n2 >= 360) continue block2;
                    this.cylinder.getProjection().setRotation(n2 + n);
                    CylinderDemo.this.rotation_spinner.setValue(new Integer(n2 + n));
                    this.cylinder.getProjection().setElevation(n2);
                    CylinderDemo.this.elevation_spinner.setValue(new Integer(n2));
                    this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n2 += 10;
                }
                break;
            }
        }

        public void setRotaion(int n) {
            this.cylinder.getProjection().setRotation(n);
            this.repaint();
        }

        public void setElevation(int n) {
            this.cylinder.getProjection().setElevation(n);
            this.repaint();
        }

        public void setFocus(int n) {
            this.cylinder.getProjection().setFocus(n);
            this.repaint();
        }

        public Cylinder getCylinder() {
            return this.cylinder;
        }
    }
}

