/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ColorInfo;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.math.Object3D;
import com.fr.chart.math.Projection;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class FoldLine3D
extends SoloGlyph
implements Object3D {
    private static final long serialVersionUID = -5271643180557390028L;
    public static final String XML_TAG = "FoldLine3D";
    private float z = 0.0f;
    private float deep = 60.0f;
    private Projection projection = new Projection();
    private List point_list = new ArrayList();
    private ColorInfo colorInfo = new ColorInfo();

    public FoldLine3D() {
    }

    public FoldLine3D(float f, float f2) {
        this.setZ(f);
        this.setDeep(f2);
    }

    public FoldLine3D(double d, double d2) {
        this.setZ((float)d);
        this.setDeep((float)d2);
    }

    public void moveTo(float f, float f2) {
        this.getPoint_list().clear();
        this.getPoint_list().add(new Point2D.Float(f, f2));
    }

    public void lineTo(float f, float f2) {
        this.getPoint_list().add(new Point2D.Float(f, f2));
    }

    public void closePath() {
        if (this.getPoint_list().size() > 0) {
            this.getPoint_list().add(this.getPoint_list().get(0));
        }
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath[] generalPathArray = this.getGeneralPaths();
        for (int i = 0; i < generalPathArray.length; ++i) {
            this.getColorInfo().paint(graphics2D, generalPathArray[i]);
        }
    }

    private GeneralPath[] getGeneralPaths() {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (int i = 0; i < this.getPoint_list().size() - 1; ++i) {
            double d = ((Point2D)this.getPoint_list().get(i)).getX();
            double d2 = ((Point2D)this.getPoint_list().get(i)).getY();
            double d3 = ((Point2D)this.getPoint_list().get(i + 1)).getX();
            double d4 = ((Point2D)this.getPoint_list().get(i + 1)).getY();
            Point2D point2D = this.getProjection().projectee(d, d2, this.getZ());
            Point2D point2D2 = this.getProjection().projectee(d3, d4, this.getZ());
            Point2D point2D3 = this.getProjection().projectee(d3, d4, this.getZ() - this.getDeep());
            Point2D point2D4 = this.getProjection().projectee(d, d2, this.getZ() - this.getDeep());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.closePath();
            arrayList.add(generalPath);
        }
        return arrayList.toArray(new GeneralPath[arrayList.size()]);
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath[] generalPathArray = this.getGeneralPaths();
        for (int i = 0; i < generalPathArray.length; ++i) {
            generalPath.append(generalPathArray[i], false);
        }
        return generalPath;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public float getZ() {
        return this.z;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setDeep(float f) {
        this.deep = f;
    }

    public float getDeep() {
        return this.deep;
    }

    public void setPoint_list(List list) {
        this.point_list = list;
    }

    public List getPoint_list() {
        return this.point_list;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = xMLableReader.getAttr("z");
                if (string2 != null) {
                    this.setZ(Float.valueOf(string2).floatValue());
                }
                if ((string2 = xMLableReader.getAttr("deep")) != null) {
                    this.setDeep(Float.valueOf(string2).floatValue());
                }
            } else if (string.equals("Projection")) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if (string.equals("PointList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Point")) {
                            Point2D.Float float_ = new Point2D.Float(Float.valueOf(xMLableReader.getAttr("x")).floatValue(), Float.valueOf(xMLableReader.getAttr("y")).floatValue());
                            FoldLine3D.this.point_list.add(float_);
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).startTAG("Attr").attr("z", this.getZ()).attr("deep", this.getDeep()).end();
        if (this.getProjection() != null) {
            this.getProjection().writeXML(xMLPrintWriter);
        }
        if (this.point_list != null && this.point_list.size() > 0) {
            xMLPrintWriter.startTAG("PointList");
            for (int i = 0; i < this.point_list.size(); ++i) {
                Point2D point2D = (Point2D)this.getPoint_list().get(i);
                xMLPrintWriter.startTAG("Point").attr("x", point2D.getX()).attr("y", point2D.getY()).end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FoldLine3D)) {
            return false;
        }
        FoldLine3D foldLine3D = (FoldLine3D)object;
        if (foldLine3D.getZ() != this.getZ()) {
            return false;
        }
        if (foldLine3D.getDeep() != this.getDeep()) {
            return false;
        }
        if (!Equals.equals(foldLine3D.getProjection(), this.getProjection())) {
            return false;
        }
        if (foldLine3D.getPoint_list().size() != this.getPoint_list().size()) {
            return false;
        }
        for (int i = 0; i < foldLine3D.getPoint_list().size(); ++i) {
            if (Equals.equals(foldLine3D.getPoint_list().get(i), this.getPoint_list().get(i))) continue;
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("deep", this.deep);
        jSONObject.put("z", this.z);
        jSONObject.put("point_list", this.point_list);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        if (this.colorInfo != null) {
            jSONObject.put("colorInfo", this.colorInfo.toJSONObject());
        }
        return jSONObject;
    }
}

