/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.shape3d;

import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ColorInfo;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.SoloGlyph;
import com.fr.chart.math.Object3D;
import com.fr.chart.math.Projection;
import com.fr.chart.shape3d.Cylinder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Pie3D
extends SoloGlyph
implements Object3D {
    private static final long serialVersionUID = 4123668892673753116L;
    public static final String XML_TAG = "Pie3D";
    private Projection projection = new Projection();
    private List cylinderList = new ArrayList();

    public void draw(Graphics graphics) {
        Color color;
        int n;
        Serializable serializable;
        XMLable xMLable;
        Cylinder cylinder;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (n2 = 0; n2 < this.getCylinderCount(); ++n2) {
            cylinder = this.getCylinder(n2);
            xMLable = cylinder.getColorInfo();
            serializable = ((ColorInfo)xMLable).getSeriesColor();
            if (serializable != null) {
                ((ColorInfo)xMLable).setSeriesColor(((Color)serializable).darker());
            }
            ((ColorInfo)xMLable).paint(graphics2D, cylinder.bottom());
            ((ColorInfo)xMLable).setSeriesColor((Color)serializable);
        }
        for (n2 = 0; n2 < this.getCylinderCount(); ++n2) {
            cylinder = this.getCylinder(n2);
            xMLable = cylinder.getColorInfo();
            serializable = ((ColorInfo)xMLable).getSeriesColor();
            if (serializable != null) {
                ((ColorInfo)xMLable).setSeriesColor(((Color)serializable).darker());
            }
            ((ColorInfo)xMLable).paint(graphics2D, cylinder.back());
            ((ColorInfo)xMLable).setSeriesColor((Color)serializable);
        }
        Object[] objectArray = new Cylinder.CylinderSide[this.getCylinderCount() * 2];
        for (n = 0; n < this.getCylinderCount(); ++n) {
            objectArray[2 * n] = new Cylinder.CylinderSide(this.getCylinder(n), true);
            objectArray[2 * n + 1] = new Cylinder.CylinderSide(this.getCylinder(n), false);
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            xMLable = ((Cylinder.CylinderSide)objectArray[n]).cylinder;
            serializable = ((Cylinder)xMLable).getColorInfo();
            color = ((ColorInfo)serializable).getSeriesColor();
            if (color != null) {
                ((ColorInfo)serializable).setSeriesColor(color.darker());
            }
            if (((Cylinder.CylinderSide)objectArray[n]).isStart) {
                ((ColorInfo)serializable).paint(graphics2D, ((Cylinder)xMLable).getStartSide());
            } else {
                ((ColorInfo)serializable).paint(graphics2D, ((Cylinder)xMLable).getEndSide());
            }
            ((ColorInfo)serializable).setSeriesColor(color);
        }
        for (n = 0; n < this.getCylinderCount(); ++n) {
            xMLable = this.getCylinder(n);
            serializable = ((Cylinder)xMLable).getColorInfo();
            ((ColorInfo)serializable).paint(graphics2D, ((Cylinder)xMLable).front());
        }
        for (n = 0; n < this.getCylinderCount(); ++n) {
            xMLable = this.getCylinder(n);
            serializable = ((Cylinder)xMLable).getColorInfo();
            color = ((ColorInfo)serializable).getSeriesColor();
            if (color != null) {
                ((ColorInfo)serializable).setSeriesColor(color.brighter());
            }
            ((ColorInfo)serializable).paint(graphics2D, ((Cylinder)xMLable).top());
            ((ColorInfo)serializable).setSeriesColor(color);
        }
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            generalPath.append(this.getCylinder(i).getShape(), false);
        }
        return generalPath;
    }

    public void addCylinder(Cylinder cylinder) {
        this.cylinderList.add(cylinder);
    }

    public Cylinder getCylinder(int n) {
        return (Cylinder)this.cylinderList.get(n);
    }

    public int getCylinderCount() {
        return this.cylinderList.size();
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Projection")) {
                this.setProjection((Projection)xMLableReader.readXMLObject(new Projection()));
            } else if (string.equals("List")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("Cyliner")) {
                            Pie3D.this.addCylinder((Cylinder)xMLableReader.readXMLObject(new Cylinder()));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        if (this.cylinderList != null && this.cylinderList.size() > 0) {
            xMLPrintWriter.startTAG("List");
            for (int i = 0; i < this.cylinderList.size(); ++i) {
                this.getCylinder(i).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3D)) {
            return false;
        }
        Pie3D pie3D = (Pie3D)object;
        if (!Equals.equals(pie3D.getProjection(), this.getProjection())) {
            return false;
        }
        if (pie3D.getCylinderCount() != this.getCylinderCount()) {
            return false;
        }
        for (int i = 0; i < pie3D.getCylinderCount(); ++i) {
            if (Equals.equals(pie3D.getCylinder(i), this.getCylinder(i))) continue;
            return false;
        }
        return true;
    }
}

