/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.Inter;
import com.fr.chart.plot.AreaPlot;
import com.fr.chart.plot.Bar2DPlot;
import com.fr.chart.plot.Bar3DPlot;
import com.fr.chart.plot.CustomPlot;
import com.fr.chart.plot.GanttPlot;
import com.fr.chart.plot.LinePlot;
import com.fr.chart.plot.MeterPlot;
import com.fr.chart.plot.PiePlot;
import com.fr.chart.plot.Plot;
import com.fr.chart.plot.RadarPlot;
import com.fr.chart.plot.RangePlot;
import com.fr.chart.plot.StockPlot;
import com.fr.chart.plot.XYScatterPlot;
import com.fr.data.ChartData;
import com.fr.data.impl.ReportChartData;

public class ChartDataModel {
    private static final String[] categoryName = new String[]{Inter.getLocText("StyleFormat-Category") + 1, Inter.getLocText("StyleFormat-Category") + 2, Inter.getLocText("StyleFormat-Category") + 3};
    private static final String[] seriesName = new String[]{"BC", "CA", "NY", "WA"};
    private static final Object[][] values = new Object[][]{{"10", "20", "30"}, {"20", "30", "40"}, {"30", "40", "50"}, {"40", "50", "60"}};
    private static final Object[] barCategoryName = new Object[]{"a", "b", "c", "d", "e"};
    private static final Object[] barSeriesName = new Object[]{Inter.getLocText("ChartF-Series") + "1", Inter.getLocText("ChartF-Series") + "2", Inter.getLocText("ChartF-Series") + "3"};
    private static final Object[][] bar2DValues = new Object[][]{{"27", "17", "10", "-15", "20"}, {"40", "-20", "6", "22", "-18"}, {"32", "13", "-4", "21", "23"}};
    public static final ReportChartData defaultChartData = new ReportChartData(categoryName, seriesName, values);
    public static final ReportChartData barChartData = new ReportChartData(barCategoryName, barSeriesName, bar2DValues);
    private static final String[] bar3DCate = new String[]{"Cat", "Dog"};
    private static final String[] bar3DSeries = new String[]{"Food", "Apple"};
    private static final String[][] bar3DValue = new String[][]{{"10", "10"}, {"20", "20"}};
    private static final ReportChartData bar3DData = new ReportChartData(bar3DCate, bar3DSeries, bar3DValue);
    private static final Object[] lineCateName = new Object[]{"1" + Inter.getLocText("Month"), "2" + Inter.getLocText("Month"), "3" + Inter.getLocText("Month"), "4" + Inter.getLocText("Month"), "5" + Inter.getLocText("Month"), "6" + Inter.getLocText("Month"), "7" + Inter.getLocText("Month"), "8" + Inter.getLocText("Month")};
    private static final Object[] lineSeriesName = new Object[]{"N", "C"};
    private static final Object[][] lineValue = new Object[][]{{"1", "7", "10", "15", "17", "24", "25", "10"}, {"7", "20", "24", "28", "35", "40", "36", "23"}};
    public static final ReportChartData lineChartData = new ReportChartData(lineCateName, lineSeriesName, lineValue);
    private static final Object[] areaCateName = new Object[]{"Apple", "Banana", "Pear", "Orange", "Grape", "Plum"};
    private static final Object[] areaSeriesName = new Object[]{"Jane", "King"};
    private static final Object[][] areaValue = new Object[][]{{"1", "2", "4", "6", "5", "2"}, {"0", "1", "3", null, "3", "1"}};
    private static final ReportChartData areaChartData = new ReportChartData(areaCateName, areaSeriesName, areaValue);
    private static final String[] rangecate = new String[]{Inter.getLocText("StyleFormat-Category") + 1};
    private static final String[] rangeSeries = new String[]{Inter.getLocText("DataFunction-Min"), Inter.getLocText("DataFunction-Max"), Inter.getLocText("Chart_Average_Value"), Inter.getLocText("Chart_Current_Value")};
    private static final Object[][] rangeValue = new Object[][]{{"6"}, {"30"}, {"18"}, {"24"}};
    public static final ReportChartData rangeChartData = new ReportChartData(rangecate, rangeSeries, rangeValue);
    private static final String[] meterCate = new String[]{Inter.getLocText("StyleFormat-Category") + 1};
    private static final String[] meterSeries = new String[]{Inter.getLocText("ChartF-Meter")};
    private static final Object[][] meterValue = new Object[][]{{"75"}};
    public static final ReportChartData meterChartData = new ReportChartData(meterCate, meterSeries, meterValue);
    private static final String[] stockCate = new String[]{Inter.getLocText("StyleFormat-Category") + 1, Inter.getLocText("StyleFormat-Category") + 2, Inter.getLocText("StyleFormat-Category") + 3, Inter.getLocText("StyleFormat-Category") + 4};
    private static final String[] highLowSeries = new String[]{Inter.getLocText("ChartF-Stock-High"), Inter.getLocText("ChartF-Stock-Low"), Inter.getLocText("ChartF-Stock-Close")};
    private static final Object[][] highLowValue = new Object[][]{{"30", "23", "34", "40"}, {"15", "8", "19", "25"}, {"23", "16", "27", "33"}};
    public static final ReportChartData highLowChartData = new ReportChartData(stockCate, highLowSeries, highLowValue);
    private static final String[] openHighLowSeries = new String[]{Inter.getLocText("ChartF-Stock-Open"), Inter.getLocText("ChartF-Stock-High"), Inter.getLocText("ChartF-Stock-Low"), Inter.getLocText("ChartF-Stock-Close")};
    private static final Object[][] openHighLowValue = new Object[][]{{"15", "20", "27", "24"}, {"35", "28", "45", "34"}, {"10", "3", "20", "10"}, {"25", "10", "37", "15"}};
    public static final ReportChartData openHighLowChartData = new ReportChartData(stockCate, openHighLowSeries, openHighLowValue);
    private static final String[] volumeCate = new String[]{"1", "2", "3", "4", "5"};
    private static final String[] volumeHighLowSeries = new String[]{Inter.getLocText("ChartF-Stock-Volume"), Inter.getLocText("ChartF-Stock-High"), Inter.getLocText("ChartF-Stock-Low"), Inter.getLocText("ChartF-Stock-Close")};
    private static final Object[][] volumeHighLowValue = new Object[][]{{"10", "25", "15", "50", "15"}, {"30", "23", "34", "50", "37"}, {"15", "8", "19", "35", "20"}, {"23", "16", "27", "43", "29"}};
    private static final ReportChartData volumeHighLowChartData = new ReportChartData(volumeCate, volumeHighLowSeries, volumeHighLowValue);
    private static final String[] volumeOpenSeries = new String[]{Inter.getLocText("ChartF-Stock-Volume"), Inter.getLocText("ChartF-Stock-Open"), Inter.getLocText("ChartF-Stock-High"), Inter.getLocText("ChartF-Stock-Low"), Inter.getLocText("ChartF-Stock-Close")};
    private static final Object[][] volumeOpenValue = new Object[][]{{"10", "25", "15", "50", "15"}, {"32", "12", "32", "30", "32"}, {"40", "28", "43", "50", "37"}, {"15", "8", "25", "20", "18"}, {"20", "16", "40", "40", "22"}};
    public static final ReportChartData volumeOpenChartData = new ReportChartData(volumeCate, volumeOpenSeries, volumeOpenValue);
    private static final String[] xySeriesName = new String[]{"S"};
    private static final String[] xyCategoryName = ChartDataModel.createX();
    private static final String[][] xyValue = new String[][]{ChartDataModel.createY()};
    public static final ReportChartData xyPlotChartData = new ReportChartData(xyCategoryName, xySeriesName, xyValue);
    private static final String[] pieCate = new String[]{"Pie1", "Pie2"};
    private static final String[] pieSeries = new String[]{"PS1", "PS2", "PS3", "PS4"};
    private static final String[][] pieValue = new String[][]{{"10", "20"}, {"20", "30"}, {"30", "40"}, {"40", "50"}};
    public static final ReportChartData pieChartData = new ReportChartData(pieCate, pieSeries, pieValue);
    private static final String[] radarCateName = new String[]{"1", "2", "3", "4", "5", "6", "7"};
    private static final Object[] radarSeriesName = new Object[]{"NA"};
    private static final Object[][] radarValue = new Object[][]{{"35", "35", "35", "35", "40", "50", "40"}};
    public static final ReportChartData radarChartData = new ReportChartData(radarCateName, radarSeriesName, radarValue);
    private static final String[] customCate = new String[]{"Mon", "Tom", "Cat", "Dog", "Mouse", "Woo"};
    private static final String[] customSeries = new String[]{"Rect", "Line"};
    private static final String[][] customValue = new String[][]{{"4", "7", "6", "8", "9.5", "9"}, {"5", "8", "7", "9", "10", "9.5"}};
    private static final ReportChartData customChartData = new ReportChartData(customCate, customSeries, customValue);
    private static final String[] ganttCate = new String[]{Inter.getLocText("D-Step") + "1", Inter.getLocText("D-Step") + "2", Inter.getLocText("D-Step") + "3"};
    private static final String[] ganttSeries = new String[]{Inter.getLocText("ChartF-Gannt-PlanStartTime"), Inter.getLocText("ChartF-Gannt-PlanEndTime"), Inter.getLocText("ChartF-Gantt-RealStart"), Inter.getLocText("ChartF-Gantt-RealEndTime"), Inter.getLocText("ChartF-Gantt-Progress")};
    private static final String[][] ganttValue = new String[][]{{"2009/01/01", "2009/01/06", "2009/01/10"}, {"2009/01/03", "2009/01/09", "2009/01/16"}, {"2009/01/02", "2009/01/05", "2009/01/10"}, {"2009/01/03", "2009/01/09", "2009/01/15"}, {"1", "1", "0.3"}};
    private static final ReportChartData ganttChartData = new ReportChartData(ganttCate, ganttSeries, ganttValue);

    public static final ChartData getChartData() {
        return defaultChartData;
    }

    public static final ChartData getChartData(Plot plot) {
        if (plot instanceof MeterPlot) {
            return meterChartData;
        }
        if (plot instanceof RangePlot) {
            return rangeChartData;
        }
        if (plot instanceof StockPlot) {
            int n = ((StockPlot)plot).getSubType();
            if (n == 0) {
                return highLowChartData;
            }
            if (n == 1) {
                return openHighLowChartData;
            }
            if (n == 2) {
                return volumeHighLowChartData;
            }
            if (n == 3) {
                return volumeOpenChartData;
            }
            return highLowChartData;
        }
        if (plot instanceof XYScatterPlot) {
            return xyPlotChartData;
        }
        if (plot instanceof RadarPlot) {
            return radarChartData;
        }
        if (plot instanceof Bar3DPlot) {
            return bar3DData;
        }
        if (plot instanceof Bar2DPlot) {
            return barChartData;
        }
        if (plot instanceof AreaPlot) {
            return areaChartData;
        }
        if (plot instanceof LinePlot) {
            return lineChartData;
        }
        if (plot instanceof CustomPlot) {
            return customChartData;
        }
        if (plot instanceof GanttPlot) {
            return ganttChartData;
        }
        if (plot instanceof PiePlot) {
            return pieChartData;
        }
        return defaultChartData;
    }

    private static String[] createX() {
        String[] stringArray = new String[13];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "" + 10.0 * Math.cos(0.5235987755982988 * (double)i);
        }
        return stringArray;
    }

    private static String[] createY() {
        String[] stringArray = new String[13];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "" + 10.0 * Math.sin(0.5235987755982988 * (double)i);
        }
        return stringArray;
    }
}

