/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.DBFeedback;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.report.core.FormException;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.CharSetNameSpace;
import com.fr.report.write.config.ColumnConfig;
import com.fr.report.write.config.DMLConfig;
import com.fr.report.write.config.IntelliDMLConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;

public class DBManipulation
implements XMLable {
    private String dbName = null;
    private DMLConfig dmlConfig;

    public String getDBName() {
        return this.dbName;
    }

    public void setDBName(String string) {
        this.dbName = string;
    }

    public DMLConfig getDmlConfig() {
        return this.dmlConfig;
    }

    public void setDmlConfig(DMLConfig dMLConfig) {
        this.dmlConfig = dMLConfig;
    }

    public void commit2db(Calculator calculator) throws FormException {
        new CommitWrapper().commit(calculator, false);
    }

    public DBFeedback commit2dbAndFeedback(Calculator calculator) throws FormException {
        CommitWrapper commitWrapper = new CommitWrapper();
        commitWrapper.commit(calculator, true);
        return commitWrapper.feedback;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("dsName", this.getDBName()).end();
        ReportXMLUtils.writeXMLable(xMLPrintWriter, this.dmlConfig, "DMLConfig");
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DMLConfig".equals(string)) {
                DMLConfig dMLConfig = ReportXMLUtils.readDMLConfig(xMLableReader);
                this.setDmlConfig(dMLConfig);
            } else if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("dsName");
                if (string2 != null) {
                    this.setDBName(string2);
                }
                String string3 = null;
                String string4 = null;
                string2 = xMLableReader.getAttr("schemaName");
                if (string2 != null) {
                    string3 = string2;
                }
                if ((string2 = xMLableReader.getAttr("tableName")) != null) {
                    string4 = string2;
                }
                if (string4 != null) {
                    IntelliDMLConfig intelliDMLConfig = new IntelliDMLConfig();
                    intelliDMLConfig.setTable(new Table(string3, string4));
                    this.setDmlConfig(intelliDMLConfig);
                }
            } else if ("Column".equals(string)) {
                DMLConfig dMLConfig;
                String string5 = null;
                boolean bl = false;
                boolean bl2 = false;
                String string6 = xMLableReader.getAttr("name");
                if (string6 != null) {
                    string5 = string6;
                }
                if ((string6 = xMLableReader.getAttr("isKey")) != null) {
                    bl = Boolean.valueOf(string6);
                }
                if ((string6 = xMLableReader.getAttr("skipUnmodified")) != null) {
                    bl2 = Boolean.valueOf(string6);
                }
                if ((dMLConfig = this.getDmlConfig()) instanceof IntelliDMLConfig) {
                    IntelliDMLConfig intelliDMLConfig = (IntelliDMLConfig)dMLConfig;
                    intelliDMLConfig.addColumnConfig(new ColumnConfig(string5, DBManipulation.readColumnValue(xMLableReader), bl, bl2));
                }
            }
        }
    }

    public static Object readColumnValue(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(""){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("ColumnRow".endsWith(string)) {
                        int n = 0;
                        int n2 = 0;
                        String string2 = xMLableReader.getAttr("column");
                        if (string2 != null) {
                            n = Integer.parseInt(string2);
                        }
                        if ((string2 = xMLableReader.getAttr("row")) != null) {
                            n2 = Integer.parseInt(string2);
                        }
                        this.obj = ColumnRow.valueOf(n, n2);
                    } else if ("Parameter".equals(string)) {
                        this.obj = ReportXMLUtils.readParameter(xMLableReader);
                    } else if ("Object".equals(string) || "O".equals(string)) {
                        this.obj = ReportXMLUtils.readObject(xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return xMLObject.getObject();
    }

    public String toString() {
        return this.dmlConfig == null ? "" : this.dmlConfig.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DBManipulation dBManipulation = (DBManipulation)super.clone();
        if (this.dmlConfig != null) {
            dBManipulation.dmlConfig = (DMLConfig)this.dmlConfig.clone();
        }
        return dBManipulation;
    }

    private class CommitWrapper {
        private DBFeedback feedback;

        private CommitWrapper() {
        }

        public void commit(Calculator calculator, boolean bl) throws FormException {
            if (DBManipulation.this.dmlConfig != null) {
                NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(DBManipulation.this.getDBName());
                Connection connection = null;
                try {
                    connection = nameDatabaseConnection.createConnection();
                }
                catch (Exception exception) {
                    DBUtils.closeConnection(connection);
                    throw new FormException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + DBManipulation.this.getDBName() + "\n" + exception.getMessage(), exception);
                }
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl2 = StringUtils.isNotBlank(nameDatabaseConnection.getNewCharsetName()) && StringUtils.isNotBlank(nameDatabaseConnection.getOriginalCharsetName()) && !ComparatorUtils.equals(nameDatabaseConnection.getNewCharsetName(), nameDatabaseConnection.getOriginalCharsetName());
                CharSetNameSpace charSetNameSpace = null;
                if (bl2) {
                    charSetNameSpace = new CharSetNameSpace(nameDatabaseConnection.getNewCharsetName(), nameDatabaseConnection.getOriginalCharsetName());
                    calculator.pushNameSpace(charSetNameSpace);
                }
                try {
                    if (bl) {
                        this.feedback = DBManipulation.this.dmlConfig.executeAndFeedback(connection, calculator);
                    } else {
                        DBManipulation.this.dmlConfig.execute(connection, calculator);
                    }
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    DBUtils.rollback(connection);
                    throw new FormException(exception.getMessage(), exception);
                }
                finally {
                    DBUtils.closeConnection(connection);
                    if (bl2) {
                        calculator.removeNameSpace(charSetNameSpace);
                    }
                }
            }
        }
    }
}

