/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.core.Compare;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.ReportCoreConstants;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.logging.Level;

public class CommonCondition
extends AbstractCondition {
    private String columnName;
    private Compare compare;

    public CommonCondition() {
    }

    public CommonCondition(String string, int n, Object object) {
        this(string, new Compare(n, object));
    }

    public CommonCondition(String string, Compare compare) {
        this.columnName = string;
        this.compare = compare;
    }

    public Compare getCompare() {
        return this.compare;
    }

    public void setCompare(Compare compare) {
        this.compare = compare;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String[] getDependence() {
        return new String[0];
    }

    public boolean eval(Object object, Calculator calculator) {
        Compare compare = this.getCompare();
        Object object2 = compare.getValue();
        if (!(object2 instanceof String) && !(object2 instanceof Primitive) && (object2 = calculator.resolveVariable(object2)) != null) {
            try {
                compare = (Compare)compare.clone();
                compare.setValue(object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
        }
        return compare.eval(object);
    }

    public int[] evalTableData(TableData tableData, int[] nArray, int n, Calculator calculator) {
        Compare compare;
        int n2;
        if (tableData == null || this.columnName == null) {
            return new int[0];
        }
        IntList intList = new IntList();
        int n3 = -1;
        try {
            n2 = tableData.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                if (!ComparatorUtils.tableDataColumnNameEquals(this.columnName, tableData.getColumnName(i))) continue;
                n3 = i;
                break;
            }
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        if (n3 == -1) {
            return intList.toArray();
        }
        n2 = 0;
        try {
            n2 = tableData.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        if (nArray == null) {
            nArray = IntList.range(n2);
        }
        if ((compare = this.getCompare()) != null) {
            Object object = compare.getValue();
            if (!(object instanceof String) && !(object instanceof Primitive)) {
                if (object instanceof Formula) {
                    try {
                        object = calculator.eval(((Formula)object).getContent());
                    }
                    catch (UtilEvalError utilEvalError) {
                        object = null;
                    }
                } else if (object instanceof Parameter) {
                    if ((object = ((Parameter)object).getValue()) instanceof JSONArray) {
                        JSONArray jSONArray = (JSONArray)object;
                        FArray fArray = new FArray();
                        int n4 = jSONArray.length();
                        for (int i = 0; i < n4; ++i) {
                            try {
                                fArray.add(jSONArray.get(i));
                                continue;
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                        }
                        object = fArray;
                    }
                } else {
                    object = calculator.resolveVariable(object);
                }
                if (object != null) {
                    try {
                        compare = (Compare)compare.clone();
                        compare.setValue(object);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    }
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                if (n5 < 0 || n5 >= n2) continue;
                try {
                    Object object2 = tableData.getValueAt(n5, n3);
                    if (!compare.eval(object2)) continue;
                    intList.add(n5);
                    continue;
                }
                catch (TableDataException tableDataException) {
                    FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                }
            }
        }
        return intList.toArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CommonCondition)) {
            return false;
        }
        CommonCondition commonCondition = (CommonCondition)object;
        return ComparatorUtils.equals(commonCondition.getColumnName(), this.getColumnName()) && ComparatorUtils.equals(commonCondition.getCompare(), this.getCompare());
    }

    public String toString() {
        return this.getColumnName() + " " + ReportCoreConstants.conditionToString(this.getCompare());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Compare".equals(string) || "Condition".equals(string)) {
                this.compare = new Compare(0, "");
                xMLableReader.readXMLObject(this.compare);
            } else if ("CNAME".equals(string)) {
                this.columnName = xMLableReader.getElementValue();
            } else if ("SelectionColumn".equals(string)) {
                this.columnName = xMLableReader.getAttr("name");
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.columnName)) {
            xMLPrintWriter.startTAG("CNAME").textNode(this.columnName);
            xMLPrintWriter.end();
        }
        if (this.getCompare() != null) {
            this.getCompare().writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CommonCondition commonCondition = (CommonCondition)super.clone();
        if (this.compare != null) {
            commonCondition.compare = (Compare)this.compare.clone();
        }
        return commonCondition;
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.get("columnname") != null) {
            this.setColumnName(jSONObject.getString("columnname"));
        }
        if (jSONObject.get("compare") != null) {
            Compare compare = new Compare();
            compare.parseJSON(jSONObject.getJSONObject("compare"));
            this.setCompare(compare);
        }
    }
}

