/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.condition.AbstractCondition;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.CurrentValueNameSpace;
import com.fr.report.script.SingleRowNameSpace;
import java.util.logging.Level;

public class FormulaCondition
extends AbstractCondition {
    private String formulaContent;

    public FormulaCondition() {
    }

    public FormulaCondition(String string) {
        this.formulaContent = string;
    }

    public String getFormula() {
        return this.formulaContent;
    }

    public void setFormula(String string) {
        this.formulaContent = string;
    }

    public String[] getDependence() {
        return ScriptUtils.getDependenceByFormula(this.formulaContent);
    }

    public boolean eval(Object object, Calculator calculator) {
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(object);
        calculator.pushNameSpace(currentValueNameSpace);
        boolean bl = false;
        try {
            bl = Boolean.TRUE.equals(calculator.eval(this.getFormula()));
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        calculator.removeNameSpace(currentValueNameSpace);
        return bl;
    }

    public int[] evalTableData(TableData tableData, int[] nArray, int n, Calculator calculator) {
        if (tableData == null || calculator == null) {
            return new int[0];
        }
        int n2 = 0;
        try {
            n2 = tableData.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        if (nArray == null) {
            nArray = IntList.range(n2);
        }
        IntList intList = new IntList();
        SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(tableData, Integer.MIN_VALUE, null);
        calculator.pushNameSpace(singleRowNameSpace);
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= n2) continue;
            try {
                singleRowNameSpace.setRowIndex(n3);
                singleRowNameSpace.setCurrentValue(tableData.getValueAt(n3, n));
                if (!Boolean.TRUE.equals(calculator.eval(this.getFormula()))) continue;
                intList.add(n3);
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        calculator.removeNameSpace(singleRowNameSpace);
        return intList.toArray();
    }

    public String toString() {
        return this.formulaContent;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FormulaCondition)) {
            return false;
        }
        FormulaCondition formulaCondition = (FormulaCondition)object;
        return ComparatorUtils.equals(formulaCondition.getFormula(), this.getFormula());
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Formula".equals(xMLableReader.getTagName()) && StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
            this.formulaContent = string.startsWith("=") ? string.substring(1) : string;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.formulaContent)) {
            xMLPrintWriter.startTAG("Formula").textNode(this.getFormula()).end();
        }
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
    }
}

