/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.Condition;
import com.fr.data.condition.JoinCondition;
import com.fr.report.script.Calculator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ListCondition
extends AbstractCondition {
    private List joinConditionList = new ArrayList();

    public int getJoinConditionCount() {
        return this.joinConditionList.size();
    }

    public void addCondition(Condition condition) {
        this.addJoinCondition(new JoinCondition(0, condition));
    }

    public void addJoinCondition(int n, Condition condition) {
        this.addJoinCondition(new JoinCondition(n, condition));
    }

    public void addJoinCondition(JoinCondition joinCondition) {
        Condition condition = joinCondition.getCondition();
        if (condition == null) {
            return;
        }
        if (condition instanceof ListCondition && ((ListCondition)condition).getJoinConditionCount() == 0) {
            return;
        }
        this.joinConditionList.add(joinCondition);
    }

    public JoinCondition getJoinCondition(int n) {
        if (n < 0 || n >= this.joinConditionList.size()) {
            return null;
        }
        return (JoinCondition)this.joinConditionList.get(n);
    }

    public void setJoinCondition(int n, JoinCondition joinCondition) {
        this.joinConditionList.set(n, joinCondition);
    }

    public void removeJoinCondition(int n) {
        if (n < 0 || n >= this.joinConditionList.size()) {
            return;
        }
        this.joinConditionList.remove(n);
    }

    public void clearJoinConditions() {
        this.joinConditionList.clear();
    }

    public String[] getDependence() {
        Object[] objectArray = new String[]{};
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            Condition condition = ((JoinCondition)iterator.next()).getCondition();
            objectArray = (String[])ArrayUtils.addAll(objectArray, condition.getDependence());
        }
        return objectArray;
    }

    public boolean eval(Object object, Calculator calculator) {
        return this.inner_eval(object, calculator);
    }

    public int[] evalTableData(TableData tableData, int[] nArray, int n, Calculator calculator) {
        int[] nArray2 = new int[]{};
        if (tableData == null) {
            return nArray2;
        }
        int n2 = 0;
        try {
            n2 = tableData.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        nArray2 = nArray == null ? IntList.range(n2) : nArray;
        int n3 = this.getJoinConditionCount();
        for (int i = 0; i < n3; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            Condition condition = joinCondition.getCondition();
            if (i == 0 || joinCondition.getJoin() == 0) {
                nArray2 = condition.evalTableData(tableData, nArray2, n, calculator);
                continue;
            }
            if (joinCondition.getJoin() != 1) continue;
            nArray2 = IntList.unionArray(nArray2, condition.evalTableData(tableData, nArray, n, calculator));
        }
        return nArray2;
    }

    private boolean inner_eval(Object object, Calculator calculator) {
        int n = this.getJoinConditionCount();
        if (n <= 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            int n2 = joinCondition.getJoin();
            Condition condition = joinCondition.getCondition();
            bl = i == 0 ? condition.eval(object, calculator) : (n2 == 0 ? bl && condition.eval(object, calculator) : bl || condition.eval(object, calculator));
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.joinConditionList.size(); ++i) {
            JoinCondition joinCondition = (JoinCondition)this.joinConditionList.get(i);
            if (i != 0) {
                if (joinCondition.getJoin() == 0) {
                    stringBuffer.append(" and ");
                } else {
                    stringBuffer.append(" or ");
                }
            }
            if (joinCondition.getCondition() == null) continue;
            stringBuffer.append(joinCondition.getCondition().toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListCondition)) {
            return false;
        }
        ListCondition listCondition = (ListCondition)object;
        if (listCondition.getJoinConditionCount() != this.getJoinConditionCount()) {
            return false;
        }
        for (int i = 0; i < this.getJoinConditionCount(); ++i) {
            if (ComparatorUtils.equals(listCondition.getJoinCondition(i), this.getJoinCondition(i))) continue;
            return false;
        }
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearJoinConditions();
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("JoinCondition")) {
            JoinCondition joinCondition = new JoinCondition();
            this.joinConditionList.add(joinCondition);
            xMLableReader.readXMLObject(joinCondition);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n = this.getJoinConditionCount();
        for (int i = 0; i < n; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            joinCondition.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ListCondition listCondition = (ListCondition)super.clone();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.getJoinConditionCount(); ++i) {
            arrayList.add(this.getJoinCondition(i).clone());
        }
        listCondition.joinConditionList = arrayList;
        return listCondition;
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("commonconditions");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            CommonCondition commonCondition = new CommonCondition();
            commonCondition.parseJSON(jSONArray.getJSONObject(i));
            this.addCondition(commonCondition);
        }
    }
}

