/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.Condition;
import com.fr.data.condition.FormulaCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.Compare;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.core.ScriptUtils;
import com.fr.report.parameter.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class LiteConditionUtils {
    public static Condition ColumnRowToValue(Condition condition, Report report) {
        try {
            if (condition instanceof CommonCondition) {
                CommonCondition commonCondition = (CommonCondition)condition.clone();
                Compare compare = commonCondition.getCompare();
                Object object = compare.getValue();
                if (object != null && object instanceof ColumnRow) {
                    ColumnRow columnRow = (ColumnRow)object;
                    CellElement cellElement = report.getCellElement(columnRow.column, columnRow.row);
                    if (cellElement == null) {
                        compare.setValue(null);
                    } else {
                        compare.setValue(cellElement.getValue());
                    }
                }
                return commonCondition;
            }
            if (condition instanceof FormulaCondition) {
                return (FormulaCondition)condition.clone();
            }
            if (condition instanceof ListCondition) {
                ListCondition listCondition = (ListCondition)condition.clone();
                int n = listCondition.getJoinConditionCount();
                for (int i = 0; i < n; ++i) {
                    JoinCondition joinCondition = listCondition.getJoinCondition(i);
                    joinCondition.setCondition(LiteConditionUtils.ColumnRowToValue(joinCondition.getCondition(), report));
                }
                return listCondition;
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return new ListCondition();
    }

    public static void getAllParameters(Condition condition, List list) {
        if (condition instanceof CommonCondition) {
            Object object;
            Compare compare = ((CommonCondition)condition).getCompare();
            Object object2 = object = compare == null ? null : compare.getValue();
            if (object instanceof Parameter) {
                list.add(object);
            }
        } else if (condition instanceof ObjectCondition) {
            Object object;
            Compare compare = ((ObjectCondition)condition).getCompare();
            Object object3 = object = compare == null ? null : compare.getValue();
            if (object instanceof Parameter) {
                list.add(object);
            }
        } else if (condition instanceof ListCondition) {
            ListCondition listCondition = (ListCondition)condition;
            int n = listCondition.getJoinConditionCount();
            for (int i = 0; i < n; ++i) {
                LiteConditionUtils.getAllParameters(listCondition.getJoinCondition(i).getCondition(), list);
            }
        }
    }

    public static void getAllLiteCondition(Condition condition, List list) {
        if (condition == null) {
            return;
        }
        if (condition instanceof ListCondition) {
            ListCondition listCondition = (ListCondition)condition;
            int n = listCondition.getJoinConditionCount();
            for (int i = 0; i < n; ++i) {
                LiteConditionUtils.getAllLiteCondition(listCondition.getJoinCondition(i).getCondition(), list);
            }
        } else {
            list.add(condition);
        }
    }

    public static void getAllJoinCondition(Condition condition, List list) {
        if (condition == null) {
            return;
        }
        if (condition instanceof CommonCondition) {
            JoinCondition joinCondition = new JoinCondition(0, condition);
            list.add(joinCondition);
        } else if (condition instanceof ListCondition) {
            ListCondition listCondition = (ListCondition)condition;
            int n = listCondition.getJoinConditionCount();
            for (int i = 0; i < n; ++i) {
                Condition condition2 = listCondition.getJoinCondition(i).getCondition();
                if (!(condition2 instanceof CommonCondition)) continue;
                list.add(listCondition.getJoinCondition(i));
            }
        }
    }

    public static int replaceLiteCondition(Condition condition, String string, String string2) {
        int n = 0;
        if (condition instanceof CommonCondition) {
            String string3 = ((CommonCondition)condition).getColumnName();
            if (ComparatorUtils.equals(string3, string)) {
                string3 = string2;
                ((CommonCondition)condition).setColumnName(string3);
                ++n;
            }
        } else if (condition instanceof ListCondition) {
            int n2 = ((ListCondition)condition).getJoinConditionCount();
            for (int i = 0; i < n2; ++i) {
                String string4;
                JoinCondition joinCondition = ((ListCondition)condition).getJoinCondition(i);
                Condition condition2 = joinCondition.getCondition();
                if (!(condition2 instanceof CommonCondition) || !ComparatorUtils.equals(string4 = ((CommonCondition)condition2).getColumnName(), string)) continue;
                string4 = string2;
                ((CommonCondition)condition2).setColumnName(string4);
                joinCondition.setCondition(condition2);
                ((ListCondition)condition).setJoinCondition(i, joinCondition);
                ++n;
            }
        }
        return n;
    }

    public static void convertLiteConditionWhenInsertRow(Condition condition, int n) {
        if (condition instanceof CommonCondition) {
            ColumnRow columnRow;
            CommonCondition commonCondition = (CommonCondition)condition;
            if (commonCondition.getCompare() != null && commonCondition.getCompare().getValue() instanceof ColumnRow && (columnRow = (ColumnRow)commonCondition.getCompare().getValue()) != null && columnRow.row >= n) {
                commonCondition.getCompare().setValue(ColumnRow.valueOf(columnRow.column, columnRow.row + 1));
            }
        } else if (condition instanceof FormulaCondition) {
            String string = ((FormulaCondition)condition).getFormula();
            ((FormulaCondition)condition).setFormula(ScriptUtils.moveRow(string, n, 1));
        } else if (condition instanceof ListCondition) {
            ArrayList arrayList = new ArrayList();
            LiteConditionUtils.getAllLiteCondition(condition, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Condition condition2 = (Condition)arrayList.get(i);
                LiteConditionUtils.convertLiteConditionWhenInsertRow(condition2, n);
            }
        }
    }

    public static void convertLiteConditionWhenRemoveRow(Condition condition, int n) {
        if (condition instanceof CommonCondition) {
            ColumnRow columnRow;
            CommonCondition commonCondition = (CommonCondition)condition;
            if (commonCondition.getCompare() != null && commonCondition.getCompare().getValue() instanceof ColumnRow && (columnRow = (ColumnRow)commonCondition.getCompare().getValue()) != null && columnRow.row >= n) {
                commonCondition.getCompare().setValue(ColumnRow.valueOf(columnRow.column, columnRow.row - 1));
            }
        } else if (condition instanceof FormulaCondition) {
            String string = ((FormulaCondition)condition).getFormula();
            ((FormulaCondition)condition).setFormula(ScriptUtils.moveRow(string, n, -1));
        } else if (condition instanceof ListCondition) {
            ArrayList arrayList = new ArrayList();
            LiteConditionUtils.getAllLiteCondition(condition, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Condition condition2 = (Condition)arrayList.get(i);
                LiteConditionUtils.convertLiteConditionWhenRemoveRow(condition2, n);
            }
        }
    }

    public static void convertLiteConditionWhenInsertCol(Condition condition, int n) {
        if (condition instanceof CommonCondition) {
            ColumnRow columnRow;
            CommonCondition commonCondition = (CommonCondition)condition;
            if (commonCondition.getCompare() != null && commonCondition.getCompare().getValue() instanceof ColumnRow && (columnRow = (ColumnRow)commonCondition.getCompare().getValue()) != null && columnRow.column >= n) {
                commonCondition.getCompare().setValue(ColumnRow.valueOf(columnRow.column + 1, columnRow.row));
            }
        } else if (condition instanceof FormulaCondition) {
            String string = ((FormulaCondition)condition).getFormula();
            ((FormulaCondition)condition).setFormula(ScriptUtils.moveColumn(string, n, 1));
        } else if (condition instanceof ListCondition) {
            ArrayList arrayList = new ArrayList();
            LiteConditionUtils.getAllLiteCondition(condition, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Condition condition2 = (Condition)arrayList.get(i);
                LiteConditionUtils.convertLiteConditionWhenInsertCol(condition2, n);
            }
        }
    }

    public static void convertLiteConditionWhenRemoveCol(Condition condition, int n) {
        if (condition instanceof CommonCondition) {
            ColumnRow columnRow;
            CommonCondition commonCondition = (CommonCondition)condition;
            if (commonCondition.getCompare() != null && commonCondition.getCompare().getValue() instanceof ColumnRow && (columnRow = (ColumnRow)commonCondition.getCompare().getValue()) != null && columnRow.column >= n) {
                commonCondition.getCompare().setValue(ColumnRow.valueOf(columnRow.column - 1, columnRow.row));
            }
        } else if (condition instanceof FormulaCondition) {
            String string = ((FormulaCondition)condition).getFormula();
            ((FormulaCondition)condition).setFormula(ScriptUtils.moveColumn(string, n, -1));
        } else if (condition instanceof ListCondition) {
            ArrayList arrayList = new ArrayList();
            LiteConditionUtils.getAllLiteCondition(condition, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Condition condition2 = (Condition)arrayList.get(i);
                LiteConditionUtils.convertLiteConditionWhenRemoveCol(condition2, n);
            }
        }
    }
}

