/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.core.Compare;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.ReportCoreConstants;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.logging.Level;

public class ObjectCondition
extends AbstractCondition {
    private Compare compare;

    public ObjectCondition() {
    }

    public ObjectCondition(Compare compare) {
        this.setCompare(compare);
    }

    public Compare getCompare() {
        return this.compare;
    }

    public void setCompare(Compare compare) {
        this.compare = compare;
    }

    public String[] getDependence() {
        return ScriptUtils.getDependenceByCompare(this.compare);
    }

    public boolean eval(Object object, Calculator calculator) {
        if (this.compare == null) {
            return true;
        }
        Compare compare = this.getCompare();
        Object object2 = compare.getValue();
        if (object2 instanceof Formula) {
            try {
                object2 = calculator.eval(((Formula)object2).getContent().substring(1));
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
            }
        } else if (!(object2 instanceof String) && !(object2 instanceof Primitive)) {
            object2 = calculator.resolveVariable(object2);
        } else if (object2 instanceof String && ((String)object2).startsWith("@")) {
            object2 = calculator.resolveVariable(object2);
        }
        if (object2 != null) {
            try {
                compare = (Compare)compare.clone();
                compare.setValue(object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
        }
        return compare.eval(object);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ObjectCondition)) {
            return false;
        }
        ObjectCondition objectCondition = (ObjectCondition)object;
        return ComparatorUtils.equals(objectCondition.getCompare(), this.getCompare());
    }

    public String toString() {
        return "currentValue " + ReportCoreConstants.conditionToString(this.getCompare());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && ("Compare".equals(xMLableReader.getTagName()) || xMLableReader.getTagName().equals("Condition"))) {
            this.compare = new Compare(0, "");
            xMLableReader.readXMLObject(this.compare);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getCompare() != null) {
            this.getCompare().writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectCondition objectCondition = (ObjectCondition)super.clone();
        if (this.compare != null) {
            objectCondition.compare = (Compare)this.compare.clone();
        }
        return objectCondition;
    }
}

