/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.console;

import com.fr.base.FRContext;
import com.fr.base.file.DatasourceManager;
import com.fr.data.AbstractTableData;
import com.fr.data.TableDataException;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JDBCDataBaseConnectionTableData
extends AbstractTableData {
    private String[] columnNames = new String[]{"Check", "Name", "DataBaseType", "Driver", "URL", "User", "Password", "originalCharsetName", "newCharsetName", "delete", "modify"};
    private List dataList = new ArrayList();

    public JDBCDataBaseConnectionTableData() {
        this.transform();
    }

    public int getColumnCount() throws TableDataException {
        return this.columnNames.length;
    }

    public String getColumnName(int n) throws TableDataException {
        return this.columnNames[n];
    }

    public int getRowCount() throws TableDataException {
        return this.dataList.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.dataList.size() || n2 >= this.columnNames.length) {
            return null;
        }
        return ((Object[])this.dataList.get(n))[n2];
    }

    public void transform() {
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        Iterator iterator = datasourceManager.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Connection connection = datasourceManager.getConnection(string);
            if (!(connection instanceof JDBCDatabaseConnection)) continue;
            JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)connection;
            Object[] objectArray = new Object[this.columnNames.length];
            objectArray[0] = new Boolean(true);
            objectArray[1] = string;
            String string2 = jDBCDatabaseConnection.getDriver();
            String string3 = jDBCDatabaseConnection.getURL();
            objectArray[2] = string2.equals("sun.jdbc.odbc.JdbcOdbcDriver") ? (string3.indexOf(".mdb") > 0 ? new Integer(6) : new Integer(10)) : (string2.equals("org.apache.derby.jdbc.ClientDriver") ? new Integer(7) : (string2.equals("oracle.jdbc.driver.OracleDriver") ? new Integer(1) : (string2.equals("com.ibm.db2.jcc.DB2Driver") ? new Integer(2) : (string2.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver") ? new Integer(9) : (string2.equals("org.gjt.mm.mysql.Driver") ? new Integer(4) : (string2.equals("com.mysql.jdbc.Driver") ? new Integer(4) : (string2.equals("org.hsqldb.jdbcDriver") ? new Integer(10) : (string2.equals("com.sybase.jdbc2.jdbc.SybDriver") ? new Integer(5) : (string2.equals("com.inet.tds.TdsDriver") ? new Integer(10) : (string2.equals("org.postgresql.Driver") ? new Integer(8) : (string2.equals("COM.cloudscape.JDBCDriver") ? new Integer(10) : (string2.equals("com.internetcds.jdbc.tds.Driver") ? new Integer(10) : (string2.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver") ? new Integer(3) : new Integer(0))))))))))))));
            objectArray[3] = string2;
            objectArray[4] = string3;
            objectArray[5] = jDBCDatabaseConnection.getUser();
            objectArray[6] = jDBCDatabaseConnection.getPassword();
            objectArray[7] = jDBCDatabaseConnection.getOriginalCharsetName();
            objectArray[8] = jDBCDatabaseConnection.getNewCharsetName();
            objectArray[9] = null;
            objectArray[10] = null;
            this.dataList.add(objectArray);
        }
    }
}

