/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.ColumnRow;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.adhoc.TransJSON;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.AnDSColumn;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Compare
implements XMLReadable,
Serializable,
Cloneable,
TransJSON {
    public static final int EQUALS = 0;
    public static final int NOT_EQUAL = 1;
    public static final int GREATER_THAN = 2;
    public static final int GREATER_THAN_OR_EQUAL = 3;
    public static final int LESS_THAN = 4;
    public static final int LESS_THAN_OR_EQUAL = 5;
    public static final int BEGINS_WITH = 6;
    public static final int NOT_BEGIN_WITH = 7;
    public static final int ENDS_WITH = 8;
    public static final int NOT_END_WITH = 9;
    public static final int CONTAINS = 10;
    public static final int NOT_CONTAIN = 11;
    public static final int IN = 12;
    public static final int NOT_IN = 13;
    public static final String XML_TAG = "Compare";
    private int op;
    private Object value;
    private Map nameMap = null;

    public Compare() {
    }

    public Compare(int n, Object object) {
        this.setOp(n);
        this.setValue(object);
    }

    public int getOp() {
        return this.op;
    }

    public void setOp(int n) {
        this.op = n;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object == null ? Primitive.NULL : (object.toString().equalsIgnoreCase("nofilter") ? Primitive.NOFILTER : object);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Compare)) {
            return false;
        }
        Compare compare = (Compare)object;
        return compare.getOp() == this.getOp() && ComparatorUtils.equals(compare.getValue(), this.getValue());
    }

    public boolean eval(Object object) {
        Object object2 = this.getValue();
        if (object2 instanceof Parameter) {
            object2 = ((Parameter)object2).getValue();
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        if (object == null) {
            object = Primitive.NULL;
        }
        if (object2 == null) {
            object2 = Primitive.NULL;
        }
        if (object2 == Primitive.NOFILTER || object == Primitive.NOFILTER) {
            return true;
        }
        switch (this.getOp()) {
            case 0: {
                if (object2 instanceof FArray) {
                    FArray fArray = (FArray)object2;
                    if (fArray.length() > 0) {
                        if (fArray.toList().contains(object)) {
                            return true;
                        }
                    } else {
                        object2 = null;
                    }
                }
                return ComparatorUtils.equals(object, object2);
            }
            case 1: {
                if (object2 instanceof FArray) {
                    object2 = ((FArray)object2).length() > 0 ? ((FArray)object2).elementAt(0) : null;
                }
                return !ComparatorUtils.equals(object, object2);
            }
            case 2: {
                return ComparatorUtils.compare(object, object2) > 0;
            }
            case 3: {
                return ComparatorUtils.compare(object, object2) >= 0;
            }
            case 4: {
                return ComparatorUtils.compare(object, object2) < 0;
            }
            case 5: {
                return ComparatorUtils.compare(object, object2) <= 0;
            }
            case 6: {
                if (object == null || object2 == null) {
                    return false;
                }
                return object.toString().startsWith(object2.toString());
            }
            case 7: {
                if (object == null || object2 == null) {
                    return false;
                }
                return !object.toString().startsWith(object2.toString());
            }
            case 8: {
                if (object == null || object2 == null) {
                    return false;
                }
                return object.toString().endsWith(object2.toString());
            }
            case 9: {
                if (object == null || object2 == null) {
                    return false;
                }
                return !object.toString().endsWith(object2.toString());
            }
            case 10: {
                if (object == null || object2 == null) {
                    return false;
                }
                return object.toString().indexOf(object2.toString()) != -1;
            }
            case 11: {
                if (object == null || object2 == null) {
                    return false;
                }
                return object.toString().indexOf(object2.toString()) == -1;
            }
            case 12: {
                if (object2 instanceof FArray) {
                    FArray fArray = (FArray)object2;
                    boolean bl = false;
                    int n = fArray.length();
                    for (int i = 0; i < n; ++i) {
                        if (!ComparatorUtils.equals(object, fArray.elementAt(i))) continue;
                        bl = true;
                        break;
                    }
                    return bl;
                }
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object2).indexOf((String)object) >= 0;
                }
                return false;
            }
            case 13: {
                if (object2 instanceof FArray) {
                    FArray fArray = (FArray)object2;
                    int n = fArray.length();
                    for (int i = 0; i < n; ++i) {
                        if (!ComparatorUtils.equals(object, fArray.elementAt(i))) continue;
                        return false;
                    }
                    return true;
                }
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object2).indexOf((String)object) < 0;
                }
                return false;
            }
        }
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttr("op")) != null) {
            this.setOp(Integer.parseInt(string));
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (string2.equals("ColumnRow")) {
                int n = 0;
                int n2 = 0;
                string = xMLableReader.getAttr("column");
                if (string != null) {
                    n = Integer.parseInt(string);
                }
                if ((string = xMLableReader.getAttr("row")) != null) {
                    n2 = Integer.parseInt(string);
                }
                this.setValue(ColumnRow.valueOf(n, n2));
            } else if (string2.equals("AnDSColumn")) {
                AnDSColumn anDSColumn = new AnDSColumn();
                xMLableReader.readXMLObject(anDSColumn);
                this.setValue(anDSColumn);
            } else if ("Parameter".equals(string2)) {
                this.setValue(ReportXMLUtils.readParameter(xMLableReader));
            } else if ("Object".equals(string2) || "O".equals(string2)) {
                this.setValue(ReportXMLUtils.readObject(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("op", this.getOp());
        Object object = this.getValue();
        if (object instanceof ColumnRow) {
            ColumnRow columnRow = (ColumnRow)object;
            BaseXMLUtils.writeColumnRow(xMLPrintWriter, columnRow);
        } else if (object instanceof Parameter) {
            ReportXMLUtils.writeParameter(xMLPrintWriter, (Parameter)object);
        } else if (object instanceof AnDSColumn) {
            ((AnDSColumn)object).writeXML(xMLPrintWriter);
        } else {
            ReportXMLUtils.writeObject(xMLPrintWriter, this.getValue());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    private int stringOP2Int(String string) {
        if (this.nameMap == null) {
            this.nameMap = new HashMap();
            this.nameMap.put("\u7b49\u4e8e", new Integer(0));
            this.nameMap.put("\u4e0d\u7b49\u4e8e", new Integer(1));
            this.nameMap.put("\u5927\u4e8e", new Integer(2));
            this.nameMap.put("\u5c0f\u4e8e\u7b49\u4e8e", new Integer(3));
            this.nameMap.put("\u5c0f\u4e8e", new Integer(4));
            this.nameMap.put("\u5927\u4e8e\u7b49\u4e8e", new Integer(5));
        }
        return (Integer)this.nameMap.get(string);
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("op") && jSONObject.get("op") instanceof String) {
            this.setOp(this.stringOP2Int(jSONObject.getString("op")));
        }
        if (jSONObject.has("value")) {
            if (jSONObject.getString("type").equals("string")) {
                this.setValue(jSONObject.getString("value"));
            } else if (jSONObject.getString("type").equals("int")) {
                this.setValue(new Integer(jSONObject.getInt("value")));
            } else if (jSONObject.getString("type").equals("double")) {
                this.setValue(new Double(jSONObject.getDouble("value")));
            } else if (jSONObject.getString("type").equals("date")) {
                this.setValue(DateUtils.DATEFORMAT2.parse(jSONObject.getString("value")));
            } else if (jSONObject.getString("type").equals("boolean")) {
                this.setValue(new Boolean(jSONObject.getBoolean("value")));
            }
        }
    }
}

