/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.file.DatasourceManager;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.util.function.DataFunction;
import com.fr.report.TableDataSource;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import com.fr.report.web.ui.CustomWidgetConfig;
import com.fr.report.web.ui.WidgetConfig;
import com.fr.report.web.ui.WidgetManager;
import com.fr.util.Utils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class DataUtils {
    private static Map databaseSQLTablesMap = new HashMap();
    private static Map schemaMap = new HashMap();
    private static Map tableMap = new HashMap();
    private static Map viewMap = new HashMap();
    private static Map procedureMap = new HashMap();
    static /* synthetic */ Class class$oracle$jdbc$OracleTypes;

    private DataUtils() {
    }

    public static int calculateOracleType(String string) {
        try {
            Field field = (class$oracle$jdbc$OracleTypes == null ? (class$oracle$jdbc$OracleTypes = DataUtils.class$("oracle.jdbc.OracleTypes")) : class$oracle$jdbc$OracleTypes).getDeclaredField(string.toUpperCase());
            return field.getInt(class$oracle$jdbc$OracleTypes == null ? (class$oracle$jdbc$OracleTypes = DataUtils.class$("oracle.jdbc.OracleTypes")) : class$oracle$jdbc$OracleTypes);
        }
        catch (Exception exception) {
            return -10;
        }
    }

    public static String getFunctionDisplayName(DataFunction dataFunction) {
        if (dataFunction == null) {
            return "";
        }
        String string = dataFunction.getClass().getName();
        int n = string.lastIndexOf(".");
        n = n != -1 ? ++n : 0;
        StringBuffer stringBuffer = new StringBuffer("DataFunction-");
        stringBuffer.append(string.substring(n, string.length() - "Function".length()));
        return Inter.getLocText(stringBuffer.toString());
    }

    public static String createSelectSQL(String string, String string2) {
        return DataUtils.createSelectSQL(new Table(string, string2), null, null);
    }

    public static String createSelectSQL(Table table) {
        return DataUtils.createSelectSQL(table, null, null);
    }

    public static String createSelectSQL(Table table, String[] stringArray, Dialect dialect) {
        int n;
        Select select = new Select(table);
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            select.addColumnName(stringArray[i]);
        }
        return select.toNormalSQLString(dialect);
    }

    public static Object getResultSetObject(ResultSet resultSet, int n, int n2, String string, String string2, Dialect dialect) throws SQLException {
        Object object = DataUtils.getResultSetObject(resultSet, n, n2, dialect);
        if (string != null && string.length() > 0 && object instanceof String) {
            try {
                if (string2 != null && string2.length() > 0) {
                    return new String(((String)object).getBytes(string), string2);
                }
                return new String(((String)object).getBytes(string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRContext.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return object == null ? Primitive.NULL : object;
    }

    public static WidgetConfig getClonedWidgetConfig(WidgetManager widgetManager, String string) throws Exception {
        WidgetConfig widgetConfig = widgetManager.getWidgetConfig(string);
        if (widgetConfig instanceof CustomWidgetConfig) {
            ((CustomWidgetConfig)widgetConfig).setWidgetType(string);
        }
        if (widgetConfig != null) {
            return (WidgetConfig)widgetConfig.clone();
        }
        if (widgetConfig == null) {
            throw new Exception("No such widget with name \"" + string + "\".");
        }
        return widgetConfig;
    }

    public static TableData getClonedTableData(DatasourceManager datasourceManager, String string) throws Exception {
        TableData tableData = datasourceManager.getTableData(string);
        if (tableData != null) {
            return tableData;
        }
        String string2 = null;
        String string3 = null;
        int n = -1;
        if (string != null) {
            n = string.indexOf(":");
        }
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2 != null && string3 != null) {
            Iterator iterator = datasourceManager.getConnectionNameIterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Connection connection = datasourceManager.getConnection(string4);
                if (!(connection instanceof DatabaseConnection)) continue;
                DatabaseConnection databaseConnection = (DatabaseConnection)connection;
                if (!string4.equals(string2)) continue;
                TableProcedure[] tableProcedureArray = DataUtils.getDatabaseSQLTables(databaseConnection, null);
                for (int i = 0; i < tableProcedureArray.length; ++i) {
                    if (!ComparatorUtils.equals(string3, tableProcedureArray[i].getName())) continue;
                    return new DBTableData(databaseConnection, DataUtils.createSelectSQL(tableProcedureArray[i].getSchema(), tableProcedureArray[i].getName()));
                }
            }
        }
        if (tableData == null) {
            throw new Exception("No such tabledata with name \"" + string + "\".");
        }
        return tableData;
    }

    public static Object getResultSetObject(ResultSet resultSet, int n, int n2, Dialect dialect) throws SQLException {
        SQLTypeHandlerFactory sQLTypeHandlerFactory = SQLTypeHandlerFactory.buildSQLTypeHanderFactory();
        SQLTypeHandler sQLTypeHandler = sQLTypeHandlerFactory.getTypeHandler(new Integer(n));
        return sQLTypeHandler.getValue(resultSet, n2, n, dialect);
    }

    public static String writeDictObject(Object object) {
        if (object == null) {
            return "null:null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            if (object instanceof Integer) {
                return object + ":I";
            }
            if (object instanceof Long) {
                return object + ":L";
            }
            if (object instanceof Float) {
                return object + ":F";
            }
            if (object instanceof Double) {
                return object + ":D";
            }
            if (object instanceof BigInteger) {
                return object + ":BI";
            }
            if (object instanceof BigDecimal) {
                return object + ":BD";
            }
        } else {
            if (object instanceof Boolean) {
                return object + ":B";
            }
            if (object instanceof Date) {
                return DateUtils.DATEFORMAT2.format((Date)object) + ":DT";
            }
        }
        return object.toString();
    }

    public static Object readDictObject(String string) {
        Object object = string;
        if (string != null && string.matches(".*:.*")) {
            if (string.equals("null:null")) {
                return null;
            }
            try {
                if (string.endsWith(":I")) {
                    object = Integer.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":L")) {
                    object = Long.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":F")) {
                    object = Float.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":D")) {
                    object = Double.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":BI")) {
                    object = new BigInteger(string.substring(0, string.length() - 3));
                } else if (string.endsWith(":BD")) {
                    object = new BigDecimal(string.substring(0, string.length() - 3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = string;
            }
            if (string.endsWith(":B")) {
                object = Boolean.valueOf(string.substring(0, string.length() - 2));
            } else if (string.endsWith(":DT")) {
                object = DateUtils.object2Date(string.substring(0, string.length() - 3), true);
            }
        }
        return object;
    }

    public static Object getTableDataValue(TableData tableData, int n, int n2) {
        if (n2 < -1) {
            return null;
        }
        try {
            return n2 == -1 ? new Integer(n + 1) : tableData.getValueAt(n, n2);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            return null;
        }
    }

    public static String getOnlyColumnName(List list, String string) {
        if (list.contains(string = Utils.replaceAllString(string, " ", "_"))) {
            for (int i = 2; i < 1200; ++i) {
                String string2 = string + "_" + i;
                if (list.contains(string2)) continue;
                return string2;
            }
        }
        return string;
    }

    public static TableProcedure[] getDatabaseSQLTables(DatabaseConnection databaseConnection, String string) throws Exception {
        Map map = (Map)databaseSQLTablesMap.get(databaseConnection);
        TableProcedure[] tableProcedureArray = null;
        if (map == null) {
            HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
            tableProcedureArray = FRContext.getCurrentEnv().getSQLTablesProcedure(databaseConnection, string);
            if (tableProcedureArray == null) {
                tableProcedureArray = new TableProcedure[]{};
            }
            hashMap.put(string, tableProcedureArray);
            databaseSQLTablesMap.put(databaseConnection, hashMap);
        } else {
            tableProcedureArray = (TableProcedure[])map.get(string);
            if (tableProcedureArray == null) {
                tableProcedureArray = FRContext.getCurrentEnv().getSQLTablesProcedure(databaseConnection, string);
                if (tableProcedureArray == null) {
                    tableProcedureArray = new TableProcedure[]{};
                }
                map.put(string, tableProcedureArray);
                databaseSQLTablesMap.put(databaseConnection, map);
            }
        }
        return tableProcedureArray;
    }

    public static void refreshTables(DatabaseConnection databaseConnection, String string) throws Exception {
        HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
        TableProcedure[] tableProcedureArray = FRContext.getCurrentEnv().getSQLTablesProcedure(databaseConnection, string);
        if (tableProcedureArray == null) {
            tableProcedureArray = new TableProcedure[]{};
        }
        hashMap.put(string, tableProcedureArray);
        databaseSQLTablesMap.put(databaseConnection, hashMap);
    }

    public static String[] getDatabaseSchema(DatabaseConnection databaseConnection) {
        String[] stringArray = (String[])schemaMap.get(databaseConnection);
        if (stringArray == null) {
            try {
                stringArray = FRContext.getCurrentEnv().getTableSchema(databaseConnection);
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                schemaMap.put(databaseConnection, stringArray);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return stringArray;
    }

    public static void refreshSchema(DatabaseConnection databaseConnection) {
        try {
            String[] stringArray = FRContext.getCurrentEnv().getTableSchema(databaseConnection);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            schemaMap.put(databaseConnection, stringArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static TableProcedure[] getTables(DatabaseConnection databaseConnection, String string, String string2, boolean bl) throws Exception {
        Map map;
        if (string.equals("TABLE")) {
            map = tableMap;
        } else if (string.equals("VIEW")) {
            map = viewMap;
        } else if (string.equals("PROCEDURE")) {
            map = procedureMap;
        } else {
            return null;
        }
        if (bl && string.equals("TABLE")) {
            string = "ALLTABLE";
        }
        Map map2 = (Map)map.get(databaseConnection);
        TableProcedure[] tableProcedureArray = null;
        if (map2 == null) {
            HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
            tableProcedureArray = FRContext.getCurrentEnv().getTableProcedure(databaseConnection, string, string2);
            if (tableProcedureArray == null) {
                tableProcedureArray = new TableProcedure[]{};
            }
            hashMap.put(string2, tableProcedureArray);
            map.put(databaseConnection, hashMap);
        } else {
            tableProcedureArray = (TableProcedure[])map2.get(string2);
            if (tableProcedureArray == null) {
                tableProcedureArray = FRContext.getCurrentEnv().getTableProcedure(databaseConnection, string, string2);
                if (tableProcedureArray == null) {
                    tableProcedureArray = new TableProcedure[]{};
                }
                map2.put(string2, tableProcedureArray);
                map.put(databaseConnection, map2);
            }
        }
        return tableProcedureArray;
    }

    public static void refreshTables(DatabaseConnection databaseConnection, String string, String string2) {
        Map map;
        if (string.equals("TABLE")) {
            map = tableMap;
        } else if (string.equals("VIEW")) {
            map = viewMap;
        } else if (string.equals("PROCEDURE")) {
            map = procedureMap;
        } else {
            return;
        }
        Map map2 = (Map)map.get(databaseConnection);
        if (map2 == null) {
            return;
        }
        map2.remove(string2);
    }

    public static TableData getTableData4Function(Calculator calculator, String string) {
        TableDataSource tableDataSource = calculator.getCurrentTableDataSource();
        if (tableDataSource == null) {
            return null;
        }
        TableData tableData = null;
        tableData = tableDataSource.getTableData(string);
        if (tableData != null) {
            DataUtils.setTableDataParameterValue(calculator, tableData.getParameters());
        }
        if (tableData == null) {
            DatasourceManager datasourceManager = FRContext.getDatasourceManager();
            try {
                tableData = DataUtils.getClonedTableData(datasourceManager, string);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
            tableDataSource.putTableData(string, tableData);
            DataUtils.setTableDataParameterValue(calculator, tableData.getParameters());
        }
        return tableData;
    }

    private static void setTableDataParameterValue(Calculator calculator, Parameter[] parameterArray) {
        if (ArrayUtils.isEmpty(parameterArray)) {
            return;
        }
        if (!ArrayUtils.isEmpty(parameterArray)) {
            for (int i = 0; i < parameterArray.length; ++i) {
                Parameter parameter = parameterArray[i];
                Object object = calculator.resolveVariable(parameter.getName());
                if (object == null) continue;
                parameter.setValue(object);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

