/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.ClassComparator;
import com.fr.base.FRContext;
import com.fr.base.XMLable;
import com.fr.base.core.FRCoreContext;
import com.fr.base.file.DatasourceManager;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.Condition;
import com.fr.data.condition.FormulaCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.define.DataSource;
import com.fr.data.core.define.FileDataSource;
import com.fr.data.core.define.URLDataSource;
import com.fr.data.impl.Connection;
import com.fr.data.impl.CustomDictionary;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseDictionary;
import com.fr.data.impl.DirectoryConnection;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.NameDictionary62;
import com.fr.data.impl.NameTableData;
import com.fr.data.impl.TableDataDictionary;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.NoneFunction;
import com.fr.report.web.ui.WidgetConfig;
import com.fr.report.web.ui.reg.NoneReg;
import com.fr.report.web.ui.reg.RegExp;
import com.fr.util.Utils;
import java.util.Comparator;
import java.util.logging.Level;

public class DataXMLUtils {
    private DataXMLUtils() {
    }

    public static void writeXMLDataSource(XMLPrintWriter xMLPrintWriter, DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        xMLPrintWriter.startTAG("DataSource").attr("class", dataSource.getClass().getName());
        dataSource.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static DataSource readXMLDataSource(XMLableReader xMLableReader) {
        DataSource dataSource = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if ((string = string.trim()).endsWith(".FileDataSource")) {
                dataSource = new FileDataSource();
            } else if (string.endsWith(".URLDataSource")) {
                dataSource = new URLDataSource();
            } else {
                try {
                    dataSource = (DataSource)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (dataSource instanceof XMLable) {
                xMLableReader.readXMLObject(dataSource);
            }
        }
        return dataSource;
    }

    public static void writeXMLConnection(XMLPrintWriter xMLPrintWriter, Connection connection) {
        DataXMLUtils.writeXMLConnection(xMLPrintWriter, connection, null);
    }

    public static void writeXMLConnection(XMLPrintWriter xMLPrintWriter, Connection connection, String string) {
        if (connection == null) {
            return;
        }
        xMLPrintWriter.startTAG("Connection");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", connection.getClass().getName());
        connection.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLTableData(XMLPrintWriter xMLPrintWriter, TableData tableData) {
        DataXMLUtils.writeXMLTableData(xMLPrintWriter, tableData, null);
    }

    public static void writeXMLTableData(XMLPrintWriter xMLPrintWriter, TableData tableData, String string) {
        if (tableData == null) {
            return;
        }
        xMLPrintWriter.startTAG("TableData");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", tableData.getClass().getName());
        tableData.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLWidgetConfig(XMLPrintWriter xMLPrintWriter, WidgetConfig widgetConfig, String string) {
        if (widgetConfig == null) {
            return;
        }
        xMLPrintWriter.startTAG("WidgetConfig");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", widgetConfig.getClass().getName());
        widgetConfig.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLDictionary(XMLPrintWriter xMLPrintWriter, Dictionary dictionary) {
        DataXMLUtils.writeXMLDictionary(xMLPrintWriter, dictionary, null);
    }

    public static void writeXMLDictionary(XMLPrintWriter xMLPrintWriter, Dictionary dictionary, String string) {
        if (dictionary == null) {
            return;
        }
        xMLPrintWriter.startTAG("Dictionary");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", dictionary.getClass().getName());
        dictionary.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static DataFunction readXMLDataFunction(String string) {
        string = Utils.replaceAllString(string, "com.fr.data.function", "com.fr.data.impl.function");
        string = Utils.replaceAllString(string, "com.fr.data.impl.function", "com.fr.data.util.function");
        try {
            return (DataFunction)FRCoreContext.classForName(string).newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return new NoneFunction();
        }
    }

    public static Connection readXMLConnectionMap(XMLableReader xMLableReader) {
        final DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    datasourceManager.clearAllConnection();
                }
                if (xMLableReader.isChildNode() && "Connection".equals(xMLableReader.getTagName())) {
                    String string = null;
                    String string2 = null;
                    string2 = xMLableReader.getAttr("name");
                    if (string2 != null) {
                        string = string2;
                    }
                    if (string == null) {
                        return;
                    }
                    this.obj = DataXMLUtils.readXMLConnection(xMLableReader);
                    datasourceManager.putConnection(string, (Connection)this.obj);
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Connection)xMLObject.getObject();
    }

    public static Connection readXMLConnection(XMLableReader xMLableReader) {
        Connection connection = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.indexOf(".JDBCDatabase") > 0) {
                connection = new JDBCDatabaseConnection();
            } else if (string.indexOf(".JNDIDatabase") > 0) {
                connection = new JNDIDatabaseConnection();
            } else if (string.endsWith(".NameDatabase")) {
                connection = new NameDatabaseConnection();
            } else if (string.indexOf(".DirectoryConnection") > 0 || string.endsWith(".TextDatasource")) {
                connection = new DirectoryConnection();
            } else {
                try {
                    connection = (Connection)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (connection != null) {
                xMLableReader.readXMLObject(connection);
            }
        }
        return connection;
    }

    public static TableData readXMLTableData(XMLableReader xMLableReader) {
        TableData tableData = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".TableData$1")) {
                tableData = TableData.EMPTY_TABLEDATA;
            } else {
                if (string.endsWith(".DBTableData") || string.endsWith(".JDBCTableData") || string.equals("JDBCTableData")) {
                    tableData = new DBTableData();
                } else if (string.endsWith(".EmbeddedTableData")) {
                    tableData = new EmbeddedTableData();
                } else if (string.endsWith(".NameTableData")) {
                    tableData = new NameTableData();
                } else {
                    try {
                        tableData = (TableData)FRCoreContext.classForName(string).newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                        return null;
                    }
                }
                xMLableReader.readXMLObject(tableData);
            }
        }
        return tableData;
    }

    public static WidgetConfig readXMLWidgetConfig(XMLableReader xMLableReader) {
        WidgetConfig widgetConfig = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            try {
                widgetConfig = (WidgetConfig)FRCoreContext.classForName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRContext.getLogger().log(Level.WARNING, instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRContext.getLogger().log(Level.WARNING, illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRContext.getLogger().log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
            }
            xMLableReader.readXMLObject(widgetConfig);
        }
        return widgetConfig;
    }

    public static RegExp readXMLReg(XMLableReader xMLableReader) {
        RegExp regExp = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            try {
                regExp = (RegExp)FRCoreContext.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                regExp = new NoneReg();
            }
        }
        xMLableReader.readXMLObject(regExp);
        return regExp;
    }

    public static Dictionary readXMLDictionary(XMLableReader xMLableReader) {
        Dictionary dictionary = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".TableDataDictionary") || string.endsWith(".TableDataDict") || string.endsWith(".TableDataMap")) {
                dictionary = new TableDataDictionary();
            } else if (string.endsWith(".DatabaseDictionary") || string.endsWith(".DBDict") || string.endsWith(".DBMap") || string.endsWith(".JDBCMap") || string.endsWith(".SimpleDBMap")) {
                dictionary = new DatabaseDictionary();
            } else if (string.endsWith(".CustomDictionary") || string.endsWith(".CustomDict") || string.endsWith(".CustomMap") || string.endsWith(".ListMap")) {
                dictionary = new CustomDictionary();
            } else {
                if (string.endsWith("NameDictionary")) {
                    NameDictionary62 nameDictionary62 = new NameDictionary62();
                    xMLableReader.readXMLObject(nameDictionary62);
                    return nameDictionary62.createDict();
                }
                if (string.endsWith("TreeRendererMVList") || string.endsWith("RendererMVList")) {
                    dictionary = new CustomDictionary();
                } else {
                    try {
                        dictionary = (Dictionary)FRCoreContext.classForName(string).newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                        dictionary = new CustomDictionary();
                    }
                }
            }
            xMLableReader.readXMLObject(dictionary);
        }
        return dictionary;
    }

    public static Condition readCondition(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            try {
                Condition condition = (Condition)FRCoreContext.classForName(string).newInstance();
                xMLableReader.readXMLObject(condition);
                return condition;
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static Comparator readXMLComparator(XMLableReader xMLableReader) {
        Comparator comparator = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".ClassComparator")) {
                comparator = new ClassComparator();
            } else {
                try {
                    comparator = (Comparator)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (comparator instanceof XMLable) {
                xMLableReader.readXMLObject((XMLReadable)((Object)comparator));
            }
        }
        return comparator;
    }

    public static void writeXMLComparator(XMLPrintWriter xMLPrintWriter, Comparator comparator) {
        if (comparator == null) {
            return;
        }
        xMLPrintWriter.startTAG("Comparator").attr("class", comparator.getClass().getName());
        if (comparator instanceof XMLable) {
            ((XMLable)((Object)comparator)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static Condition readXMLCondition(XMLableReader xMLableReader) {
        Condition condition = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".CommonCondition")) {
                condition = new CommonCondition();
            } else if (string.endsWith(".FormulaCondition")) {
                condition = new FormulaCondition();
            } else if (string.endsWith(".ListCondition")) {
                condition = new ListCondition();
            } else if (string.endsWith(".ObjectCondition")) {
                condition = new ObjectCondition();
            } else {
                try {
                    Class clazz = FRCoreContext.classForName(string);
                    condition = (Condition)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    condition = new ListCondition();
                }
            }
            if (condition instanceof XMLable) {
                xMLableReader.readXMLObject(condition);
            }
        }
        return condition;
    }

    public static void writeXMLCondition(XMLPrintWriter xMLPrintWriter, Condition condition) {
        if (condition == null) {
            return;
        }
        xMLPrintWriter.startTAG("Condition").attr("class", condition.getClass().getName());
        if (condition instanceof XMLable) {
            condition.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }
}

