/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db;

import com.fr.base.FRContext;
import com.fr.base.core.DateUtils;
import com.fr.base.core.list.IntList;
import com.fr.base.file.DatasourceManager;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.impl.AbstractDatabaseConnection;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.report.script.Primitive;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;

public class DBUtils {
    private DBUtils() {
    }

    public static void applyColumnTypeValue(Dialect dialect, java.sql.Connection connection, Table table, String string, PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        FRContext.getLogger().log(Level.INFO, "columnIndex:" + n + "[" + n2 + "]" + "<--->" + "columnValue:" + object + "[" + (object == null ? "NULL" : object.getClass().getName()) + "]");
        if (DBUtils.isNULL(object)) {
            preparedStatement.setNull(n, n2);
            return;
        }
        if (dialect.isYearData(connection, n2, table, string)) {
            object = DateUtils.date2Year(object);
        }
        SQLTypeHandlerFactory sQLTypeHandlerFactory = SQLTypeHandlerFactory.buildSQLTypeHanderFactory();
        SQLTypeHandler sQLTypeHandler = sQLTypeHandlerFactory.getTypeHandler(new Integer(n2));
        sQLTypeHandler.setValue(preparedStatement, n, object, n2, dialect);
    }

    public static boolean isNULL(Object object) {
        return object == null || Primitive.NULL.equals(object);
    }

    public static int getColumnFRType(int n) {
        int n2;
        for (n2 = 0; n2 < DBConstants.STRING_ARRAY.length; ++n2) {
            if (DBConstants.STRING_ARRAY[n2] != n) continue;
            return DBConstants.FR_STRING;
        }
        for (n2 = 0; n2 < DBConstants.NUMBER_ARRAY.length; ++n2) {
            if (DBConstants.NUMBER_ARRAY[n2] != n) continue;
            return DBConstants.FR_NUMBER;
        }
        for (n2 = 0; n2 < DBConstants.NULL_ARRAY.length; ++n2) {
            if (DBConstants.NULL_ARRAY[n2] != n) continue;
            return DBConstants.FR_NULL;
        }
        for (n2 = 0; n2 < DBConstants.STREAM_ARRAY.length; ++n2) {
            if (DBConstants.STREAM_ARRAY[n2] != n) continue;
            return DBConstants.FR_STREAM;
        }
        for (n2 = 0; n2 < DBConstants.BOOLEAN_ARRAY.length; ++n2) {
            if (DBConstants.BOOLEAN_ARRAY[n2] != n) continue;
            return DBConstants.FR_BOOLEAN;
        }
        return DBConstants.FR_NULL;
    }

    public static void closeConnection(java.sql.Connection connection) {
        try {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
    }

    public static void rollback(java.sql.Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
                FRContext.getLogger().log(Level.INFO, "Rollback Successfully");
            } else {
                FRContext.getLogger().log(Level.INFO, "Failed to rollback because of the connection is autoCommit");
            }
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block23: {
            String string = "oracle.jdbc.driver.OracleDriver";
            String string2 = "jdbc:oracle:thin:@192.168.100.169:1521:orcl10g";
            Statement statement = null;
            ResultSet resultSet = null;
            java.sql.Connection connection = null;
            Class.forName(string);
            connection = DriverManager.getConnection(string2, "scott", "tiger");
            CallableStatement callableStatement = null;
            callableStatement = connection.prepareCall("{call SCOTT.GETENAMEANDJOBS(?,?)}");
            callableStatement.registerOutParameter(1, -10);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.execute();
            resultSet = (ResultSet)callableStatement.getObject(1);
            while (resultSet.next()) {
                System.out.println("<tr><td>" + resultSet.getString(1) + "</td><td>" + resultSet.getString(2) + "</td></tr>");
            }
            Object var8_9 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                break block23;
            }
            catch (SQLException sQLException) {}
            break block23;
            {
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    Object var8_10 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            if (statement != null) {
                                statement.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        break block23;
                    }
                    catch (SQLException sQLException2) {}
                    break block23;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_11 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            if (statement != null) {
                                statement.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        break block23;
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static Object[] remoteProcedureCall(java.sql.Connection connection, String string, int n) throws SQLException {
        n = Math.max(0, n - 1);
        Object[] objectArray = new Object[2];
        Statement statement = null;
        ResultSet resultSet = null;
        Dialect dialect = DialectFactory.generateDialect(connection);
        if (dialect instanceof OracleDialect) {
            int n2;
            CallableStatement callableStatement = null;
            IntList intList = new IntList();
            int n3 = string.split("\\?").length - 1;
            if (n3 > 0) {
                statement = connection.prepareCall(string);
                callableStatement = statement;
                for (n2 = 1; n2 <= n3; ++n2) {
                    callableStatement.registerOutParameter(n2, -10);
                    intList.add(n2);
                }
            } else if (string.indexOf("$[") != -1) {
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                int n4 = 1;
                int n5 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    int n6;
                    int n7;
                    if ((n5 = string.indexOf("$[", n7 = n5)) < 0) {
                        stringBuffer.append(string.substring(n7));
                        break;
                    }
                    stringBuffer.append(string.substring(n7, n5));
                    int n8 = string.indexOf("]$", n5 + 2);
                    if (n8 <= n5) break;
                    String string2 = string.substring(n5 + 2, n8);
                    if (string2 == null || string2.length() <= 0) {
                        n5 = n8 + 2;
                        continue;
                    }
                    if (string2.startsWith("@")) {
                        intList.add(n4);
                        string2 = string2.substring(1);
                    }
                    if ((n6 = DataUtils.calculateOracleType(string2)) == -10) {
                        intList.add(n4);
                    }
                    hashMap.put(new Integer(n4), new Integer(n6));
                    n5 = n8 + 2;
                    stringBuffer.append("?");
                    ++n4;
                }
                statement = connection.prepareCall(stringBuffer.toString());
                callableStatement = (CallableStatement)statement;
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer n9 = (Integer)iterator.next();
                    callableStatement.registerOutParameter((int)n9, (int)((Integer)hashMap.get(n9)));
                }
            }
            callableStatement.execute();
            n2 = 1;
            if (intList.size() > n) {
                n2 = intList.get(n);
            }
            if (callableStatement instanceof OracleCallableStatement) {
                resultSet = ((OracleCallableStatement)callableStatement).getCursor(n2);
            } else {
                Object object = callableStatement.getObject(n2);
                if (object instanceof ResultSet) {
                    resultSet = (ResultSet)object;
                } else {
                    String string3 = object.toString();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string3);
                }
            }
        } else {
            statement = connection.prepareCall(string, 1003, 1007);
            CallableStatement callableStatement = statement;
            resultSet = callableStatement.executeQuery();
            --n;
            while (callableStatement.getMoreResults() && n >= 0) {
                resultSet = callableStatement.getResultSet();
            }
        }
        objectArray[0] = statement;
        objectArray[1] = resultSet;
        return objectArray;
    }

    public static String[] checkInColumnNames(java.sql.Connection connection, String string, int n) {
        try {
            ColumnInformation[] columnInformationArray = DBUtils.checkInColumnInformation(connection, string, n);
            String[] stringArray = new String[columnInformationArray.length];
            for (int i = 0; i < columnInformationArray.length; ++i) {
                stringArray[i] = columnInformationArray[i].getColumnName();
            }
            return stringArray;
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            return new String[0];
        }
    }

    public static ColumnInformation[] checkInColumnInformation(java.sql.Connection connection, String string, int n) throws SQLException {
        Object[] objectArray;
        if (connection == null) {
            throw new SQLException("Cannot connect to database!");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (DBUtils.isProcedure(string)) {
                objectArray = DBUtils.remoteProcedureCall(connection, string, n);
                statement = (Statement)objectArray[0];
                resultSet = (ResultSet)objectArray[1];
            } else {
                statement = connection.createStatement();
                try {
                    resultSet = statement.executeQuery("select * from (" + string + ") t where 4 = 5");
                }
                catch (Exception exception) {
                    statement.close();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                }
            }
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        objectArray = DBUtils.checkInColumnInformationByMetaData(resultSet.getMetaData());
        resultSet.close();
        statement.close();
        return objectArray;
    }

    public static ColumnInformation[] checkInColumnInformationByMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        ColumnInformation[] columnInformationArray = new ColumnInformation[n];
        for (int i = 0; i < n; ++i) {
            columnInformationArray[i] = new ColumnInformation(resultSetMetaData.getColumnLabel(i + 1), resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getColumnTypeName(i + 1));
            resultSetMetaData.getScale(i + 1);
        }
        return columnInformationArray;
    }

    public static boolean isProcedure(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().startsWith("{") && string.trim().substring(1).trim().toUpperCase().startsWith("CALL");
    }

    public static boolean isExsitedTable(DatabaseConnection databaseConnection, String string) {
        try {
            TableProcedure[] tableProcedureArray = FRContext.getCurrentEnv().getSQLTablesProcedure(databaseConnection, null);
            int n = tableProcedureArray.length;
            for (int i = 0; i < n; ++i) {
                TableProcedure tableProcedure = tableProcedureArray[i];
                if (!string.equalsIgnoreCase(tableProcedure.getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FRContext.getLogger().info(exception.getMessage());
        }
        return false;
    }

    public static void refreshDatabase() {
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        Iterator iterator = datasourceManager.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            Object object;
            AbstractDatabaseConnection abstractDatabaseConnection;
            String string4 = (String)iterator.next();
            Connection connection = datasourceManager.getConnection(string4);
            if (!(connection instanceof DatabaseConnection)) continue;
            DatabaseConnection databaseConnection = (DatabaseConnection)connection;
            if (databaseConnection instanceof JDBCDatabaseConnection) {
                abstractDatabaseConnection = new JDBCDatabaseConnection();
                object = ((JDBCDatabaseConnection)connection).getDriver();
                string3 = ((JDBCDatabaseConnection)connection).getURL();
                string2 = ((JDBCDatabaseConnection)connection).getUser();
                string = ((JDBCDatabaseConnection)connection).getPassword();
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setDriver((String)object);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setURL(string3);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setUser(string2);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setPassword(string);
                datasourceManager.putConnection(string4, abstractDatabaseConnection);
                continue;
            }
            if (!(connection instanceof JNDIDatabaseConnection)) continue;
            abstractDatabaseConnection = new JNDIDatabaseConnection();
            object = ((JNDIDatabaseConnection)connection).getContextHashtable();
            string3 = ((JNDIDatabaseConnection)connection).getJNDIName();
            string2 = ((JNDIDatabaseConnection)connection).getNewCharsetName();
            string = ((JNDIDatabaseConnection)connection).getOriginalCharsetName();
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setContextHashtable((Hashtable)object);
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setJNDIName(string3);
            abstractDatabaseConnection.setNewCharsetName(string2);
            abstractDatabaseConnection.setOriginalCharsetName(string);
            datasourceManager.putConnection(string4, abstractDatabaseConnection);
        }
    }
}

