/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StringUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AbstractDialect
implements Dialect {
    protected String left_quote = null;
    protected String right_quote = null;
    private static int fetchSize = -1;

    public int getFetchSize() {
        return fetchSize;
    }

    public String column2SQL(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return string;
        }
        return this.left_quote + string.trim().toUpperCase() + this.right_quote;
    }

    public String columnType2SQL(int n, String string) {
        return TypeUtils.getTypeName(n);
    }

    public String table2SQL(Table table) {
        if (table == null) {
            return "";
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return table.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = table.getSchema();
        if (!StringUtils.isBlank(string)) {
            stringBuffer.append(this.column2SQL(string)).append(".");
        }
        stringBuffer.append(this.column2SQL(table.getName()));
        return stringBuffer.toString();
    }

    public String[] getSchemas(Connection connection) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringUtils.isBlank(databaseMetaData.getSchemaTerm())) {
            ResultSet resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1).trim());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public List getTableProcedure(Connection connection, String string, boolean bl) throws Exception {
        if (connection == null) {
            throw new Exception("Cannot connect to database!");
        }
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = null;
        if (string != null) {
            string2 = connection.getCatalog();
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        catch (SQLException sQLException) {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        while (resultSet.next()) {
            arrayList.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
        }
        resultSet.close();
        return arrayList;
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return string3;
    }

    public String getIdentitySelectString(String string, String string2, int n) throws Exception {
        return this.getIdentitySelectString();
    }

    protected String getIdentitySelectString() throws Exception {
        throw new Exception("Dialect does not support identity key generation");
    }

    public void setAutoCommit(Connection connection, boolean bl) throws SQLException {
        connection.setAutoCommit(bl);
    }

    public String getLimitString(String string, int n, int n2) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public String getCountSql(String string) {
        return string == null ? null : "SELECT COUNT(*) AS rowcount FROM (" + string + ") t";
    }

    public boolean isYearData(Connection connection, int n, Table table, String string) {
        return false;
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    }
}

