/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import java.sql.Connection;

public class DB2Dialect
extends AbstractDialect {
    private int db2FetchSize = 50;
    private String defaultAutoIncrease = "GENERATED ALWAYS AS IDENTITY (START WITH 1,INCREMENT BY 1,MINVALUE 1,NO CACHE)";

    public DB2Dialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    public String columnType2SQL(int n, String string) {
        switch (n) {
            case -7: {
                return "varchar(1)";
            }
            case 4: {
                return "integer";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case -6: {
                return "smallint";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 1: {
                return "char(" + string + ")";
            }
            case -1: {
                return "long varchar";
            }
            case -4: {
                return "long varchar";
            }
            case 2004: {
                return "blob(" + string + ")";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    public int getFetchSize() {
        return this.db2FetchSize;
    }

    public void setFetchSize(int n) {
        this.db2FetchSize = n;
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return string3 + " " + this.defaultAutoIncrease;
    }

    public String getIdentitySelectString() {
        return "values identity_val_local()";
    }

    public String getLimitString(String string, int n, int n2) {
        int n3 = string.toLowerCase().indexOf("select");
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100).append(string.substring(0, n3)).append("select * from ( select ").append(this.getRowNumber(string));
        if (DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(" row_.* from ( ").append(string.substring(n3)).append(" ) as row_");
        } else {
            stringBuffer.append(string.substring(n3 + 6));
        }
        stringBuffer.append(" ) as temp_ where rownumber_ ");
        stringBuffer.append("between " + (n + 1) + " and " + n2);
        return stringBuffer.toString();
    }

    private static boolean hasDistinct(String string) {
        return string.toLowerCase().indexOf("select distinct") >= 0;
    }

    private String getRowNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer(50).append("rownumber() over(");
        int n = string.toLowerCase().indexOf("order by");
        if (n > 0 && !DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(string.substring(n));
        }
        stringBuffer.append(") as rownumber_,");
        return stringBuffer.toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public String quartzDelegateClass() {
        return "";
    }
}

