/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.DB2Dialect;
import com.fr.data.core.db.dialect.DB2V6Dialect;
import com.fr.data.core.db.dialect.DB2V7Dialect;
import com.fr.data.core.db.dialect.DB2V8Dialect;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.MSSQL2000Dialect;
import com.fr.data.core.db.dialect.MSSQL2005Dialect;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.core.db.dialect.Oracle8iDialect;
import com.fr.data.core.db.dialect.OracleDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DialectFactory {
    private static Dialect defaultDialect;
    private static Map dialectMap;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$MSSQLDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$AccessDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$SybaseDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$HSQLDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$H2Dialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$MySQLDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$PostgreSQLDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$DerbyDialect;
    static /* synthetic */ Class class$com$fr$data$core$db$dialect$InformixDialect;

    public static Dialect getDefaultDialect() {
        if (defaultDialect == null) {
            defaultDialect = new AbstractDialect();
        }
        return defaultDialect;
    }

    public static Dialect generateDialect(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            int n = -1;
            try {
                n = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isBlank(string)) {
                return DialectFactory.getDefaultDialect();
            }
            DBDialectMapper dBDialectMapper = (DBDialectMapper)dialectMap.get(string);
            if (dBDialectMapper == null) {
                return DialectFactory.getDefaultDialect();
            }
            return dBDialectMapper.getDialect(n);
        }
        catch (SQLException sQLException) {
            return DialectFactory.getDefaultDialect();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dialectMap = new HashMap();
        dialectMap.put("Oracle", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                if (n < 9) {
                    return new Oracle8iDialect();
                }
                return new OracleDialect();
            }
        });
        dialectMap.put("Microsoft SQL Server", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 8: {
                        return new MSSQL2000Dialect();
                    }
                    case 9: {
                        return new MSSQL2005Dialect();
                    }
                }
                return new MSSQLDialect();
            }
        });
        dialectMap.put("Microsoft SQL Server Database", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$MSSQLDialect == null ? (class$com$fr$data$core$db$dialect$MSSQLDialect = DialectFactory.class$("com.fr.data.core.db.dialect.MSSQLDialect")) : class$com$fr$data$core$db$dialect$MSSQLDialect).getName()));
        dialectMap.put("ACCESS", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$AccessDialect == null ? (class$com$fr$data$core$db$dialect$AccessDialect = DialectFactory.class$("com.fr.data.core.db.dialect.AccessDialect")) : class$com$fr$data$core$db$dialect$AccessDialect).getName()));
        dialectMap.put("Sybase SQL Server", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$SybaseDialect == null ? (class$com$fr$data$core$db$dialect$SybaseDialect = DialectFactory.class$("com.fr.data.core.db.dialect.SybaseDialect")) : class$com$fr$data$core$db$dialect$SybaseDialect).getName()));
        dialectMap.put("Adaptive Server Enterprise", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$SybaseDialect == null ? (class$com$fr$data$core$db$dialect$SybaseDialect = DialectFactory.class$("com.fr.data.core.db.dialect.SybaseDialect")) : class$com$fr$data$core$db$dialect$SybaseDialect).getName()));
        dialectMap.put("HSQL Database Engine", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$HSQLDialect == null ? (class$com$fr$data$core$db$dialect$HSQLDialect = DialectFactory.class$("com.fr.data.core.db.dialect.HSQLDialect")) : class$com$fr$data$core$db$dialect$HSQLDialect).getName()));
        dialectMap.put("H2", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$H2Dialect == null ? (class$com$fr$data$core$db$dialect$H2Dialect = DialectFactory.class$("com.fr.data.core.db.dialect.H2Dialect")) : class$com$fr$data$core$db$dialect$H2Dialect).getName()));
        dialectMap.put("MySQL", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$MySQLDialect == null ? (class$com$fr$data$core$db$dialect$MySQLDialect = DialectFactory.class$("com.fr.data.core.db.dialect.MySQLDialect")) : class$com$fr$data$core$db$dialect$MySQLDialect).getName()));
        dialectMap.put("PostgreSQL", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$PostgreSQLDialect == null ? (class$com$fr$data$core$db$dialect$PostgreSQLDialect = DialectFactory.class$("com.fr.data.core.db.dialect.PostgreSQLDialect")) : class$com$fr$data$core$db$dialect$PostgreSQLDialect).getName()));
        dialectMap.put("Apache Derby", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$DerbyDialect == null ? (class$com$fr$data$core$db$dialect$DerbyDialect = DialectFactory.class$("com.fr.data.core.db.dialect.DerbyDialect")) : class$com$fr$data$core$db$dialect$DerbyDialect).getName()));
        dialectMap.put("Informix Dynamic Server", new VersionInsensitiveMapper((class$com$fr$data$core$db$dialect$InformixDialect == null ? (class$com$fr$data$core$db$dialect$InformixDialect = DialectFactory.class$("com.fr.data.core.db.dialect.InformixDialect")) : class$com$fr$data$core$db$dialect$InformixDialect).getName()));
        dialectMap.put("DB2/NT", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/LINUX", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/6000", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/HPUX", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/SUN", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/LINUX390", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/AIX64", new DBDialectMapper(){

            public Dialect getDialect(int n) {
                switch (n) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
    }

    private static class VersionInsensitiveMapper
    implements DBDialectMapper {
        String dialectClass = null;

        public VersionInsensitiveMapper(String string) {
            this.dialectClass = string;
        }

        public Dialect getDialect(int n) {
            try {
                return (Dialect)FRCoreContext.classForName(this.dialectClass).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                return DialectFactory.getDefaultDialect();
            }
        }
    }

    private static interface DBDialectMapper {
        public Dialect getDialect(int var1);
    }
}

