/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class MySQLDialect
extends AbstractDialect {
    private String defaultAutoIncrease = "unsigned ";
    private String defaultAutoIncreaseEM = "auto_increment";
    private static Map yearDataMap = new HashMap();

    public MySQLDialect() {
        this.left_quote = "'";
        this.right_quote = "'";
    }

    public String column2SQL(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        if (string.startsWith("'|\\\"") && string.endsWith("'|\\\"")) {
            return "'" + string.trim().toUpperCase().substring(1, string.length() - 1) + "'";
        }
        return string;
    }

    public String columnType2SQL(int n, String string) {
        switch (n) {
            case -2: {
                return "TINYBLOB";
            }
            case 2004: {
                return "MEDIUMBLOB";
            }
            case -4: {
                return "LONGBLOB";
            }
            case 2005: {
                return "longtext";
            }
            case 4: {
                return "int";
            }
            case -1: {
                return "longtext";
            }
            case 1: {
                return "varchar(" + string + ")";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 7: {
                return "FLOAT";
            }
            case -5: {
                return "BIGINT(" + string + ")";
            }
            case 5: {
                return "SMALLINT(" + string + ")";
            }
            case -7: {
                return "VARCHAR(1)";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    public String table2SQL(Table table) {
        return super.table2SQL(table);
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return string3 + " " + this.defaultAutoIncrease + this.defaultAutoIncreaseEM;
    }

    public String getIdentitySelectString() {
        return "select last_insert_id()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, int n, int n2) {
        return new StringBuffer(string.length() + 20).append(string).append(" limit " + n + ", " + n2).toString();
    }

    public boolean isYearData(Connection connection, int n, Table table, String string) {
        if (n != 91) {
            return false;
        }
        CTC cTC = new CTC(connection, table, string);
        if (yearDataMap.get(cTC) == null) {
            boolean bl = this.isYear(connection, table, string);
            yearDataMap.put(cTC, new Boolean(bl));
            return bl;
        }
        return (Boolean)yearDataMap.get(cTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean isYear(Connection connection, Table table, String string) {
        block12: {
            PreparedStatement preparedStatement;
            block11: {
                String string2 = "select " + string + " from " + table.toString();
                preparedStatement = null;
                preparedStatement = connection.prepareStatement(string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (!resultSetMetaData.getColumnTypeName(1).equalsIgnoreCase("YEAR")) break block11;
                boolean bl = true;
                Object var10_11 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                }
                return bl;
            }
            Object var10_12 = null;
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException2) {
                        FRContext.getLogger().log(Level.WARNING, sQLException2.getMessage(), sQLException2);
                    }
                    Object var10_13 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException3) {
                        FRContext.getLogger().log(Level.WARNING, sQLException3.getMessage(), sQLException3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                }
                throw throwable;
            }
        }
        return false;
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.MSSQLDelegate";
    }

    private class CTC {
        private String url = null;
        private String user = null;
        private Table table = null;
        private String columnName = null;

        public CTC(Connection connection, Table table, String string) {
            try {
                this.url = connection.getMetaData().getURL();
                this.user = connection.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
            this.table = table;
            this.columnName = string;
        }

        public int hashCode() {
            int n = 0;
            n = 37 * n + this.url.hashCode();
            n = 37 * n + this.user.hashCode();
            n = 37 * n + this.table.hashCode();
            n = 37 * n + this.columnName.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CTC)) {
                return false;
            }
            CTC cTC = (CTC)object;
            return ComparatorUtils.equals(this.url, cTC.url) && ComparatorUtils.equals(this.user, cTC.user) && ComparatorUtils.equals(this.table, cTC.table) && ComparatorUtils.equals(this.columnName, cTC.columnName);
        }
    }
}

