/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class OracleDialect
extends AbstractDialect {
    private int oracleFetchSize = 50;
    private String sequenceName = "";
    private String table = "";
    private String column = "";

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public OracleDialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    public int getFetchSize() {
        return this.oracleFetchSize;
    }

    public void setFetchSize(int n) {
        this.oracleFetchSize = n;
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        try {
            this.createOracleSequence(connection, string, string2);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        return string3;
    }

    private void createOracleSequence(Connection connection, String string, String string2) throws SQLException {
        String string3;
        this.sequenceName = string3 = (string.substring(1, string.length() - 1) + "_sequence").toUpperCase();
        this.table = string;
        this.column = string2;
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop sequence " + string3.toUpperCase());
            statement.close();
        }
        catch (Exception exception) {
            statement.close();
        }
        PreparedStatement preparedStatement = connection.prepareStatement("create sequence " + string3 + " start with 1 increment by 1 minvalue 0 maxvalue 999999999999 cycle nocache");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static String getOracleIncNextValue(String string) {
        return string + "_SEQUENCE.nextval";
    }

    public static String getOravleIncCURRValue(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string + "_SEQUENCE.CURRVAL";
    }

    public String getIdentitySelectString(String string, String string2, int n) throws Exception {
        return "select " + OracleDialect.getOravleIncCURRValue(string) + " from dual";
    }

    public void createTrigger(Connection connection) {
        if (StringUtils.isBlank(this.sequenceName)) {
            return;
        }
        String string = this.table.substring(1, this.table.length() - 1) + "Trigger";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.column;
        if (this.column.matches("^\".*\"$")) {
            string2 = this.column.substring(1, this.column.length() - 1);
        }
        stringBuffer.append("create or replace trigger ").append(string).append(" before insert on ").append(this.table).append(" for each row begin select ").append(this.sequenceName).append(".nextval into :new.").append(string2).append(" from dual; end;");
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().log(Level.WARNING, sQLException2.getMessage(), sQLException2);
            }
        }
    }

    public String columnType2SQL(int n, String string) {
        switch (n) {
            case 16: {
                return "NUMBER(1,0)";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "NUMBER(" + string + ")";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "NUMBER(" + string + ")";
            }
            case -3: 
            case -2: {
                return "RAW(" + string + ")";
            }
            case -4: {
                return "LONG RAW";
            }
            case -1: {
                return "LONG";
            }
            case 12: {
                return "VARCHAR2(" + string + ")";
            }
            case 1: {
                return "CHAR(" + string + ")";
            }
            case 1111: {
                return "NCLOB";
            }
            case -7: {
                return "VARCHAR2(1)";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    private String getOracleSQL(String string, boolean bl) {
        String string2 = "";
        if (!bl) {
            string2 = "select owner,table_name from all_tables where tablespace_name<>'SYSTEM' and tablespace_name<>'SYSAUX'";
            if (!StringUtils.isBlank(string)) {
                string2 = string2 + " and owner='" + string + "'";
            }
        } else {
            string2 = "select owner,table_name from all_tables";
            if (!StringUtils.isBlank(string)) {
                string2 = string2 + " where owner='" + string + "'";
            }
        }
        return string2;
    }

    public List getTableProcedure(Connection connection, String string, boolean bl) throws Exception {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = this.getOracleSQL(string, bl);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(new TableProcedure(resultSet.getString("owner"), resultSet.getString("table_name"), "TABLE"));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, int n, int n2) {
        string = string.trim();
        boolean bl = false;
        if (string.toLowerCase().endsWith(" for update")) {
            string = string.substring(0, string.length() - 11);
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        stringBuffer.append(string);
        stringBuffer.append(" ) row_ where rownum <= " + (n + n2) + ") where rownum_ > " + n);
        if (bl) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
    }
}

