/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class CreateTable
extends AbstractDML {
    private List columnsList = new ArrayList();
    private String checkFilter = null;
    private String foreignReference = null;

    public CreateTable(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public CreateTable(Table table, Dialect dialect) {
        super(table, dialect);
    }

    public void addColumn(Column column) {
        this.columnsList.add(column);
    }

    public void clearColumn() {
        this.columnsList.clear();
    }

    public Column getColumn(int n) {
        return (Column)this.columnsList.get(n);
    }

    public int getColumnSize() {
        return this.columnsList.size();
    }

    public void addColumn(String string, int n, int n2) {
        this.addColumn(string, n, n2, false, null, false, false);
    }

    public void addColumn(String string, int n, int n2, Boolean bl, String string2, Boolean bl2) {
        this.addColumn(string, n, n2, bl, string2, bl2, false);
    }

    public void addColumn(String string, int n, int n2, Boolean bl, Object object, Boolean bl2, Boolean bl3) {
        Column column = new Column();
        column.setName(string);
        column.setValueType(n);
        column.setColumnSize(new ColumnSize(n2));
        column.setAllowNull(bl == false);
        column.setDefaultValue(object);
        column.setPrimaryKey(bl3);
        column.setSelfIncrease(bl2);
        this.addColumn(column);
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (connection == null || this.getTable() == null || this.dialect == null) {
            return null;
        }
        String string = this.toStatementSQLString(this.dialect, connection);
        FRContext.getLogger().log(Level.INFO, string.toString());
        System.out.println(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        return preparedStatement;
    }

    public String toStatementSQLString(Dialect dialect, Connection connection) {
        String string;
        String string2;
        String string3;
        if (this.getTable() == null) {
            return null;
        }
        if (this.columnsList.isEmpty()) {
            return null;
        }
        String string4 = this.getTable().toStatementSQLString(dialect);
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE ");
        stringBuffer.append(string4).append("(");
        int n = this.columnsList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getColumn(i).toSQL(dialect, connection, string4));
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        if (!(dialect instanceof SybaseDialect) && StringUtils.isNotBlank(string3 = this.createPrimaryKeySQL())) {
            stringBuffer.append(",").append(string3);
        }
        if (StringUtils.isNotBlank(string2 = this.createForeignKeySQL())) {
            stringBuffer.append(",").append(string2);
        }
        if (StringUtils.isNotBlank(string = this.createCheckSQL())) {
            stringBuffer.append(",").append(string);
        }
        stringBuffer.append(")");
        FRContext.getLogger().log(Level.INFO, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String getCheckFilter() {
        return this.checkFilter;
    }

    public void setCheckFilter(String string) {
        this.checkFilter = string;
    }

    public String getForeignReference() {
        return this.foreignReference;
    }

    public void setForeignReference(String string) {
        this.foreignReference = string;
    }

    private String createCheckSQL() {
        if (StringUtils.isBlank(this.getCheckFilter())) {
            return "";
        }
        return "CHECK " + this.getCheckFilter();
    }

    private String createPrimaryKeySQL() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!this.getColumn(i).isPrimaryKey()) continue;
            arrayList.add(this.getColumn(i));
        }
        if (arrayList.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("PRIMARY KEY (");
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.dialect.column2SQL(((Column)arrayList.get(n)).getName()));
            if (n >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String createForeignKeySQL() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!this.getColumn(i).isForeignKey()) continue;
            arrayList.add(this.getColumn(i));
        }
        if (arrayList.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("FOREIGN KEY (");
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.dialect.column2SQL(((Column)arrayList.get(n)).getName()));
            if (n >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") REFERENCES ");
        stringBuffer.append(this.getForeignReference());
        return stringBuffer.toString();
    }
}

